﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;


namespace FortranInfoEditor
{
    public partial class TranInfoPatternForm : Form
    {
        FortranInfoEditForm m_csInfoEditForm = null;

        bool m_bNewDtFlg = true; // =true:新規作成、false:修正

        bool m_bRcvSndPtnFlg = false; // false : receive,  true : send

        McTranInfoPattern m_csTrnInfPtn = new McTranInfoPattern(new HySID(""), new HySObjectKind(""), "");

        HySDataCharacteristicInCell m_csCharaInf = null;

        public TranInfoPatternForm(FortranInfoEditForm csInfoEditForm,bool bNewDtFlg, bool bRcvSndPtnFlg, McTranInfoPattern csTrnInfPtn)
        {
            m_bNewDtFlg = bNewDtFlg;
            m_csInfoEditForm = csInfoEditForm;
            m_bRcvSndPtnFlg = bRcvSndPtnFlg;

            InitializeComponent();

            if (csTrnInfPtn != null)
            {
                m_csTrnInfPtn = csTrnInfPtn;
                HySDataCharacteristicInCell csCharaInf = m_csTrnInfPtn.GetCellDataCharacteristic();

                PtnNameTextBox.Text= m_csTrnInfPtn.GetName().ToString();
                if (m_csTrnInfPtn.GetTranDataKind() == McTranInfoDefine.SINGLE_CELL_SERIAL)
                {   TrnDataComboBox.SelectedIndex = 0; }
                else if (m_csTrnInfPtn.GetTranDataKind() == McTranInfoDefine.D1_CELL_SERIAL)
                {   TrnDataComboBox.SelectedIndex = 1; }
                else if (m_csTrnInfPtn.GetTranDataKind() == McTranInfoDefine.D2_CELL_SERIAL)
                {   TrnDataComboBox.SelectedIndex = 2; }
                else if (m_csTrnInfPtn.GetTranDataKind() == McTranInfoDefine.D3_CELL_SERIAL)
                {   TrnDataComboBox.SelectedIndex = 3; }

                if (m_csTrnInfPtn.GetInterpolateType() == CommonMP.HYSSOP.CoreImpl.HySDefine.InterpolateType.LINEAR)
                {   InterpolateTypeComboBox.SelectedIndex = 0;  }
                else if (m_csTrnInfPtn.GetInterpolateType() == CommonMP.HYSSOP.CoreImpl.HySDefine.InterpolateType.NO_INTERPOLATE)
                {   InterpolateTypeComboBox.SelectedIndex = 1;  }

                m_csCharaInf = m_csTrnInfPtn.GetCellDataCharacteristic();
                if (m_csCharaInf != null)
                {
                    long lDtNum = m_csCharaInf.GetDataNumber();
                    for (int lLp = 0; lLp < lDtNum; lLp++)
                    {
                        TrnDataGridView.Rows.Add();
                        TrnDataGridView.Rows[lLp].Cells[0].Value = lLp.ToString();

                        HySObjectKind  csDtKind = m_csCharaInf.GetDataKind(lLp);
                        if (csDtKind.Equals(HySDataKindDefine.QUANTITY_OF_WATER_FLOW) == true)
                        {
                            TrnDataGridView.Rows[lLp].Cells[1].Value = "流量";
                        }
                        else if (csDtKind.Equals(HySDataKindDefine.WATER_LEVEL) == true)
                        {
                            TrnDataGridView.Rows[lLp].Cells[1].Value = "水位";
                        }
                        else if (csDtKind.Equals(HySDataKindDefine.SCALOR_VELOCITY) == true)
                        {
                            TrnDataGridView.Rows[lLp].Cells[1].Value = "流速(ｽｶﾗｰ)";
                        }
                        else if (csDtKind.Equals(HySDataKindDefine.WATER_VOLUME) == true)
                        {
                            TrnDataGridView.Rows[lLp].Cells[1].Value = "水量";
                        }
                        else if (csDtKind.Equals(HySDataKindDefine.SCALOR_PRESSURE) == true)
                        {
                            TrnDataGridView.Rows[lLp].Cells[1].Value = "圧力";
                        }
                        else if (csDtKind.Equals(HySDataKindDefine.CONCENTRATION) == true)
                        {
                            TrnDataGridView.Rows[lLp].Cells[1].Value = "濃度";
                        }
                        else if (csDtKind.Equals(HySDataKindDefine.FLOODING_WATER_DEPTH) == true)
                        {
                            TrnDataGridView.Rows[lLp].Cells[1].Value = "浸水深";
                        }
                    }
                }
            }
            else
            {
                PtnNameTextBox.Text = "新規パターン";
                TrnDataComboBox.SelectedIndex = 0;
                InterpolateTypeComboBox.SelectedIndex = 0;
            }
        }

        private void AddCellButton_Click(object sender, EventArgs e)
        {
            TrnDataGridView.Rows.Add();
            int iDispCnt = TrnDataGridView.RowCount - 1;
            TrnDataGridView.Rows[iDispCnt].Cells[0].Value = iDispCnt.ToString();
            //TrnDataGridView.Rows[iDispCnt].Cells[1].Value =0;
            TrnDataGridView.Rows[iDispCnt].Cells[2].Value = "";

        }

        private void DelCellButton_Click(object sender, EventArgs e)
        {
            int iClm = TrnDataGridView.CurrentCell.RowIndex;
            TrnDataGridView.Rows.RemoveAt(iClm);
            int iClmNum = TrnDataGridView.RowCount;
            for (int iL = 0; iL < iClmNum; iL++)
            {
                TrnDataGridView.Rows[iL].Cells[0].Value = iL.ToString();
            }
        }

        private void OKButton_Click(object sender, EventArgs e)
        {
            int iClmNum = TrnDataGridView.RowCount;
            m_csCharaInf = m_csTrnInfPtn.CreateCellDataCharacteristic(iClmNum);
            for (int iL = 0; iL < iClmNum; iL++)
            {
                if ((string)TrnDataGridView.Rows[iL].Cells[1].Value == "水位")
                {
                    m_csCharaInf.SetDataKind(iL, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");//(string)TrnDataGridView.Rows[iL].Cells[2].Value);
                }
                else if ((string)TrnDataGridView.Rows[iL].Cells[1].Value == "流量")
                {
                    m_csCharaInf.SetDataKind(iL, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); //(string)TrnDataGridView.Rows[iL].Cells[2].Value);
                }
                else if ((string)TrnDataGridView.Rows[iL].Cells[1].Value == "流速(ｽｶﾗｰ)")
                {
                    m_csCharaInf.SetDataKind(iL, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");//(string)TrnDataGridView.Rows[iL].Cells[2].Value);
                }
                else if ((string)TrnDataGridView.Rows[iL].Cells[1].Value == "水量")
                {
                    m_csCharaInf.SetDataKind(iL, "水量", HySDataCharacteristicInCell.DATA_KIND.WATER_VOLUME, "m3");//(string)TrnDataGridView.Rows[iL].Cells[2].Value);
                }
                else if ((string)TrnDataGridView.Rows[iL].Cells[1].Value == "圧力")
                {
                    m_csCharaInf.SetDataKind(iL, "圧力", HySDataCharacteristicInCell.DATA_KIND.SCALOR_PRESSURE, "N/m2");//(string)TrnDataGridView.Rows[iL].Cells[2].Value);
                }
                else if ((string)TrnDataGridView.Rows[iL].Cells[1].Value == "濃度")
                {
                    m_csCharaInf.SetDataKind(iL, "濃度", HySDataCharacteristicInCell.DATA_KIND.SCALOR_PRESSURE, "mg/Kg");//(string)TrnDataGridView.Rows[iL].Cells[2].Value);
                }
                else if ((string)TrnDataGridView.Rows[iL].Cells[1].Value == "浸水深")
                {
                    m_csCharaInf.SetDataKind(iL, "浸水深", HySDataCharacteristicInCell.DATA_KIND.FLOODING_WATER_DEPTH, "m");//(string)TrnDataGridView.Rows[iL].Cells[2].Value);
                }
            }
            m_csTrnInfPtn.SetCellDataCharacteristic(m_csCharaInf);

            m_csTrnInfPtn.SetName(new HySString((string)PtnNameTextBox.Text));

            if (TrnDataComboBox.SelectedIndex == 0)
            {
                m_csTrnInfPtn.SetTranDataKind(McTranInfoDefine.SINGLE_CELL_SERIAL);
            }
            else if (TrnDataComboBox.SelectedIndex == 1)
            {
                m_csTrnInfPtn.SetTranDataKind(McTranInfoDefine.D1_CELL_SERIAL);
            }
            else if (TrnDataComboBox.SelectedIndex == 2)
            {
                m_csTrnInfPtn.SetTranDataKind(McTranInfoDefine.D2_CELL_SERIAL);
            }
            else if (TrnDataComboBox.SelectedIndex == 3)
            {
                m_csTrnInfPtn.SetTranDataKind(McTranInfoDefine.D3_CELL_SERIAL);
            }

            if (InterpolateTypeComboBox.SelectedIndex == 0)
            {
                m_csTrnInfPtn.SetInterpolateType(CommonMP.HYSSOP.CoreImpl.HySDefine.InterpolateType.LINEAR);
            }
            else if (InterpolateTypeComboBox.SelectedIndex == 1)
            {
                m_csTrnInfPtn.SetInterpolateType(CommonMP.HYSSOP.CoreImpl.HySDefine.InterpolateType.NO_INTERPOLATE);
            }

            m_csInfoEditForm.AddSndRcvPtn(m_bNewDtFlg, m_bRcvSndPtnFlg, m_csTrnInfPtn);

            this.Close();
        }

        private void CnclButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void TrnDataComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {

        }

        private void InterpolateTypeComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {

        }
    }
}
