﻿// <summary>ソースコード：ＨＹＭＣＯ演算モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB.GACtlTools
{    
    /// <summary><para>class outline:</para>
    /// <para>遺伝子情報を保持する染色体</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// </remarks>
    public interface GAChromosomeIF
    {
        // 発生
        /// <summary><para>method outline:</para>
        /// <para>演算モデル固体クラス発生</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GACreatureIF csCreature = Genesis() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデル固体クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>自遺伝子内容から演算モデル固体を発生させる</para>
        /// </remarks>
        GACreatureIF Genesis();
        
        // 複製
        /// <summary><para>method outline:</para>
        /// <para>遺伝子情報複製</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> GAChromosomeIF csChromosome = Copy() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>伝子情報を保持する染色体クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        GAChromosomeIF Copy();
        
        // 突然変異
        /// <summary><para>method outline:</para>
        /// <para>遺伝子への突然変異発生</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = Mutation(dRatio)</para>
        /// </example>
        /// <param name="dRatio">変異率（０～１）</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool Mutation(double dRatio);

        // 交鎖
        /// <summary><para>method outline:</para>
        /// <para>遺伝子間の交鎖発生</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = CrossOver(csOther,dRatio)</para>
        /// </example>
        /// <param name="csOther">交鎖する相手方遺伝子</param>
        /// <param name="dRatio">交鎖発生率率（０～１）</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool CrossOver(ref GAChromosomeIF csOther, double dRatio);

        /// <summary><para>method outline:</para>
        /// <para>遺伝子情報のファイル書き出し</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = FileOut(csFileNameWithPath)</para>
        /// </example>
        /// <param name="csFileNameWithPath">ファイル名称</param>
        /// <returns>0 :正常 , -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long FileOut(String csFileNameWithPath);

        /// <summary><para>method outline:</para>
        /// <para>遺伝子情報のファイル読み込み</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = FileIn(csFileNameWithPath)</para>
        /// </example>
        /// <param name="csFileNameWithPath">ファイル名称</param>
        /// <returns>0 :正常 , -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long FileIn(String csFileNameWithPath);
    }
}
