﻿// <summary>ソースコード：ＨＹＭＣＯ演算モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB.GACtlTools
{
    /// <summary><para>class outline:</para>
    /// <para>染色体を解読して生成されたモデル固体</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// </remarks>
    public interface GACreatureIF
    {
        /// <summary><para>method outline:</para>
        /// <para>固体の環境適合度取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>　double dFitVal = GetFitValue()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>固体の環境適合度</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>大きいほど固体は環境に適合している</para>
        /// </remarks>
        double GetFitValue();

        // 適合度リセット
        /// <summary><para>method outline:</para>
        /// <para>固体の環境適合度値リセット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>　ResetFitness()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void ResetFitness();

        // 初期化（パターン毎）
        /// <summary><para>method outline:</para>
        /// <para>進化計算前にモデルを初期化する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = InitalCompetition(csInitialData,lInputDataNum,csInputCellData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        bool InitalCompetition(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData);

        // 固体の動作
        /// <summary><para>method outline:</para>
        /// <para>進化計算する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = Competition(lInputDataNum,csInputCellData)</para>
        /// </example>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>0 :正常 , -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long Competition(long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData);

        // 適合度計算
        /// <summary><para>method outline:</para>
        /// <para>適合度計算</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>double dFitVal = CalFitness(csCellDtArry)</para>
        /// </example>
        /// <param name="csCellDtArry">適合度計算の為の比較基準データ</param>
        /// <returns>double 適合度</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        double CalFitness(ref HySCellData[] csCellDtArry);

        // 計算結果出力
        /// <summary><para>method outline:</para>
        /// <para>進化計算中にモデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = OutCompetition( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>0 :正常 , -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        long OutCompetition(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData);

    }
}
