﻿// <summary>ソースコード：ＨＹＭＣＯ演算モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB.GACtlTools
{
    /// <summary><para>class outline:</para>
    /// <para>モデル進化を行うステージ（舞台）</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>
    /// 本ステージ上で　複数の固体が生存競争を行う
    /// </para>
    /// </remarks>
    interface GAEvolutionIF
    {

        /// <summary><para>method outline:</para>
        /// <para>動作モード設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetMode(bSW)</para>
        /// </example>
        /// <param name="bSW">進化計算モード：true=進化計算中、false=通常計算</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 進化モード：true  の時には進化計算を行わせる。
        /// 進化モード：false の時には進化後のスーパーエリートが動作する
        /// </para>
        /// </remarks>
        void SetMode(bool bSW);

        /// <summary><para>method outline:</para>
        /// <para>遺伝子設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetChromosomes(lNumIndividual,csChromosome)</para>
        /// </example>
        /// <param name="lNumIndividual">遺伝子の数</param>
        /// <param name="csChromosome">遺伝子情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// ステージ（舞台）内に　これから進化する固体の遺伝子を設定する
        /// </para>
        /// </remarks>
        void SetChromosomes(long lNumIndividual, GAChromosomeIF[] csChromosome);


        // 世代リセット
        /// <summary><para>method outline:</para>
        /// <para>進化世代数のリセット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ResetGeneration( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        void ResetGeneration();

        // 適合度リセット
        /// <summary><para>method outline:</para>
        /// <para>各個体の環境適合度のリセット</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ResetFitness( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>１世代毎にリセットを行う</para>
        /// </remarks>
        void ResetFitness();

        // 繁殖
        /// <summary><para>method outline:</para>
        /// <para>繁殖</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Breeding( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 適合度に応じて、次世代の遺伝子を残す
        /// （適合度の高い固体ほど、多くの遺伝子を残す）
        /// 繁殖は、１世代の計算が終了の後、行う
        /// </para>
        /// </remarks>
        void Breeding();
    }
}
