﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;


namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImple.GAModelSampleLIB.GeneticAlgorithmModelSampleFactory();
        }
    }
}

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// </remarks>
    public class GeneticAlgorithmModelSampleFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return GeneticAlgorithmSampleDefine.MODEL_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;

            if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAControl_MODEL_KIND) == true)
            {
                csCalModel = new GAControlSample();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAEvolution_MODEL_KIND) == true)
            {
                csCalModel = new GAEvolutionSample();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveEvolutionModel_MODEL_KIND) == true)
            {
                csCalModel = new GAKinematicWaveEvolutionModel();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.TEST_FILE_IN_KIND) == true)
            {
                csCalModel = new GATestINFileModel();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND) == true)
            {
                csCalModel = new GAKinematicWaveRefMdl();
            }
            //<@Add_CreateCalModel/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAControl_MODEL_KIND) == true)
            {
                csCalInfoData = new GAControlSampleCalInfo();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAEvolution_MODEL_KIND) == true)
            {
                csCalInfoData = new GAEvolutionSampleCalInfo();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveEvolutionModel_MODEL_KIND) == true)
            {
                csCalInfoData = new GAKinematicWaveEvolutionModelCalInfo();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.TEST_FILE_IN_KIND) == true)
            {
                csCalInfoData = new GATestINFileInfo();
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND) == true)
            {
                csCalInfoData = new GAKinematicWaveRefMdlCalInfo();
            }
            //<@Add_CreateCalInfo/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo( csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAControl_MODEL_KIND) == true)
            {   // 遺伝子アルゴリズム計算制御
                csRtnCellPrptyDt = new GAControlPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(1); // δT設定
                csRtnCellPrptyDt.AddInfoType("m_bEvCalMode", "進化計算モード（=1:進化中、=0:進化終了後）", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_bEvCalMode", 0);

                csRtnCellPrptyDt.AddInfoType("m_lCreatureNum", "進化固体数", McDefine.ValKind.LONG);  
                csRtnCellPrptyDt.SetInfo("m_lCreatureNum", 200);
                csRtnCellPrptyDt.AddInfoType("m_lEvGenerationNum", "進化計算世代交代数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lEvGenerationNum", 1000);
                csRtnCellPrptyDt.AddInfoType("m_csEVPatternDefFileName", "進化学習用パターン定義ファイル名", McDefine.ValKind.STRING);
                //csRtnCellPrptyDt.SetInfo("m_csEVPatternDefFileName", "..\\ModelData\\GASample\\GAPatternDefinition.xml");
                csRtnCellPrptyDt.SetInfo("m_csEVPatternDefFileName", "InputData\\GASample\\GAPatternDefinition.xml");

                csRtnCellPrptyDt.AddInfoType("m_csEVInputCalElmName", "計算データ入力", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csEVInputCalElmName", "進化時上流端流量入力");
                csRtnCellPrptyDt.AddInfoType("m_csEVRefCalElmName", "参照データ入力", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csEVRefCalElmName", "進化時比較水位データ");
                csRtnCellPrptyDt.AddInfoType("m_csEvolutionMdlName", "進化計算要素モデル名", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csEvolutionMdlName", "進化モデル");

                csRtnCellPrptyDt.AddInfoType("m_lCalElmNumber", "要素数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCalElmNumber", 15);
                csRtnCellPrptyDt.AddInfoType("m_lCelDivNumber", "要素内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelDivNumber", 5);

                // ★★★　制御グループ要素はパターン設定不要　★★★
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAEvolution_MODEL_KIND) == true)
            {   // 進化計算ステージ
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(60); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCalElmNumber", "要素数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCalElmNumber", 15);
                csRtnCellPrptyDt.AddInfoType("m_lCelDivNumber", "要素内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelDivNumber", 5);
                csRtnCellPrptyDt.AddInfoType("m_sChromosomeFile", "スーパーエリート遺伝子ファイル", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_sChromosomeFile", "OutputData\\GASample\\Fossil\\SuperElite.dat");

                // 受信可能なパターン
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.IN_PATTERN_TOP,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "上流端入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.IN_EVOLUTION_REF_PTN,
                      McTranInfoDefine.D1_CELL_SERIAL,
                      "進化時比較用実測値入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.OUT_EVOLUTION_FITNESS_PTN,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "適合度出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "適合度", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "any");

                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.OUT_PATTERN_ALL,
                      McTranInfoDefine.D1_CELL_SERIAL,
                      "全セル出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第３パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.OUT_PATTERN_BOTTOM,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }

            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveEvolutionModel_MODEL_KIND) == true)
            {   // 進化させる要素モデル
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.AddInfoType("m_lCalElmNumber", "要素数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCalElmNumber", 15);
                csRtnCellPrptyDt.AddInfoType("m_lCelDivNumber", "要素内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelDivNumber", 5);
                csRtnCellPrptyDt.AddInfoType("m_bReadChromosomeFlg", "遺伝子ﾌｧｲﾙ読込必要ﾌﾗｸﾞ(=0:不要,=1:必要)", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_bReadChromosomeFlg", 1);
                csRtnCellPrptyDt.AddInfoType("m_sChromosomeFile", "読み込み遺伝子ファイル", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_sChromosomeFile", "OutputData\\GASample\\Fossil\\SuperElite.dat");
                // 受信可能なパターン
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.IN_PATTERN_TOP,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "上流端入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.OUT_PATTERN_BOTTOM,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.OUT_PATTERN_ALL,
                      McTranInfoDefine.D1_CELL_SERIAL,
                      "全セル出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.TEST_FILE_IN_KIND) == true)
            {   // テスト用ＣＳＶファイル入力データクラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", "入力ファイル名（パス付き）", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "OutputData\\GASample\\EVTestFileIn1.csv");
                csRtnCellPrptyDt.AddInfoType("m_lSeriesNum", "入力ﾃﾞｰﾀ系列数(時刻部は除く) ある時刻に複数の情報がある場合に設定が必要", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lSeriesNum", 1);
                csRtnCellPrptyDt.AddInfoType("m_lOutDataIdx", "出力系列番号(0相対) ある時刻に複数の情報がありかつ、ﾎﾟｲﾝﾄ時系列伝送ﾃﾞｰﾀに出力する時必要", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lOutDataIdx", 0);
                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        GeneticAlgorithmSampleDefine.IN_OUT_PATTERN_ANY_ONE,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "任意出力") as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(50); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意出力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        GeneticAlgorithmSampleDefine.IN_OUT_PATTERN_ANY,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "任意出力") as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(50); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意出力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }

            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(60); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", "モデル内セル分割数", McDefine.ValKind.LONG);   //"モデル内セル分割数+1"
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 5);
                csRtnCellPrptyDt.AddInfoType("m_dRough", "粗度", McDefine.ValKind.DOUBLE);   //"粗度"
                csRtnCellPrptyDt.SetInfo("m_dRough", 0.03);
                csRtnCellPrptyDt.AddInfoType("m_dSlope", "河床勾配", McDefine.ValKind.DOUBLE); //"河床勾配"
                csRtnCellPrptyDt.SetInfo("m_dSlope", 1.0 / 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dLength", "河道長", McDefine.ValKind.DOUBLE);  //"河道長"
                csRtnCellPrptyDt.SetInfo("m_dLength", 3000.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE); //"川幅"
                csRtnCellPrptyDt.SetInfo("m_dWidth", 100.0);
                // 受信可能なパターン
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.IN_PATTERN_TOP_PTN001,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "上流入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.OUT_PATTERN_BOTTOM_PTN001,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      GeneticAlgorithmSampleDefine.OUT_PATTERN_ALL_PTN001,
                      McTranInfoDefine.D1_CELL_SERIAL,
                      "全セル出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            //<@Add_CreateModelProperty/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csRtnCellPrptyDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo( csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }
            McInitialInfo csRtnDt = null;

            if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAControl_MODEL_KIND) == true)
            {
                csRtnDt = new GAControlInitialData(csLibraryID, csModelKind);
                // コーディング例
                // csRtnDt.AddInfoType("m_dData", "初期値", McDefine.ValKind.DOUBLE);
                // csRtnDt.SetInfo("m_dData", 1.0); 
                // ToDo　引数で与えられた　モデル識別子に従って、初期情報データを生成し、モデル固有設定デフォルト値を設定して下さい。
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAEvolution_MODEL_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                csRtnDt.AddInfoType("H_Initial", "初期水位", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("H_Initial", 1.2);
                csRtnDt.AddInfoType("Q_Initial", "初期流量", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 200.0);
                csRtnDt.AddInfoType("V_Initial", "初期流速", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("V_Initial", 0.84);
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveEvolutionModel_MODEL_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                csRtnDt.AddInfoType("H_Initial", "初期水位", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("H_Initial", 1.2);
                csRtnDt.AddInfoType("Q_Initial", "初期流量", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 200.0);
                csRtnDt.AddInfoType("V_Initial", "初期流速", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("V_Initial", 0.84);
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.TEST_FILE_IN_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                csRtnDt.AddInfoType("H_Initial", "初期水位", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("H_Initial", 1.2);
                csRtnDt.AddInfoType("Q_Initial", "初期流量", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 200.0);
                csRtnDt.AddInfoType("V_Initial", "初期流速", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("V_Initial", 0.84);
            }
            //<@Add_CreateModelInitialInfo/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo = null;

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_CTL, // To Do   LibraryCategoryXML.xmlに定義されている値の中で、該当するモデル種別を設定してください
                GeneticAlgorithmSampleDefine.GAControl_MODEL_KIND, // モデルの識別子
                GeneticAlgorithmSampleDefine.GAControl_MODEL_NAME, // モデルの名称
                McDefine.MODEL_TYPE_GROUP);
            csModelInfo.SetVersionInf("１．０"); // モデルのバージョン
            csModelInfo.SetSummaryInf("遺伝的アルゴリズムを制御するモデルのサンプル"); // モデルの簡単な説明
            csModelInfo.SetCreatorInf("CommonMP　サンプルモデル"); // モデル開発者名
            csModelInfo.SetIconName(new HySString(@".\GeneticAlgorithmModelFactoryID\GAModel")); // To Do モデル固有アイコン（アイコンを使用しないときは "DefaultModel" を設定してください）
            csModelInfo.SetManualFileName(@".\Sample\GAControl.pdf"); // To Do モデル固有の解説情報等あれば設定してください。
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE, // To Do   LibraryCategoryXML.xmlに定義されている値の中で、該当するモデル種別を設定してください
                GeneticAlgorithmSampleDefine.GAEvolution_MODEL_KIND, // モデルの識別子
                GeneticAlgorithmSampleDefine.GAEvolution_MODEL_NAME  // モデルの名称
            );
            csModelInfo.SetVersionInf("１．０"); // モデルのバージョン
            csModelInfo.SetSummaryInf("進化の舞台（モデルの進化が行われる環境）"); // モデルの簡単な説明
            csModelInfo.SetCreatorInf("CommonMP　サンプルモデル"); // モデル開発者名
            csModelInfo.SetIconName(new HySString(@".\GeneticAlgorithmModelFactoryID\GAModel")); // To Do モデル固有アイコン（アイコンを使用しないときは "DefaultModel" を設定してください）
            csModelInfo.SetManualFileName(@".\Sample\GAControl.pdf"); // To Do モデル固有の解説情報等あれば設定してください。
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加
            
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE, // To Do   LibraryCategoryXML.xmlに定義されている値の中で、該当するモデル種別を設定してください
                GeneticAlgorithmSampleDefine.GAKinematicWaveEvolutionModel_MODEL_KIND, // モデルの識別子
                GeneticAlgorithmSampleDefine.GAKinematicWaveEvolutionModel_MODEL_NAME  // モデルの名称
            );
            csModelInfo.SetVersionInf("１．０"); // モデルのバージョン
            csModelInfo.SetSummaryInf("進化するモデル（KinematicWaveModel内の定数値がGAの手法を用いて調整される）"); // モデルの簡単な説明
            csModelInfo.SetCreatorInf("CommonMP　サンプル"); // モデル開発者名
            csModelInfo.SetIconName(new HySString(@".\GeneticAlgorithmModelFactoryID\GAModel")); // To Do モデル固有アイコン（アイコンを使用しないときは "DefaultModel" を設定してください）
            csModelInfo.SetManualFileName(@".\Sample\GAControl.pdf"); // To Do モデル固有の解説情報等あれば設定してください。
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL, // <-- 入力要素は、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("INPUT_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                GeneticAlgorithmSampleDefine.TEST_FILE_IN_KIND, // モデルの識別子
                GeneticAlgorithmSampleDefine.TEST_FILE_IN_NAME  // モデルの名称
                              );
            csModelInfo.SetVersionInf("１．０"); // モデルのバージョン
            csModelInfo.SetSummaryInf("進化時の入力データ読み込み（ポイント，１次元変数　時系列 ＣＳＶ形式）");
            csModelInfo.SetCreatorInf("CommonMP　サンプル"); // モデル開発者名
            csModelInfo.SetIconName(new HySString(@".\GeneticAlgorithmModelFactoryID\GAModel")); // To Do モデル固有アイコン（アイコンを使用しないときは "DefaultModel" を設定してください）
            csModelInfo.SetManualFileName(@".\Sample\GAControl.pdf"); // To Do モデル固有の解説情報等あれば設定してください。
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE, // To Do   LibraryCategoryXML.xmlに定義されている値の中で、該当するモデル種別を設定してください
                GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND, // モデルの識別子
                GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_NAME  // モデルの名称
                            );
            csModelInfo.SetLibraryDispMode(false);
            csModelInfo.SetVersionInf("１．０"); // モデルのバージョン
            csModelInfo.SetSummaryInf("現実（進化する先）に相当するデータ（参照用データ）を作成するダミーモデル"); // モデルの簡単な説明
            csModelInfo.SetCreatorInf("CommonMP　サンプルモデル"); // モデル開発者名
            csModelInfo.SetIconName(new HySString(@".\GeneticAlgorithmModelFactoryID\GAModel")); // To Do モデル固有アイコン（アイコンを使用しないときは "DefaultModel" を設定してください）
            csModelInfo.SetManualFileName(@".\Sample\GAControl.pdf"); // To Do モデル固有の解説情報等あれば設定してください。
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加
            //<@Add_GetCalModelInfoList/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            return m_csCalModelInforList;
        }

    }
}
