﻿// <summary>ソースコード：モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// </remarks>
    public class GeneticAlgorithmSampleDefine
    {
        // ToDo
        // 必要と思われる定義を設定して下さい。（自DLL内クラスで共通に使用すると思われる常数）
        //
        //********************************************************************
        //============================ 注意事項 ==============================
        //********************************************************************
        //
        // メンバ変数の定義を設定する場合、以下の２点を留意願います。
        //
        //  １．個別でメンバ変数を定義する場合は、メンバ変数の前後に対して、
        //      半角空白を区切り文字として挿入して下さい。
        //
        //  ２．ウィザードにて生成されたパターン識別子のメンバ変数に付随する
        //      番号(○○○_PTNnnn)は変更しないで下さい。
        //
        //        ○○○：ウィザード画面にて入力したパターン識別子
        //        _PTN  ：ウィザード自動生成付与文字
        //        nnn   ：ウィザード自動生成番号
        //
        //********************************************************************

        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = new HySID("GeneticAlgorithmModelFactoryID");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>モデル種別</summary>
        public static readonly HySObjectKind GAControl_MODEL_KIND = new HySObjectKind("GeneticAlgorithm.GAControlMdlID");
        /// <summary>モデル名称</summary>
        public static readonly HySString GAControl_MODEL_NAME = new HySString("コーディングサンプル：遺伝的アルゴリズム制御の例");


        /// <summary>モデル種別</summary>
        public static readonly HySObjectKind GAEvolution_MODEL_KIND = new HySObjectKind("GA_EVALUTION_MDL");
        /// <summary>モデル名称</summary>
        public static readonly HySString GAEvolution_MODEL_NAME = new HySString("進化舞台モデル＿サンプル");
        /// <summary>進化時実測値入力</summary>
        public static readonly HySID IN_EVOLUTION_REF_PTN = new HySID("In_evolution_Ref");
        //// <summary>進化時比較データ計算出力</summary>
        //public static readonly HySID OUT_EVOLUTION_REF_PTN = new HySID("Out_evolution_Ref");
        /// <summary>進化時適合度出力</summary>
        public static readonly HySID OUT_EVOLUTION_FITNESS_PTN = new HySID("Out_evolution_fitness");


        /// <summary>テスト用 モデル種別</summary>
        public static readonly HySObjectKind GAKinematicWaveEvolutionModel_MODEL_KIND = new HySObjectKind("GeneticAlgorithm.GA_EVALUTION_KINEMATIC_WAVE_MDL");
        /// <summary>テスト用 モデル名称</summary>
        public static readonly HySString GAKinematicWaveEvolutionModel_MODEL_NAME = new HySString("進化モデル＿サンプル");
        /// <summary>上流端入力</summary>
        public static readonly HySID IN_PATTERN_TOP = new HySID("in_pattern_top");
        /// <summary>下流端出力</summary>
        public static readonly HySID OUT_PATTERN_BOTTOM = new HySID("out_pattern_bottom");
        /// <summary>全出力</summary>
        public static readonly HySID OUT_PATTERN_ALL = new HySID("out_pattern_all");


        /// <summary>テストファイル入力モデル種別</summary>
        public static readonly HySObjectKind TEST_FILE_IN_KIND = new HySObjectKind("GeneticAlgorithm.GATestInFileModel");
        /// <summary>テストファイル入力モデル名称</summary>
        public static readonly HySString TEST_FILE_IN_NAME = new HySString("進化時データ入力");
        /// <summary>任意</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY = new HySID("ANY");
        /// <summary>任意</summary>
        public static readonly HySID IN_OUT_PATTERN_ANY_ONE = new HySID("ANY_ONE");


        /// <summary>テスト用 モデル種別</summary>
        public static readonly HySObjectKind GAKinematicWaveRefMdl_MODEL_KIND = new HySObjectKind("GeneticAlgorithm.GARefKinematicWaveModel");
        /// <summary>テスト用 モデル名称</summary>
        public static readonly HySString GAKinematicWaveRefMdl_MODEL_NAME = new HySString("進化モデル＿テスト用比較データ作成可道モデル");
        /// <summary>上流入力</summary>
        public static readonly HySID IN_PATTERN_TOP_PTN001 = new HySID("in_pattern_top_ptn001");
        /// <summary>下流端出力</summary>
        public static readonly HySID OUT_PATTERN_BOTTOM_PTN001 = new HySID("out_pattern_bottom_ptn001");
        /// <summary>全出力</summary>
        public static readonly HySID OUT_PATTERN_ALL_PTN001 = new HySID("out_pattern_all_ptn001");
        //<@Add_> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
    }
}
