﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.OptionImple.GAModelSampleLIB.GACtlTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB
{
    /// <summary><para>class outline:</para>
    /// <para>遺伝的アルゴリズムの動作を制御する為の制御モデル用要素内演算中データクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class GAControlSampleCalInfo : McCalInfo
    {
        /// <summary>進化計算モード：true=進化計算中、false=通常計算 </summary>
        public bool m_bEvCalMode = true;

        /// <summary>固体数</summary>
        public long m_lCreatureNum = 200;
        /// <summary>進化世代数 </summary>
        public long m_lEvGenerationNum = 1000;
        /// <summary> 一回の計算(calculation) で行う世代交代の数 </summary>
        public long m_lGnrtnInclNum = 1;
        /// <summary>計算した世代数 </summary>
        public long m_lCalGeneration = 0;
        
        /// <summary>進化演算中の入力データファイル</summary>        
        public String m_csEVPatternDefFileName = null;


        /// <summary>進化学習のパターン数 </summary>
        public long m_lEvPtnNum = 0;
        /// <summary>進化シミュレーション開始時刻 </summary>
        public HySTime[] m_csEVStartTime = null;
        /// <summary>進化シミュレーション終了時刻 </summary>
        public HySTime[] m_csEVEndTime = null;
        /// <summary>進化シミュレーションデルタ </summary>
        public HySTime[] m_csEVDltTime = null;


        /// <summary>進化演算中の入力データファイル</summary>        
        public HySString[] m_csEVInputFileName = null;
        /// <summary>進化演算中の比較データファイル</summary>
        public HySString[] m_csEVRefFileName = null;

        /// <summary>進化演算入力データ読み込み要素名 </summary>
        public String m_csEVInputCalElmName = null;
        /// <summary>進化演算参照データ読み込み要素名 </summary>
        public String m_csEVRefCalElmName = null;
        /// <summary>進化演算要素名 </summary>
        public String m_csEvolutionMdlName = null;

        /// <summary>染色体</summary>
        public GAChromosomeSample[] m_csChromosome = null;

        /// <summary>１モデル内の計算要素数</summary>
        public long m_lCalElmNumber = 15;
        /// <summary>１モデルの中の要素内のセル分割数</summary>
        public long m_lCelDivNumber = 5;


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            GAControlSampleCalInfo csRtn = new GAControlSampleCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            GAControlSampleCalInfo csOrdDt = (GAControlSampleCalInfo)csOrgInfo;

            this.m_bEvCalMode = csOrdDt.m_bEvCalMode;
            this.m_lCreatureNum = csOrdDt.m_lCreatureNum;
            this.m_lEvGenerationNum = csOrdDt.m_lEvGenerationNum;
            this.m_lGnrtnInclNum = csOrdDt.m_lGnrtnInclNum;
            this.m_lCalGeneration = csOrdDt.m_lCalGeneration;

            this.m_csEVPatternDefFileName = (String)csOrdDt.m_csEVPatternDefFileName.Clone();

            this.m_lEvPtnNum = csOrdDt.m_lEvPtnNum;
            m_csEVStartTime = new HySTime[m_lEvPtnNum];
            m_csEVEndTime = new HySTime[m_lEvPtnNum];
            m_csEVDltTime = new HySTime[m_lEvPtnNum];
            m_csEVInputFileName = new HySString[m_lEvPtnNum];
            m_csEVRefFileName = new HySString[m_lEvPtnNum];
            
            for (long lLp = 0; lLp < csOrdDt.m_lEvPtnNum; lLp++)
            {
                m_csEVStartTime[lLp] = csOrdDt.m_csEVStartTime[lLp].Clone();
                m_csEVEndTime[lLp] = csOrdDt.m_csEVEndTime[lLp].Clone();
                m_csEVDltTime[lLp] = csOrdDt.m_csEVDltTime[lLp].Clone();
                m_csEVInputFileName[lLp] = csOrdDt.m_csEVInputFileName[lLp].Clone();
                m_csEVRefFileName[lLp] = csOrdDt.m_csEVRefFileName[lLp].Clone();
            }
            return true;
        }

    }
}
