﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB
{
    /// <summary><para>class outline:</para>
    /// <para>KinematicWave河川モデルを複数配置して河川を構成したモデル内演算中データクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class GAKinematicWaveEvolutionModelCalInfo : McCalInfo
    {
        /// <summary>計算要素数</summary>
        public long m_lCalElmNumber = 0;
        /// <summary>要素内のセル分割数</summary>
        public long m_lCelDivNumber = 0;

        /// <summary>遺伝子情報読み込み必要フラグ (=false:不要,=true:必要)</summary>
        public bool m_bReadChromosomeFlg=false;
        /// <summary>遺伝子情報ファイル名 </summary>
        public String m_sChromosomeFile;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            GAKinematicWaveEvolutionModelCalInfo csRtn = new GAKinematicWaveEvolutionModelCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            GAKinematicWaveEvolutionModelCalInfo csOrgDt = (GAKinematicWaveEvolutionModelCalInfo)csOrgInfo;
            this.m_lCalElmNumber = csOrgDt.m_lCalElmNumber;
            this.m_lCelDivNumber = csOrgDt.m_lCelDivNumber;

            this.m_bReadChromosomeFlg = csOrgDt.m_bReadChromosomeFlg;
            this.m_sChromosomeFile = (String)csOrgDt.m_sChromosomeFile.Clone();
            return true;
        }

    }
}
