﻿// <summary>ソースコード：ＨＹＭＣＯ演算モデルクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.GAModelSampleLIB
{
    /// <summary><para>class outline:</para>
    /// <para>比較用演算モデル</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.3][2010/10/01][新規作成]</para>
    /// </remarks>
    public class GAKinematicWaveRefMdl : McForecastModelBase
    {
        /// <summary> 演算データ（キャスト用） </summary>
        GAKinematicWaveRefMdlCalInfo m_KMdlInf = null;   // 便利の為、キャスト用に定義しておく

        //=========================
        // 演算実行前処理関連メソッド
        //=========================

        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = ReceiveConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool ReceiveConnectionCheck(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = true;
            if (lInputDataNum == 0)
            {
                // 入力が無い場合
                // エラー
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                     Properties.Resources.STATEMENT_NO_REC_DATA );
               // csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND, "No receive data.");
                bRtn = false;
            }

            for (long lP = 0; lP < lInputDataNum; lP++)
            {   // 入力する伝送データ数分繰り返します。

                if (GeneticAlgorithmSampleDefine.IN_PATTERN_TOP_PTN001.Equals(csInputCellData[lP].GetReceivePatternID()) == true)
                {
                    // Do Nothing
                }
                else
                {
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                         Properties.Resources.STATEMENT_UNEXPECT_REC_DATA_TYPE_R + csInputCellData[lP].GetUpperElementID().ToString() + ")");
                   // csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                   //     "Unexpected receive data type. (Received from " + csInputCellData[lP].GetUpperElementID().ToString() + ")");
                    bRtn = false;
                }
                long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
                long lCellDim = csInputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);

                if (lCellDim == 1 && lD1 == 1)
                {   // 1次元の１セルでならば
                    if (lCellDataNum < 1)
                    {
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                             Properties.Resources.STATEMENT_VAL_NUM_SHORT_R + csInputCellData[lP].GetUpperElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                       //     "Variable number in the Cells is too short. (Received from " + csInputCellData[lP].GetUpperElementID().ToString() + ")");
                        bRtn = false;
                    }
                }

            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>出力側の接続情報チェック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = SendConnectionCheck(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool SendConnectionCheck(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        {
            bool bRtn = true;
            if (lOutputDataNum == 0)
            {
                // 警告（エラーではない）
               // ver1.5 エラートレース日本語対応
                csErrorInf.AddCheckWarningData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND, 
                     Properties.Resources.STATEMENT_NO_SND_PORT );
               // csErrorInf.AddCheckWarningData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND, "No send port.");
            }
            for (long lP = 0; lP < lOutputDataNum; lP++)
            {   // 出力する伝送データ数分繰り返します。

                if (GeneticAlgorithmSampleDefine.OUT_PATTERN_BOTTOM_PTN001.Equals(csOutputCellData[lP].GetSendPatternID()) == true)
                {   // 最終セルだけの出力ならば
                    // Do Nothing
                }
                else if (GeneticAlgorithmSampleDefine.OUT_PATTERN_ALL_PTN001.Equals(csOutputCellData[lP].GetSendPatternID()) == true)
                {   // 全体出力ならば
                    // Do Nothing
                }
                else
                {
                    // エラー
                   // ver1.5 エラートレース日本語対応
                    csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                         Properties.Resources.STATEMENT_UNEXPECT_DATA_TYPE );
                   // csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                   //     "Unexpected send data type.");
                    bRtn = false;
                }

                long lD1 = 0; long lD2 = 0; long lD3 = 0; long lCellDataNum = 0;
                long lCellDim = csOutputCellData[lP].GetDimension(ref lD1, ref lD2, ref lD3, ref lCellDataNum);

                if (lCellDim == 1 && lD1 == 1)
                {   // １次元配列の１セルならば
                    // セル配列数が１ならば、最終セルのみ出力するものとする
                    // セル内の変数の数をチェック
                    if (lCellDataNum < 3)
                    {
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                             Properties.Resources.STATEMENT_VAL_NUM_SHORT_S + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                       //     "Variable number in the Cells is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        bRtn = false;
                    }
                }
                else if (lCellDim == 1 && lD1 > 1)
                {   // １次元配列で複数セルならば
                    // セル配列数が複数ならば、全セルの出力とする
                    // 伝送セルの配列数が　モデル内のセルの配列数よりも小さいならば
                    if (m_KMdlInf.m_lCelNumber > lD1)
                    {
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                                                Properties.Resources.STATEMENT_SELLDIM +"(" + csOutputCellData[lP].GetTranInfoKind().ToString() + ")"
                                              + Properties.Resources.STATEMENT_IS_TOO_SHORT_S + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                       //                         "Cell dimention(" + csOutputCellData[lP].GetTranInfoKind().ToString() + ") is too short. (send to " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        bRtn = false;
                    }
                    // セル内の変数の数をチェック
                    if (lCellDataNum < 3)
                    {
                       // ver1.5 エラートレース日本語対応
                        csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                             Properties.Resources.STATEMENT_VAL_NUM_SHORT_S + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                       // csErrorInf.AddCheckErrorData(this.GetID(), GeneticAlgorithmSampleDefine.GAKinematicWaveRefMdl_MODEL_KIND,
                       //     "Variable number in the Cells is too short. (Send To " + csOutputCellData[lP].GetLowerElementID().ToString() + ")");
                        bRtn = false;
                    }
                }

            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = false;
            // 引数で与えられたデータを　キャストしています。
            McInitialInfo csInDt = csInitialData as McInitialInfo;

            if (csInDt != null)
            {
                bRtn = true;
                // To Do
                // 演算データ等で初期化が必要な情報に対して、引数で与えられた初期化情報の内容を読み取って、設定します。
                double dDtH = 0.0;
                csInDt.GetInfo("H_Initial", ref dDtH);

                double dDtQ = 0.0;
                dDtQ = (200.0 + (2000.0 - 200.0) * (Math.Pow((0.0 * Math.Exp(1.0 - 0.0)), 10)));  // 仮 <-- 読み込まれると上書きされる
                csInDt.GetInfo("Q_Initial", ref dDtQ);
                dDtQ = dDtQ / m_KMdlInf.m_dWidth[0];
                double dDtV = 0.0;
                csInDt.GetInfo("V_Initial", ref dDtV);


                for (long lLp = 0; lLp < m_KMdlInf.m_lCelNumber; lLp++)
                {
                    dDtH = Math.Pow(
                               (m_KMdlInf.m_dRough[lLp] * m_KMdlInf.m_dRough[lLp] * dDtQ * dDtQ) / m_KMdlInf.m_dSlope[lLp]
                                 , 0.3);
                    dDtV = dDtQ / dDtH;

                    m_KMdlInf.m_dH[lLp] = dDtH;
                    m_KMdlInf.m_dV[lLp] = dDtV;
                    m_KMdlInf.m_dQ[lLp] = dDtQ;
                }
            }
            return bRtn;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputCellData)</para>
        /// </example>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>0 :正常 , -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long Calculate(long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "Calculate", "in");

            double dElmIn = 0.0; // 個別流入量

            double dQTopTotalIn = 0.0; // 上流総合流入量リセット
            long lQIdx = 0;  // 流量は０番目


            HySCellData csCell = null;  // 取得するセル
            for (long lP = 0; lP < m_lInputDataNum; lP++)
            {   // 入力データ数分
                csCell = csInputCellData[lP].GetInterpolatedCell(0); // セル配列の０番目のセルを取得
                dElmIn = csInputCellData[lP].Data(csCell, lQIdx);   // セル内の０番目の変数値を取得

                if (GeneticAlgorithmSampleDefine.IN_PATTERN_TOP_PTN001.Equals(csInputCellData[lP].GetReceivePatternID()) == true)
                {   // 上流端入力ならば
                    dQTopTotalIn += dElmIn;
                }
            }


            double dQin = dQTopTotalIn / m_KMdlInf.m_dWidth[0];  // 上流端総合入力

            double dTimeLag = m_csDltTime.GetTime();
            double[] dH = new double[m_KMdlInf.m_lCelNumber];

            // 始点
            dH[0] = Math.Pow(
                           (m_KMdlInf.m_dRough[0] * m_KMdlInf.m_dRough[0] * dQin * dQin) / m_KMdlInf.m_dSlope[0]
                             , 0.3);

            // 河道内の断面ごとの水位、流速、流量の算定
            double dFV = 0.0;
            for (long lLp = 1; lLp < m_KMdlInf.m_lCelNumber; lLp++)
            {
                dFV = 5.0 / 3.0 * m_KMdlInf.m_dV[lLp]
                    * (m_KMdlInf.m_dH[lLp] - m_KMdlInf.m_dH[lLp - 1])
                    / m_KMdlInf.m_dCelLength;

                dH[lLp] = m_KMdlInf.m_dH[lLp] - dFV * dTimeLag;
            }

            for (long lLp = 0; lLp < m_KMdlInf.m_lCelNumber; lLp++)
            {
                m_KMdlInf.m_dH[lLp] = dH[lLp];
                m_KMdlInf.m_dV[lLp] = (1.0 / m_KMdlInf.m_dRough[lLp])
                                      * Math.Pow(m_KMdlInf.m_dH[lLp], 2.0 / 3.0)
                                      * Math.Pow(m_KMdlInf.m_dSlope[lLp], 0.5);
                m_KMdlInf.m_dQ[lLp] = m_KMdlInf.m_dV[lLp] * m_KMdlInf.m_dH[lLp] * m_KMdlInf.m_dWidth[lLp];
            }

            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "Calculate", "out");
            return 0;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算結果を外部のエレメントに対して公開する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>long lRtn = DataFusion( lOutputDataNum, ref csOutputCellData)</para>
        /// </example>
        /// <param name="lOutputDataNum">出力情報数</param>
        /// <param name="csOutputCellData">出力情報配列</param>
        /// <returns>0 :正常 , -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override long DataFusion(long lOutputDataNum, ref McSendCellDataIF[] csOutputCellData)
        {
            HySCellData[] csSndCellData = null;
            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "DataFusion", "in");

            for (long lLp = 0; lLp < lOutputDataNum; lLp++)
            {   // 出力する伝送データ数分繰り返します。
                csSndCellData = csOutputCellData[lLp].PrepareSendCellD1();

                if (GeneticAlgorithmSampleDefine.OUT_PATTERN_BOTTOM_PTN001.Equals(csOutputCellData[lLp].GetSendPatternID()) == true)
                {   // 最終セルだけの出力ならば
                    csSndCellData[0].m_dData[0] = m_KMdlInf.m_dQ[m_KMdlInf.m_lCelNumber - 1];
                    csSndCellData[0].m_dData[1] = m_KMdlInf.m_dH[m_KMdlInf.m_lCelNumber - 1];
                    csSndCellData[0].m_dData[2] = m_KMdlInf.m_dV[m_KMdlInf.m_lCelNumber - 1];
                }
                else if (GeneticAlgorithmSampleDefine.OUT_PATTERN_ALL_PTN001.Equals(csOutputCellData[lLp].GetSendPatternID()) == true)
                {   // 全体出力ならば
                    for (long lP = 0; lP < m_KMdlInf.m_lCelNumber; lP++)
                    {
                        csSndCellData[lP].m_dData[0] = m_KMdlInf.m_dQ[lP];
                        csSndCellData[lP].m_dData[1] = m_KMdlInf.m_dH[lP];
                        csSndCellData[lP].m_dData[2] = m_KMdlInf.m_dV[lP];
                    }
                }
            }
            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "DataFusion", "out");
            return 0;
        }


        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            bool bRtn = false;
            // 使用しやすいようにキャストしておく
            m_KMdlInf = (GAKinematicWaveRefMdlCalInfo)m_csCalInfo;

            // プロパティ設定
            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {
                // 演算ステップ時刻設定
                this.m_csDltTime = new HySTime(csPrptyInfo.GetStepTime());

                bRtn = true;

                // 各種係数設定

                csPrptyInfo.GetInfo("m_lCelNumber", ref m_KMdlInf.m_lCelNumber);
                //m_csEvKMdlInf.m_lCelNumber = 15;
                double dRough = 0.03;
                csPrptyInfo.GetInfo("m_dRough", ref dRough);
                double dSloop = 1.0/2000.0;
                csPrptyInfo.GetInfo("m_dSlope", ref dSloop);
                double dWidth = 200.0;
                csPrptyInfo.GetInfo("m_dWidth", ref dWidth);

                m_KMdlInf.m_dH = new double[m_KMdlInf.m_lCelNumber];
                m_KMdlInf.m_dV = new double[m_KMdlInf.m_lCelNumber];
                m_KMdlInf.m_dQ = new double[m_KMdlInf.m_lCelNumber];
                m_KMdlInf.m_dRough = new double[m_KMdlInf.m_lCelNumber];
                m_KMdlInf.m_dSlope = new double[m_KMdlInf.m_lCelNumber];
                m_KMdlInf.m_dWidth = new double[m_KMdlInf.m_lCelNumber];
                for (long lLp = 0; lLp < m_KMdlInf.m_lCelNumber; lLp++)
                {
                    m_KMdlInf.m_dH[lLp] = 1.0;
                    m_KMdlInf.m_dV[lLp] = 0.0;
                    m_KMdlInf.m_dQ[lLp] = 0.0;
                    m_KMdlInf.m_dWidth[lLp] = dWidth;
                    m_KMdlInf.m_dRough[lLp] = dRough;
                    m_KMdlInf.m_dSlope[lLp] = dSloop;
                }
                /*
                m_csEvKMdlInf.m_dWidth[0] = 20.0; m_csEvKMdlInf.m_dWidth[1] = 20.0; m_csEvKMdlInf.m_dWidth[2] = 20.0; m_csEvKMdlInf.m_dWidth[3] = 20.0; m_csEvKMdlInf.m_dWidth[4] = 25.0;
                m_csEvKMdlInf.m_dWidth[5] = 35.0; m_csEvKMdlInf.m_dWidth[6] = 40.0; m_csEvKMdlInf.m_dWidth[7] = 30.0; m_csEvKMdlInf.m_dWidth[8] = 25.0; m_csEvKMdlInf.m_dWidth[9] = 25.0;
                m_csEvKMdlInf.m_dWidth[10] = 30.0; m_csEvKMdlInf.m_dWidth[11] = 45.0; m_csEvKMdlInf.m_dWidth[12] = 65.0; m_csEvKMdlInf.m_dWidth[13] = 90.0; m_csEvKMdlInf.m_dWidth[14] = 100.0;

                m_csEvKMdlInf.m_dSlope[0] = 1.0/400.0; m_csEvKMdlInf.m_dSlope[1] = 1.0/500.0; m_csEvKMdlInf.m_dSlope[2] = 1.0/500.0; m_csEvKMdlInf.m_dSlope[3] = 1.0/1000.0; m_csEvKMdlInf.m_dSlope[4] = 1.0/1000.0;
                m_csEvKMdlInf.m_dSlope[5] = 1.0/1000.0; m_csEvKMdlInf.m_dSlope[6] = 1.0/2000.0; m_csEvKMdlInf.m_dSlope[7] = 1.0/2000.0; m_csEvKMdlInf.m_dSlope[8] = 1.0/2000.0; m_csEvKMdlInf.m_dSlope[9] = 1.0/1000.0;
                m_csEvKMdlInf.m_dSlope[10] = 1.0/1000.0; m_csEvKMdlInf.m_dSlope[11] = 1.0/1000.0; m_csEvKMdlInf.m_dSlope[12] = 1.0/2000.0; m_csEvKMdlInf.m_dSlope[13] = 1.0/2000.0; m_csEvKMdlInf.m_dSlope[14] = 1.0/2000.0;

                m_csEvKMdlInf.m_dRough[0] = 0.04; m_csEvKMdlInf.m_dRough[1] = 0.04; m_csEvKMdlInf.m_dRough[2] = 0.05; m_csEvKMdlInf.m_dRough[3] = 0.05; m_csEvKMdlInf.m_dRough[4] = 0.05;
                m_csEvKMdlInf.m_dRough[5] = 0.03; m_csEvKMdlInf.m_dRough[6] = 0.02; m_csEvKMdlInf.m_dRough[7] = 0.02; m_csEvKMdlInf.m_dRough[8] = 0.04; m_csEvKMdlInf.m_dRough[9] = 0.04;
                m_csEvKMdlInf.m_dRough[10] = 0.03; m_csEvKMdlInf.m_dRough[11] = 0.03; m_csEvKMdlInf.m_dRough[12] = 0.02; m_csEvKMdlInf.m_dRough[13] = 0.02; m_csEvKMdlInf.m_dRough[14] = 0.01;
                */

                csPrptyInfo.GetInfo("m_dLength", ref m_KMdlInf.m_dLength);
                m_KMdlInf.m_dCelLength = m_KMdlInf.m_dLength / (double)m_KMdlInf.m_lCelNumber;

            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算開始時に動作する処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = ReadyCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算開始の　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool ReadyCalculation()
        {
            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "ReadyCalculation", "in");

            // ToDo
            // 計算開始の　最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。
            // （メソッド自身を削除してください）

            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "ReadyCalculation", "out");
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算中断時に動作する処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = SuspendCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>オペレーター操作等により計算中断時に　コールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool SuspendCalculation()
        {
            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "SuspendCalculation", "in");

            // ToDo
            // オペレーター操作等により計算中断時に　コールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。
            // （メソッド自身を削除してください）

            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "SuspendCalculation", "out");
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>計算終了時に動作する処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>bool bRtn = CompleteCalculation( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>計算終了時　最後の最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。</para>
        /// </remarks>
        public override bool CompleteCalculation()
        {
            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "CompleteCalculation", "in");

            // ToDo
            // 計算終了時　最後の最初に１回だけコールされるメソッドです。不要ならば、本メソッドをオーバーライドする必要はありません。
            // （メソッド自身を削除してください）

            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "CompleteCalculation", "out");
            return true;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算用刻み時間を自動的に変更する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>ChangeDeltaTimeAutomatically()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void ChangeDeltaTimeAutomatically()
        {
            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "ChangeDeltaTimeAutomatically", "in");

            // ToDo
            // 演算中条件によって　自身のδTを(this.m_csDltTime) を変更するメソッドです。
            // 不要ならば、本メソッドをオーバーライドする必要はありません。（メソッド自身を削除してください）

            //McLog.DebugOut(GetSimulationTime(), GetID(), "MyModel", "ChangeDeltaTimeAutomatically", "out");
        }

    }
    //
}
