﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Data;

namespace CommonMP.HYMCO.OptionImpl.McConvergenceSample
{
    /// <summary><para>class outline:</para>
    /// <para>テスト要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McCnvElmSampleTestCalInfo : McCalInfo
    {
        /// <summary> 振る舞い者識別 </summary>
        public string m_sObjID = "";
        /// <summary> 総量 </summary>
        public double m_dTtlVal = -1000.0;

        /// <summary> 総量制限値 </summary>
        public double m_dTtlLimit = 1000.0;
        /// <summary> 係数 </summary>
        public double m_dA = 123.0;
        /// <summary> 係数 </summary>
        public double m_dB = 89.0;
        /// <summary> 変数 </summary>
        public double m_X = 0.0;
        /// <summary> 変数 </summary>
        public double m_Y = 0.0;

        /// <summary> 出力値 </summary>
        public double m_dOutDt = -99.999;
        ///// <summary> 最終出力時刻 </summary>
        //public HySTime m_csLastOutTime = new HySTime(0);

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McCnvElmSampleTestCalInfo csRtn = new McCnvElmSampleTestCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McCnvElmSampleTestCalInfo csOrgDt = (McCnvElmSampleTestCalInfo)csOrgInfo;
            this.m_sObjID = csOrgDt.m_sObjID;
            this.m_dTtlVal = csOrgDt.m_dTtlVal;
            this.m_dTtlLimit = csOrgDt.m_dTtlLimit;
            this.m_dA = csOrgDt.m_dA;
            this.m_dB = csOrgDt.m_dB;
            this.m_X = csOrgDt.m_X;
            this.m_Y = csOrgDt.m_Y;
            this.m_dOutDt = csOrgDt.m_dOutDt;
            //csRtn.m_csLastOutTime = this.m_csLastOutTime.Clone();
            return true;
        }

    }
}
