﻿// <summary>ソースコード：サンプル要素内演算中データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>水理公式集例題２－２より　不定流計算（Diffusion wave)モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/11/11][新規作成]</para>
    /// <para>remarks</para>
    /// <para>
    /// 演算中の状態、初期条件等を保持するデータクラス
    /// FORTRAN COMMON 変数に相当
    /// </para>
    /// </remarks>
    [Serializable]
    public class McDiffusionWaveLaneCalInfo : McCalInfo
    {
        // 計算用データの変数
        /// <summary>セル番号</summary>
        public long m_lCelNumber = 50;
        /// <summary>Ｈ</summary>
        public double[] m_dH = null;
        /// <summary>Ｈ1</summary>
        public double[] m_dH1 = null;
        /// <summary>Ｖ</summary>
        public double[] m_dV = null;
        /// <summary>Ｑ</summary>
        public double[] m_dQ = null;

        /// <summary>祖度</summary>
        public double m_dRough = 0.03;
        /// <summary>傾斜</summary>
        public double m_dSlope = 1.0/2000.0;

        /// <summary>長さ</summary>
        public double m_dLength = 100000.0;
        /// <summary>幅</summary>
        public double m_dWidth = 200.0;
        /// <summary>セル長</summary>
        public double m_dCelLength = 100000.0 / 50.0;


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McDiffusionWaveLaneCalInfo csRtn = new McDiffusionWaveLaneCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McDiffusionWaveLaneCalInfo csOrgDt = (McDiffusionWaveLaneCalInfo)csOrgInfo;
            
            this.m_lCelNumber = csOrgDt.m_lCelNumber;

            this.m_dH = new double[csOrgDt.m_lCelNumber+1];
            this.m_dH1 = new double[csOrgDt.m_lCelNumber+1];
            this.m_dV = new double[csOrgDt.m_lCelNumber+1];
            this.m_dQ = new double[csOrgDt.m_lCelNumber+1];

            for (long lLp = 0; lLp <= csOrgDt.m_lCelNumber; lLp++)
            {
                this.m_dH[lLp] = csOrgDt.m_dH[lLp];
                this.m_dH1[lLp] = csOrgDt.m_dH1[lLp];
                this.m_dV[lLp] = csOrgDt.m_dV[lLp];
                this.m_dQ[lLp] = csOrgDt.m_dQ[lLp];
            }

            this.m_dRough = csOrgDt.m_dRough;
            this.m_dSlope = csOrgDt.m_dSlope;

            this.m_dLength = csOrgDt.m_dLength;
            this.m_dWidth = csOrgDt.m_dWidth;
            this.m_dCelLength = csOrgDt.m_dCelLength;

            return true;
        }

    }
}
