﻿// <summary>ソースコード：テスト用流量発生演算中データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;


using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>水理公式集例題１－９より　Kinematic wave 法による流出計算 （直接差分法）モデル内演算データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/11/11][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    class McKinematicWaveBasinCalInfo : McCalInfo
    {
        // 計算専用変数
        public long  nx;              /* 空間差分間隔の個数 (差分の節点数は nx+1 である) */
        //public long it;               /* 差分の繰り返し回数 */
        //public long ih;               /* 水深を出力する時刻の回数 */
        public long type_qh_equation; /* 1 のとき，ダルシー式(中間流) */
                                      /* 2 のとき，マニング式(地表面流) */
                                      /* 3 のとき，椎葉式(中間流＋地表面流) */
        public long type_scheme;      /* 1 のとき，Lax Wendroff スキーム */
                                      /* 2 のとき，4 点陰形式スキーム */

 
        public double delta_t;          /* 差分の時間間隔 (hr) */
        public double delta_tq;         /* 流出量の計算結果を出力する時間間隔 (hr) */
        public double[] m_dNextTQTimeOut;
        public double delta_th;         /* 水深の計算結果を出力する時間間隔 (hr) */
        public double[] m_dNextTHTimeOut;
        //public double qetime;           /* 計算期間 (hr) */

        public double L;                /* 斜面長 (m) */
        public double theta;            /* 斜面勾配 (degree) */
        public double bu;               /* 斜面上端の幅 (m) */
        public double bl;               /* 斜面下端の幅 (m) */
        public double[] g;               /* 地形パターン関数 */
        public double[] xcos;            /* 斜面勾配の余弦 */
        public double sall;             /* 斜面の面積 (m*m) */

        //public double[] rr;              /* 降雨データを格納する配列のポインタ */
        public double rr=0.0;              /* 降雨データを格納する */
        public double[] q1;              /* 既知(現在時刻)の流量 */
        public double[] h1;              /* 既知(現在時刻)の水深 */
        public double[] q2;              /*  1 差分時間間隔先の水深 */
        public double[] h2;              /*  1 差分時間間隔先の水深 */
        //public double[] qout;            /* 流出量の計算結果を格納する配列のポインタ */
        public double qout;            /* 流出量の計算結果を格納する配列のポインタ */
        //public double[,] depth;          /* 水深の計算結果を格納する配列のポインタ */
        public double[] depth;          /* 水深の計算結果を格納する配列のポインタ */
        public double Qi;               /* 初期の単位幅流量 */
        public double Qb;               /* 斜面上端での単位幅流量 */
        public double Hb;               /* 斜面上端での水深 */
        
        public double n;                /* 粗度係数 (m^{-1/3} sec)*/
        public double k;                /* 透水係数 (cm/sec) */
        public double D;                /* A 層厚 (mm) */
        public double d;                /* 実質の A 層厚 (d = D * gamma) */
        public double gamma;            /* A 層の有効空隙率 (無次元) */
        
        public double[] alpha_a;         /* 中間流に対する流量流積関係式の係数を格納する */
                                      /* 配列のポインタ */  
        public double[] alpha_s;         /* 地表面流に対する流量流積関係式の係数を格納する */
                                      /* 配列のポインタ */
  
        public double m;                /* 流量流積関係式のべき数 */ 
        public readonly double pi= Math.PI; //3.141592654;               /* 円周率 */
        //public double[] r_time; /* 降水データ処理に利用する作業用配列のポインタ */
        //public double[] r_data; /* 降水データ処理に利用する作業用配列のポインタ */
        public double[] rr1;             /* 差分開始時刻の降水強度を格納する配列のポインタ */ 
        public double[] rr2;             /* 差分終了時刻の降水強度を格納する配列のポインタ */


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McKinematicWaveBasinCalInfo csRtn = new McKinematicWaveBasinCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McKinematicWaveBasinCalInfo csOrgDt = (McKinematicWaveBasinCalInfo)csOrgInfo;
            //this.m_dQb = csOrgDt.m_dQb;
            return true;
        }

    }
}
