﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>水理公式集例題１－３より　時系列データ発生要素内演算中データクラス</para>
    /// </summary>
    /// <remarks>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/11/11][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestDataGeneratorCalInfo : McCalInfo
    {
        /// <summary> 負値補正（強制ゼロ化） </summary>
        public bool m_bMinusCutFlg = true;

        /// <summary>
        /// 時系列種別番号 
        /// =1:一様乱数
        /// =2:正規乱数
        /// =3:ブラウン運動
        /// =4:AR
        /// =5:ARMA
        /// =6:トーマスーフェアリングモデル
        /// =7:定数
        /// </summary>
        public int m_iKind = 6;

        // 一様乱数発生時のパラメーター
        /// <summary> 一様乱数時：最大値 </summary>
        public double m_dMax=1.0;
        /// <summary> 一様乱数時：最小値 </summary>
        public double m_dMin = 0.0;

        // 正規乱数発生時のパラメーター
        /// <summary> 正規乱数発生時：平均値（中央値） </summary>
        public double m_dMean = 2.0;
        /// <summary> 正規乱数発生時：標準偏差 </summary>
        public double m_dSigma = 0.25;

        // ブラウン運動発生時のパラメーター
        /// <summary> 初期位置 </summary>
        public double m_dBMX0 = 0.0;

        // AR発生時のパラメーター
        /// <summary> 初期位置 </summary>
        public double m_dARX0 = 0.0;
        /// <summary> 一時自己相関係数 </summary>
        public double m_dR1AR = 0.489;
        /// <summary> スケールファクター：幅 </summary>
        public double m_dWAR = 0.4;
        /// <summary> スケールファクター：オフセット </summary>
        public double m_dYAR = 0.5;

        // ARMA発生時のパラメーター
        /// <summary> 初期位置 </summary>
        public double m_dARAMX0 = 0.0;
        /// <summary> φ </summary>
        public double m_dFaiARMA = 0.489;
        /// <summary> θ </summary>
        public double m_dTheataARMA = 0.5;
        /// <summary> スケールファクター：幅 </summary>
        public double m_dWARMA = 0.4;
        /// <summary> スケールファクター：オフセット </summary>
        public double m_dYARMA = 0.5;

        //トーマス・フェアリングモデル
        /// <summary> 初期位置 </summary>
        public double m_dARivX0 = 0.0;
        /// <summary> 一時自己相関係数 </summary>
        public double m_dR1ARiv = 0.489;
        /// <summary> </summary>
        public double m_dSgx=0.528;
        /// <summary>  </summary>
		public double m_dAvx=5.003;
        /// <summary>  </summary>
        public double m_dAx = 110.95;
        /// <summary>  </summary>
        public double m_dWARv = 0.001;
        // 定数
        /// <summary> </summary>
        public double m_dConstCoeff = 1.0;

        // 出力
        /// <summary> 出力情報 </summary>
        public double m_dOutputData = 0.0;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McTestDataGeneratorCalInfo csRtn = new McTestDataGeneratorCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            bool bRtn = false;
            McTestDataGeneratorCalInfo csOrdDt = csOrgInfo as McTestDataGeneratorCalInfo;

            if (csOrdDt != null)
            {
                this.m_bMinusCutFlg = csOrdDt.m_bMinusCutFlg;

                this.m_iKind = csOrdDt.m_iKind;

                this.m_dMax = csOrdDt.m_dMax;
                this.m_dMin = csOrdDt.m_dMin;

                this.m_dMean = csOrdDt.m_dMean;
                this.m_dSigma = csOrdDt.m_dSigma;

                this.m_dBMX0 = csOrdDt.m_dBMX0;

                this.m_dARX0 = csOrdDt.m_dARX0;
                this.m_dR1AR = csOrdDt.m_dR1AR;
                this.m_dWAR = csOrdDt.m_dWAR;
                this.m_dYAR = csOrdDt.m_dYAR;

                this.m_dARAMX0 = csOrdDt.m_dARAMX0;
                this.m_dFaiARMA = csOrdDt.m_dFaiARMA;
                this.m_dTheataARMA = csOrdDt.m_dTheataARMA;
                this.m_dWARMA = csOrdDt.m_dWARMA;
                this.m_dYARMA = csOrdDt.m_dYARMA;

                this.m_dARivX0 = csOrdDt.m_dARivX0;
                this.m_dR1ARiv = csOrdDt.m_dR1ARiv;
                this.m_dSgx = csOrdDt.m_dSgx;
                this.m_dAvx = csOrdDt.m_dAvx;
                this.m_dAx = csOrdDt.m_dAx;
                this.m_dWARv = csOrdDt.m_dWARv;

                this.m_dConstCoeff = csOrdDt.m_dConstCoeff;

                this.m_dOutputData = csOrdDt.m_dOutputData;

                bRtn = true;
            }
            return bRtn;
        }

    }
}
