﻿// <summary>ソースコード：モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/11/11][新規作成]</para>
    /// </remarks>
    public class McHyHdFormulaSampleH13Define
    {
        // ToDo
        // 必要と思われる定義を設定して下さい。（自DLL内クラスで共通に使用すると思われる常数）
        //

        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = new HySID("McHyHdFormulaSampleH13Factory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>例題：S1-3:水文時系列ﾃﾞｰﾀ生成用 モデル種別</summary>
        public static readonly HySObjectKind TEST_DATAGENERATOR_MODEL_KIND = new HySObjectKind("McTestDataGenerator");
        /// <summary>例題：S1-3:水文時系列ﾃﾞｰﾀ生成用 モデル名称</summary>
        public static readonly HySString TEST_DATAGENERATOR_MODEL_NAME = new HySString("H13年水理公式例題：S1-3:水文時系列ﾃﾞｰﾀ生成");
        /// <summary>例題：S1-3:水文時系列ﾃﾞｰﾀ生成用 ポイント次元時系列情報出力</summary>
        public static readonly HySID D0Out_PTN001 = new HySID("D0_out_ptn001");

        /// <summary>例題：S1-9:KinematicWave流出ﾓﾃﾞ用　モデル種別</summary>
        public static readonly HySObjectKind KINEMATIC_WAVE_BASIN_KIND = new HySObjectKind("S1-9:KinematicWaveBasinKind");
        /// <summary>例題：S1-9:KinematicWave流出ﾓﾃﾞﾙ用　モデル名称</summary>
        public static readonly HySString KINEMATIC_WAVE_BASIN_NAME = new HySString("H13年水理公式例題：S1-9:KinematicWave流出ﾓﾃﾞﾙ");



        /// <summary>例題：S2-2:KinematicWaveﾓﾃﾞﾙ用 モデル種別</summary>
        public static readonly HySObjectKind KINEMATIC_WAVE_LANE_KIND = new HySObjectKind("S2-2:KinematicWaveLane");
        /// <summary>例題：S2-2:KinematicWaveﾓﾃﾞﾙ用 モデル名称</summary>
        public static readonly HySString KINEMATIC_WAVE_LANE_NAME = new HySString("H13年水理公式例題：S2-2:KinematicWaveﾓﾃﾞﾙ");

        /// <summary>例題：S2-2:DynamicWaveﾓﾃﾞﾙ用 モデル種別</summary>
        public static readonly HySObjectKind DYNAMIC_WAVE_LANE_KIND = new HySObjectKind("S2-2:DynamicWaveLane");
        /// <summary>例題：S2-2:DynamicWaveﾓﾃﾞﾙ用 モデル名称</summary>
        public static readonly HySString DYNAMIC_WAVE_LANE_NAME = new HySString("H13年水理公式例題：S2-2:DynamicWaveﾓﾃﾞﾙ");

        /// <summary>例題：S2-2:DiffusionWaveﾓﾃﾞﾙ用 モデル種別</summary>
        public static readonly HySObjectKind DIFFUSION_WAVE_LANE_KIND = new HySObjectKind("S2-2:DiffusionWaveLane");
        /// <summary>例題：S2-2:DiffusionWaveﾓﾃﾞﾙ用 モデル名称</summary>
        public static readonly HySString DIFFUSION_WAVE_LANE_NAME = new HySString("H13年水理公式例題：S2-2:DiffusionWaveﾓﾃﾞﾙ");

        /// <summary>例題：S2-2:テスト用流量発生モデル種別</summary>
        public static readonly HySObjectKind Q_GENERATOR_KIND = new HySObjectKind("S2-2:TestQGeneratorKind");
        /// <summary>例題：S2-2:テスト用流量発生モデル名称</summary>
        public static readonly HySString Q_GENERATOR_NAME = new HySString("H13年水理公式例題：S2-2:ﾃｽﾄ用流量発生ﾓﾃﾞﾙ");

        /// <summary>例題：S6-2:河川における移流・拡散・分散の計算法モデル種別</summary>
        public static readonly HySObjectKind RIVDIF_QUICKS_KIND = new HySObjectKind("S6-2:QUICKSchemeKind");
        /// <summary>例題：S6-2:河川における移流・拡散・分散の計算法モデル名称</summary>
        public static readonly HySString Q_RIVDIF_QUICKS_NAME = new HySString("H13年水理公式例題：S6-2:河川における移流・拡散・分散ﾓﾃﾞﾙ");


        /// <summary>例題：S1-9:KinematicWave流出ﾓﾃﾞ用 降雨量入力</summary>
        public static readonly HySID IN_PATTERN_RAIN = new HySID("RainIn");
        /// <summary>例題：S1-9:KinematicWave流出ﾓﾃﾞ用 流量出力</summary>
        public static readonly HySID OUT_PATTERN_Q = new HySID("QOut");
        /// <summary>例題：S1-9:KinematicWave流出ﾓﾃﾞ用 水深出力</summary>
        public static readonly HySID OUT_PATTERN_DEPTH = new HySID("DepthOut");


        /// <summary>例題：S2-2: 上流端入力</summary>
        public static readonly HySID IN_PATTERN_TOP = new HySID("TopIn");
        /// <summary>例題：S2-2: 下流端出力</summary>
        public static readonly HySID OUT_PATTERN_BOTTOM = new HySID("BottomOut");
        /// <summary>例題：S2-2: 全セル内容出力</summary>
        public static readonly HySID OUT_PATTERN_ALL = new HySID("AllCellOut");

        /// <summary>例題：S6-2:河川における移流・拡散・分散の計算：河川上流端濃度入力</summary>
        public static readonly HySID IN_PATTERN_C_TOP = new HySID("TopIn_C");
        /// <summary>例題：S6-2:河川における移流・拡散・分散の計算：物質セル毎流入濃度入力</summary>
        public static readonly HySID IN_PATTERN_C_CELL = new HySID("CellIn_C");
        /// <summary>例題：S6-2:河川における移流・拡散・分散の計算：河川セル毎　流量・水位・流速入力</summary>
        public static readonly HySID IN_PATTERN_RIVER_QHV = new HySID("INCell_QHV");
        /// <summary>例題：S6-2:河川における移流・拡散・分散の計算：河川最下流端濃度出力</summary>
        public static readonly HySID OUT_PATTERN_C_BOTTOM = new HySID("Bottom_COut");
        /// <summary>例題：S6-2:河川における移流・拡散・分散の計算：河川セル毎濃度出力</summary>
        public static readonly HySID OUT_PATTERN_C_ALL = new HySID("AllCell_COut");

        //<@Add_> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
    }
}
