﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/11/11][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13.McHyHdFormulaSampleH13Factory();
        }
    }
}

namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McHyHdFormulaSampleH13Factory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return McHyHdFormulaSampleH13Define.MODEL_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (csModelKind == McHyHdFormulaSampleH13Define.TEST_DATAGENERATOR_MODEL_KIND)
            {   // 例題：S1-3:水文時系列ﾃﾞｰﾀ生成
                csCalModel = new McTestDataGenerator();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:KinematicWaveﾓﾃﾞﾙ
                csCalModel = new McKinematicWaveLane();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DYNAMIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:DynamicWaveﾓﾃﾞﾙ
                csCalModel = new McDynamicWaveLane();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DIFFUSION_WAVE_LANE_KIND)
            {   // 例題：S2-2:DiffusionWaveﾓﾃﾞﾙ
                csCalModel = new McDiffusionWaveLane();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.Q_GENERATOR_KIND)
            {   // 例題：S2-2:テスト用流量発生ﾓﾃﾞﾙ
                csCalModel = new McTestBasin();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_BASIN_KIND)
            {   // 例題：S1-9:KinematicWave流出モデル種別
                csCalModel = new McKinematicWaveBasin();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.RIVDIF_QUICKS_KIND)
            {   // 例題：S6-2:河川における移流・拡散・分散の計算法モデル
                csCalModel = new McQUICKSchemeRivDiff();
            }
            //<@Add_CreateCalModel/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind == McHyHdFormulaSampleH13Define.TEST_DATAGENERATOR_MODEL_KIND)
            {   // 例題：S1-3:水文時系列ﾃﾞｰﾀ生成
                csCalInfoData = new McTestDataGeneratorCalInfo();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:KinematicWaveﾓﾃﾞﾙ
                csCalInfoData = new McKinematicWaveLaneCalInfo();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DYNAMIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:DynamicWaveﾓﾃﾞﾙ
                csCalInfoData = new McDynamicWaveLaneCalInfo();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DIFFUSION_WAVE_LANE_KIND)
            {   // 例題：S2-2:DiffusionWaveﾓﾃﾞﾙ
                csCalInfoData = new McDiffusionWaveLaneCalInfo();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.Q_GENERATOR_KIND)
            {   // 例題：S2-2:テスト用流量発生ﾓﾃﾞﾙ
                csCalInfoData = new McTestBasinCalInfo();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_BASIN_KIND)
            {   // 例題：S1-9:KinematicWave流出モデル種別
                csCalInfoData = new McKinematicWaveBasinCalInfo();
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.RIVDIF_QUICKS_KIND)
            {   // 例題：S6-2:河川における移流・拡散・分散の計算法モデル
                csCalInfoData = new McQUICKSchemeRivDiffCalInfo();
            }
            //<@Add_CreateCalInfo/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo( csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind == McHyHdFormulaSampleH13Define.TEST_DATAGENERATOR_MODEL_KIND)
            {   // 例題：S1-3:水文時系列ﾃﾞｰﾀ生成
                csRtnCellPrptyDt = new McTestDataGeneratorPropertyInfo(csLibraryID, csModelKind);

                // δT設定
                csRtnCellPrptyDt.SetStepTime((double)60.0);

                // 受信可能なパターン
                {
                    // 無し
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.D0Out_PTN001,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "ポイント（０次元）時系列出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "any");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    } 
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                }
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:KinematicWaveﾓﾃﾞﾙ
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime((double)48 * 3600 / 2400); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", "モデル内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 50);
                csRtnCellPrptyDt.AddInfoType("m_dRough", "粗度", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dRough", 0.03);
                csRtnCellPrptyDt.AddInfoType("m_dSlope", "河床勾配", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dSlope", 1.0 / 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dLength", "河道長", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dLength", 100.0*1000.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);
                // 受信可能なパターン
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.IN_PATTERN_TOP,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "上流端流入") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_ALL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "セル全体出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DYNAMIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:DynamicWaveﾓﾃﾞﾙ
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime((double)48 * 3600 / 2400); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", "モデル内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 50);
                csRtnCellPrptyDt.AddInfoType("m_dRough", "粗度", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dRough", 0.03);
                csRtnCellPrptyDt.AddInfoType("m_dSlope", "河床勾配", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dSlope", 1.0 / 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dLength", "河道長", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dLength", 100.0 * 1000.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);
                // 受信可能なパターン
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.IN_PATTERN_TOP,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "上流端流入") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_ALL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "セル全体出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DIFFUSION_WAVE_LANE_KIND)
            {   // 例題：S2-2:DiffusionWaveﾓﾃﾞﾙ
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime((double)48 * 3600 / 2400); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", "モデル内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 50);
                csRtnCellPrptyDt.AddInfoType("m_dRough", "粗度", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dRough", 0.03);
                csRtnCellPrptyDt.AddInfoType("m_dSlope", "河床勾配", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dSlope", 1.0 / 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dLength", "河道長", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dLength", 100.0 * 1000.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);
                // 受信可能なパターン
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.IN_PATTERN_TOP,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "上流端流入") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_ALL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "セル全体出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.Q_GENERATOR_KIND)
            {   // 例題：S2-2:テスト用流量発生ﾓﾃﾞﾙ
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(72); // δT設定 秒

                csRtnCellPrptyDt.AddInfoType("m_dQb", "流量ｂ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQb", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQp", "流量ｐ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQp", 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dCp", "ｃ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCp", 10.0);

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "流出") as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_BASIN_KIND)
            {   // 例題：S1-9:KinematicWave流出モデル種別
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                // 例題：S1-9:"calcon.dat"
                csRtnCellPrptyDt.AddInfoType("type_scheme", "差分ｽｷｰﾑのﾀｲﾌﾟ(1: Lax Wendroff,2: 4-point implicit method)", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("type_scheme", 1);
                csRtnCellPrptyDt.AddInfoType("_nx", "空間差分間隔の個数 (差分の節点数は nx+1 である)", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("_nx", 100);
                //csRtnCellPrptyDt.AddInfoType("delta_t", "差分の時間間隔 (秒)", McDefine.ValKind.LONG);
                //csRtnCellPrptyDt.SetInfo("delta_t", 3600.0*0.001);
                csRtnCellPrptyDt.SetStepTime(3600.0 * 0.001); // δT設定 秒

                csRtnCellPrptyDt.AddInfoType("delta_tq", "流出量の計算結果を出力する時間間隔 (秒）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("delta_tq", 60.0 );
                csRtnCellPrptyDt.AddInfoType("delta_th", "水深の計算結果を出力する時間間隔 (秒）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("delta_th", 3600.0);

                /*====================================*/
                /*  流量流積関係式の設定と単位の変換  */
                /*====================================*/
                // 例題：S1-9:"qh_eqn.dat"
                csRtnCellPrptyDt.AddInfoType("type_qh_equation", "流量流積関係式の選択(1:ﾀﾞﾙｼｰ式,2:ﾏﾆﾝｸﾞ式,3:高棹・椎葉式)", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("type_qh_equation", 3);
                csRtnCellPrptyDt.AddInfoType("_k", "飽和透水係数 (cm/sec)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_k", 0.3);
                csRtnCellPrptyDt.AddInfoType("_n", "マニングの粗度係数 (m^{-1/3}sec)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_n", 0.3);
                csRtnCellPrptyDt.AddInfoType("_m", "流量流積関係式のベキ数 5/3=1.67", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_m", 5.0/3.0 );
                csRtnCellPrptyDt.AddInfoType("_D", "A 層厚 (mm), D", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_D", 200.0);
                csRtnCellPrptyDt.AddInfoType("_gamma", "A 層の有効間隙率 (無次元)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_gamma", 0.2);

                /*==================*/
                /*  斜面形状の設定  */
                /*==================*/
                // 例題：S1-9:"slope.dat"
                csRtnCellPrptyDt.AddInfoType("_L", "斜面長 (m)．斜面長は流れ方向に取る．", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_L", 100.0);
                csRtnCellPrptyDt.AddInfoType("_theta", "斜面勾配 (degree)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_theta", 30.0);
                csRtnCellPrptyDt.AddInfoType("_bu", "斜面上端の幅 (m)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_bu", 50.0);
                csRtnCellPrptyDt.AddInfoType("_bl", "斜面下端の幅 (m)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("_bl", 50.0);

                // 受信可能なパターン
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.IN_PATTERN_RAIN,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "降雨量") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "降雨量", HySDataCharacteristicInCell.DATA_KIND.SCALOR_RAIN_FALL, "mm/hr"); 
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_Q,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "流出") as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_DEPTH,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "水深") as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "水深", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "mm");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }

            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.RIVDIF_QUICKS_KIND)
            {   // 例題：S6-2:河川における移流・拡散・分散の計算法モデル
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(30.0); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", "モデル内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 200);
                csRtnCellPrptyDt.AddInfoType("m_dLength", "河道長", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dLength", 200.0 * 50.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dUstar", "拡散（分散）設定の為の係数", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dUstar", 100.0 / 15.0);

                // 受信可能なパターン
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.IN_PATTERN_C_TOP,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "上流端物質流入") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "物質濃度", HySDataCharacteristicInCell.DATA_KIND.CONCENTRATION, "any"); // 最初の変数は流量
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.IN_PATTERN_C_CELL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "各セルへの物質流入") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "物質濃度", HySDataCharacteristicInCell.DATA_KIND.CONCENTRATION, "any"); // 最初の変数は流量
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加


                    // 第３パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.IN_PATTERN_RIVER_QHV,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "各セルの流量・水位・流速計算値入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_C_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "下流端物質流出") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "物質濃度", HySDataCharacteristicInCell.DATA_KIND.CONCENTRATION, "any");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McHyHdFormulaSampleH13Define.OUT_PATTERN_C_ALL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "各セル内濃度") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "物質濃度", HySDataCharacteristicInCell.DATA_KIND.CONCENTRATION, "any");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            //<@Add_CreateModelProperty/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            return csRtnCellPrptyDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo( csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }
            McInitialInfo csRtnDt = null;
            if (csModelKind == McHyHdFormulaSampleH13Define.TEST_DATAGENERATOR_MODEL_KIND)
            {   // 例題：S1-3:水文時系列ﾃﾞｰﾀ生成
                csRtnDt = new McTestDataGeneratorInitialData( csLibraryID, csModelKind);
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:KinematicWaveﾓﾃﾞﾙ
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("Q_Initial", "初期流量", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 20.0);
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DYNAMIC_WAVE_LANE_KIND)
            {   // 例題：S2-2:DynamicWaveﾓﾃﾞﾙ
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("Q_Initial", "初期流量", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 20.0);
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.DIFFUSION_WAVE_LANE_KIND)
            {   // 例題：S2-2:DiffusionWaveﾓﾃﾞﾙ
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("Q_Initial", "初期流量", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 20.0);
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.Q_GENERATOR_KIND)
            {   // 例題：S2-2:テスト用流量発生ﾓﾃﾞﾙ
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_BASIN_KIND)
            {   // 例題：S1-9:KinematicWave流出モデル種別
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McHyHdFormulaSampleH13Define.RIVDIF_QUICKS_KIND)
            {   // 例題：S6-2:河川における移流・拡散・分散の計算法モデル
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("H_Initial", "初期水位(m)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("H_Initial", 2.0);
                csRtnDt.AddInfoType("Q_Initial", "初期流量(m^2/sec)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 0.1);
            }
            //<@Add_CreateModelInitialInfo/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo = null;

            // 例題：S1-3:水文時系列ﾃﾞｰﾀ生成ﾓﾃﾞﾙ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McHyHdFormulaSampleH13Define.TEST_DATAGENERATOR_MODEL_KIND, // モデルの識別子
                McHyHdFormulaSampleH13Define.TEST_DATAGENERATOR_MODEL_NAME  // モデルの名称
                               );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("H13年水理公式例題集：例題1-3より 各種時系列情報発生ﾓﾃﾞﾙ");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("DefaultModel");
            csModelInfo.SetManualFileName(".\\Sample\\H13McHyHdFormulaSample.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);


            // 例題：S2-2:KinematicWaveﾓﾃﾞﾙ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_LANE_KIND, // モデルの識別子
                McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_LANE_NAME  // モデルの名称
                               );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("H13年水理公式例題集：例題2-2より KinematicWaveﾓﾃﾞﾙ");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Lane");
            csModelInfo.SetManualFileName(".\\Sample\\H13McHyHdFormulaSample.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);


            // 例題：S2-2:DynamicWaveﾓﾃﾞﾙ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McHyHdFormulaSampleH13Define.DYNAMIC_WAVE_LANE_KIND, // モデルの識別子
                McHyHdFormulaSampleH13Define.DYNAMIC_WAVE_LANE_NAME  // モデルの名称
                               );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("H13年水理公式例題集：例題2-2より DynamicWaveﾓﾃﾞﾙ");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Lane");
            csModelInfo.SetManualFileName(".\\Sample\\H13McHyHdFormulaSample.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            // 例題：S2-2:DiffusionWaveﾓﾃﾞﾙ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McHyHdFormulaSampleH13Define.DIFFUSION_WAVE_LANE_KIND, // モデルの識別子
                McHyHdFormulaSampleH13Define.DIFFUSION_WAVE_LANE_NAME  // モデルの名称
                               );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("H13年水理公式例題集：例題2-2より DiffusionWaveﾓﾃﾞﾙ");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Lane");
            csModelInfo.SetManualFileName(".\\Sample\\H13McHyHdFormulaSample.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            // 例題：S2-2:テスト用流量発生ﾓﾃﾞﾙ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McHyHdFormulaSampleH13Define.Q_GENERATOR_KIND, // モデルの識別子
                McHyHdFormulaSampleH13Define.Q_GENERATOR_NAME  // モデルの名称
                               );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("H13年水理公式例題集：例題2-2より 各種ﾓﾃﾞﾙ動作確認用流量発生ﾓﾃﾞﾙ");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Basin");
            csModelInfo.SetManualFileName(".\\Sample\\H13McHyHdFormulaSample.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            // 例題：S1-9:KinematicWave流出ﾓﾃﾞﾙ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_BASIN_KIND, // モデルの識別子
                McHyHdFormulaSampleH13Define.KINEMATIC_WAVE_BASIN_NAME  // モデルの名称
                               );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("H13年水理公式例題集：例題1-9より KinematicWave流出ﾓﾃﾞﾙ");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Basin");
            csModelInfo.SetManualFileName(".\\Sample\\H13McHyHdFormulaSample.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            // 例題：S6-2:河川における移流・拡散・分散の計算ﾓﾃﾞﾙ
            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McHyHdFormulaSampleH13Define.RIVDIF_QUICKS_KIND, // モデルの識別子
                McHyHdFormulaSampleH13Define.Q_RIVDIF_QUICKS_NAME  // モデルの名称
                               );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("H13年水理公式例題集：例題6-2より QUICK scheme with Adams-Bashforth methodﾓﾃﾞﾙ");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Diffusion");
            csModelInfo.SetManualFileName(".\\Sample\\H13McHyHdFormulaSample.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            //<@Add_GetCalModelInfoList/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            return m_csCalModelInforList;
        }

    }
}
