﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>テストサンプル要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestDataGeneratorInitialData : McInitialInfo
    {
        // ブラウン運動発生時のパラメーター
        /// <summary> 初期位置 </summary>
        double m_dBMX0 = 0.0;

        // AR発生時のパラメーター
        /// <summary> 初期位置 </summary>
        double m_dARX0 = 0.0;

        // ARMA発生時のパラメーター
        /// <summary> 初期位置 </summary>
        double m_dARAMX0 = 0.0;

        //トーマス・フェアリングモデル
        /// <summary> 初期位置 </summary>
        double m_dARivX0 = 0.0;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McPropertyInfo csDt = new McInitialInfo(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestDataGeneratorInitialData(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McTestDataGeneratorInitialData csRtn = new McTestDataGeneratorInitialData(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);
            McTestDataGeneratorInitialData csPrpOrgObj = csOrgObj as McTestDataGeneratorInitialData;
            if (csPrpOrgObj != null)
            {
                this.m_dBMX0 = csPrpOrgObj.m_dBMX0;
                this.m_dARX0 = csPrpOrgObj.m_dARX0;
                this.m_dARAMX0 = csPrpOrgObj.m_dARAMX0;
                this.m_dARivX0 = csPrpOrgObj.m_dARivX0;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = base.XmlOUT(ref csXmlWriter);

            // ToDo 独自に追加した変数を　ＸＭＬへ出力する処理を追加してください。
            // 例　
            //   属性として追加する場合
            csRtn.SetAttribute("m_dBMX0", m_dBMX0.ToString());
            csRtn.SetAttribute("m_dARX0", m_dARX0.ToString());
            csRtn.SetAttribute("m_dARAMX0", m_dARAMX0.ToString());
            csRtn.SetAttribute("m_dARivX0", m_dARivX0.ToString());

            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>true :正常 , false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csPrptyXml)
        {
            bool bRtn = base.XmlIN(csPrptyXml);

            // ToDo 独自に追加した変数を　ＸＭＬから読み込む処理を追加して下さい。
            // 例　
            //   属性として追加する場合
            string sValueAttr = "";
            sValueAttr = csPrptyXml.GetAttribute("m_dBMX0");
            if (sValueAttr != "") { m_dBMX0 = Convert.ToDouble(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dARX0");
            if (sValueAttr != "") { m_dARX0 = Convert.ToDouble(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dARAMX0");
            if (sValueAttr != "") { m_dARAMX0 = Convert.ToDouble(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dARivX0");
            if (sValueAttr != "") { m_dARivX0 = Convert.ToDouble(sValueAttr); }

            return bRtn;
        }

        // Getter,Setter
        /// <summary> </summary>
        public double BM_X0 { get { return m_dBMX0; } set { m_dBMX0 = value; } }
        /// <summary> </summary>
        public double AR_X0 { get { return m_dARX0; } set { m_dARX0 = value; } }
        /// <summary> </summary>
        public double ARMA_X0 { get { return m_dARAMX0; } set { m_dARAMX0 = value; } }
        /// <summary> </summary>
        public double TF_X0 { get { return m_dARivX0; } set { m_dARivX0 = value; } }


        // =============================================
        // === バージョンアップ時の互換性を保つ為の処理 ===
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> string sVersion = GetNowVersion( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetNowVersion( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
