﻿// <summary>ソースコード：サンプル要素内演算中データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>水理公式集例題６－２より
    /// 河川における移流・拡散・分散の計算要素内演算中データクラス
    ///   １次元移流拡散（分散）方程式の計算 </para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/11/11][新規作成]</para>
    /// <para>remarks</para>
    /// <para>
    /// 演算中の状態、初期条件等を保持するデータクラス
    /// FORTRAN COMMON 変数に相当
    /// </para>
    /// </remarks>
    [Serializable]
    public class McQUICKSchemeRivDiffCalInfo : McCalInfo
    {
        /// <summary>セル番号(計算格子点数)</summary>
        public long m_lCelNumber = 200;

        /// <summary>単位幅流量(m^2/sec)</summary>
        public double[] m_dQ = null;
        /// <summary>モデル計算では水深(m)</summary>
        public double[] m_dH = null;
        /// <summary>拡散（分散）係数(m^2/sec)</summary>
        public double[] m_dD = null;
        /// <summary>流速(m/sec)</summary>
        public double[] m_dV = null;

        /// <summary> 現在時刻の濃度 </summary>
        public double[] m_dCNow = null;
        /// <summary> 新しい時刻の濃度 </summary>
        public double[] m_dCNext = null;
        /// <summary> Adams-Bashforth methodのための配列 </summary>
        public double[] m_dAdvold = null;


        /// <summary>拡散（分散）設定の為の係数</summary>
        public double m_dUstar = 100.0 / 15.0;
        /// <summary>長さ</summary>
        public double m_dLength = 10000.0;
        /// <summary>セル長(空間差分間隔(m))</summary>
        public double m_dCelLength = 10000.0 / 200.0;

        /// <summary>河幅</summary>
        public double m_dWidth = 200.0;

        /// <summary>初回計算フラグ </summary>
        public bool m_bFirstCalFlg = true;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McQUICKSchemeRivDiffCalInfo csRtn = new McQUICKSchemeRivDiffCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McQUICKSchemeRivDiffCalInfo csOrgDt = (McQUICKSchemeRivDiffCalInfo)csOrgInfo;
            
            this.m_lCelNumber = csOrgDt.m_lCelNumber;

            this.m_dH = new double[csOrgDt.m_lCelNumber+1];
            this.m_dD = new double[csOrgDt.m_lCelNumber + 1];
            this.m_dV = new double[csOrgDt.m_lCelNumber+1];
            this.m_dQ = new double[csOrgDt.m_lCelNumber+1];
            this.m_dCNow = new double[csOrgDt.m_lCelNumber + 1];
            this.m_dCNext = new double[csOrgDt.m_lCelNumber + 1];
            this.m_dAdvold = new double[csOrgDt.m_lCelNumber + 1];

            for (long lLp = 0; lLp <= csOrgDt.m_lCelNumber; lLp++)
            {
                this.m_dH[lLp] = csOrgDt.m_dH[lLp];
                this.m_dD[lLp] = csOrgDt.m_dD[lLp];
                this.m_dV[lLp] = csOrgDt.m_dV[lLp];
                this.m_dQ[lLp] = csOrgDt.m_dQ[lLp];
                this.m_dCNow[lLp] = csOrgDt.m_dCNow[lLp];
                this.m_dCNext[lLp] = csOrgDt.m_dCNext[lLp];
                this.m_dAdvold[lLp] = csOrgDt.m_dAdvold[lLp];
            }


            this.m_dLength = csOrgDt.m_dLength;
            this.m_dWidth = csOrgDt.m_dWidth;
            this.m_dCelLength = csOrgDt.m_dCelLength;

            this.m_dUstar = csOrgDt.m_dUstar;
            this.m_bFirstCalFlg = csOrgDt.m_bFirstCalFlg;
            return true;
        }

    }
}
