﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>要素モデルプロパティ情報</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>要素モデルのプロパティ値を保持する</para>
    /// </remarks>
    [Serializable]
    public class McTestDataGeneratorPropertyInfo : McCellModelPropertyInfo
    {
        bool m_bMinusCutFlg = true;
        /// <summary>
        /// 時系列種別番号 
        /// =1:一様乱数
        /// =2:正規乱数
        /// =3:ブラウン運動
        /// =4:AR
        /// =5:ARMA
        /// =6:トーマスーフェアリングモデル
        /// =7:定数
        /// </summary>
        int m_iKind = 6;

        // 一様乱数発生時のパラメーター
        /// <summary> 一様乱数時：最大値 </summary>
        double m_dMax = 1.0;
        /// <summary> 一様乱数時：最小値 </summary>
        double m_dMin = 0.0;

        // 正規乱数発生時のパラメーター
        /// <summary> 正規乱数発生時：平均値（中央値） </summary>
        double m_dMean = 2.0;
        /// <summary> 正規乱数発生時：標準偏差 </summary>
        double m_dSigma = 0.25;

        // ブラウン運動発生時のパラメーター
        /// <summary> 初期位置 </summary>
        double m_dBMX0 = 0.0;

        // AR発生時のパラメーター
        /// <summary> 初期位置 </summary>
        double m_dARX0 = 0.0;
        /// <summary> 一時自己相関係数 </summary>
        double m_dR1AR = 0.489;
        /// <summary> スケールファクター：幅 </summary>
        double m_dWAR = 0.4;
        /// <summary> スケールファクター：オフセット </summary>
        double m_dYAR = 0.5;

        // ARMA発生時のパラメーター
        /// <summary> 初期位置 </summary>
        double m_dARAMX0 = 0.0;
        /// <summary> φ </summary>
        double m_dFaiARMA = 0.489;
        /// <summary> θ </summary>
        double m_dTheataARMA = 0.5;
        /// <summary> スケールファクター：幅 </summary>
        double m_dWARMA = 0.4;
        /// <summary> スケールファクター：オフセット </summary>
        double m_dYARMA = 0.5;

        //トーマス・フェアリングモデル
        /// <summary> 初期位置 </summary>
        double m_dARivX0 = 10.0;
        /// <summary> 一時自己相関係数 </summary>
        double m_dR1ARiv = 0.489;
        /// <summary> </summary>
        double m_dSgx = 0.528;
        /// <summary> </summary>
        double m_dAvx = 5.003;
        /// <summary> </summary>
        double m_dAx = 110.95;
        /// <summary> スケールファクター：幅 </summary>
        double m_dWARv = 0.001;

        // 定数
        /// <summary> </summary>
        double m_dConstCoeff = 1.0;

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McPropertyInfo csModelPropertyInfoRoot = new MySpecialPropertyData(csLibraryID, csModelKind)</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>McModelPropertyInfo 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestDataGeneratorPropertyInfo(HySID csLibraryID, HySObjectKind csModelKind)
            : base(csLibraryID, csModelKind)
        {
            //バージョン情報設定
            SetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>自分と同じクラスのインスタンスを生成する</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> McPropertyInfoRoot csModelPropertyInfoRoot = Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>McPropertyInfoRoot 生成されたクラスのインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot Clone()
        {
            McTestDataGeneratorPropertyInfo csRtn = new McTestDataGeneratorPropertyInfo(m_csLibraryID, m_csModelKind);
            csRtn.CopyInf(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> CopyInf(csOrgObj) </para>
        /// </example>
        /// <param name="csOrgObj">コピー元情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override void CopyInf(McPropertyInfoRoot csOrgObj)
        {
            base.CopyInf(csOrgObj);

            McTestDataGeneratorPropertyInfo csOrdDt = csOrgObj as McTestDataGeneratorPropertyInfo;
            if (csOrdDt != null)
            {
                this.m_bMinusCutFlg = csOrdDt.m_bMinusCutFlg;
                this.m_iKind = csOrdDt.m_iKind;

                this.m_dMax = csOrdDt.m_dMax;
                this.m_dMin = csOrdDt.m_dMin;

                this.m_dMean = csOrdDt.m_dMean;
                this.m_dSigma = csOrdDt.m_dSigma;

                this.m_dBMX0 = csOrdDt.m_dBMX0;

                this.m_dARX0 = csOrdDt.m_dARX0;
                this.m_dR1AR = csOrdDt.m_dR1AR;
                this.m_dWAR = csOrdDt.m_dWAR;
                this.m_dYAR = csOrdDt.m_dYAR;

                this.m_dARAMX0 = csOrdDt.m_dARAMX0;
                this.m_dFaiARMA = csOrdDt.m_dFaiARMA;
                this.m_dTheataARMA = csOrdDt.m_dTheataARMA;
                this.m_dWARMA = csOrdDt.m_dWARMA;
                this.m_dYARMA = csOrdDt.m_dYARMA;

                this.m_dARivX0 = csOrdDt.m_dARivX0;
                this.m_dR1ARiv = csOrdDt.m_dR1ARiv;
                this.m_dSgx = csOrdDt.m_dSgx;
                this.m_dAvx = csOrdDt.m_dAvx;
                this.m_dAx = csOrdDt.m_dAx;
                this.m_dWARv = csOrdDt.m_dWARv;

                this.m_dConstCoeff = csOrdDt.m_dConstCoeff;

            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報をXMLへ書き出す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> HySXmlNode csXmlNode = XmlOUT(csXmlWriter) </para>
        /// </example>
        /// <param name="csXmlWriter">XML書き出しクラス</param>
        /// <returns>HySXmlNode XMLノードクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySXmlNode XmlOUT(ref HySXmlWriter csXmlWriter)
        {
            HySXmlNode csRtn = base.XmlOUT(ref csXmlWriter);

            // ToDo 独自に追加した変数を　ＸＭＬへ出力する処理を追加してください。
            // 例　
            //   属性として追加する場合
            csRtn.SetAttribute("m_iKind", m_iKind.ToString());

            csRtn.SetAttribute("m_dMax", m_dMax.ToString());
            csRtn.SetAttribute("m_dMin", m_dMin.ToString());

            csRtn.SetAttribute("m_dMean", m_dMean.ToString());
            csRtn.SetAttribute("m_dSigma", m_dSigma.ToString());

            csRtn.SetAttribute("m_dR1AR", m_dR1AR.ToString());
            csRtn.SetAttribute("m_dWAR", m_dWAR.ToString());
            csRtn.SetAttribute("m_dYAR", m_dYAR.ToString());

            csRtn.SetAttribute("m_dFaiARMA", m_dFaiARMA.ToString());
            csRtn.SetAttribute("m_dTheataARMA", m_dTheataARMA.ToString());
            csRtn.SetAttribute("m_dWARMA", m_dWARMA.ToString());
            csRtn.SetAttribute("m_dYARMA", m_dYARMA.ToString());

            csRtn.SetAttribute("m_dR1ARiv", m_dR1ARiv.ToString());
            csRtn.SetAttribute("m_dSgx", m_dSgx.ToString());
            csRtn.SetAttribute("m_dAvx", m_dAvx.ToString());
            csRtn.SetAttribute("m_dAx", m_dAx.ToString());
            csRtn.SetAttribute("m_dWARv", m_dWARv.ToString());

            csRtn.SetAttribute("m_dConstCoeff", m_dConstCoeff.ToString());

            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>XMLからモデル情報を読み出す</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> bool bRtn = XmlIN(csPrptyXml) </para>
        /// </example>
        /// <param name="csPrptyXml">入力XML</param>
        /// <returns>true :正常 , false:型式不適等</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool XmlIN(HySXmlNode csPrptyXml)
        {
            bool bRtn = base.XmlIN(csPrptyXml);

            // ToDo 独自に追加した変数を　ＸＭＬから読み込む処理を追加して下さい。
            // 例　
            //   属性として追加する場合
            string sValueAttr = "";
            sValueAttr = csPrptyXml.GetAttribute("m_iKind");
            if (sValueAttr != "") { m_iKind = Convert.ToInt16(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dMax");
            if (sValueAttr != "") { m_dMax = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dMin");
            if (sValueAttr != "") { m_dMin = Convert.ToDouble(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dMean");
            if (sValueAttr != "") { m_dMean = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dSigma");
            if (sValueAttr != "") { m_dSigma = Convert.ToDouble(sValueAttr); }


            sValueAttr = csPrptyXml.GetAttribute("m_dR1AR");
            if (sValueAttr != "") { m_dR1AR = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dWAR");
            if (sValueAttr != "") { m_dWAR = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dYAR");
            if (sValueAttr != "") { m_dYAR = Convert.ToDouble(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dFaiARMA");
            if (sValueAttr != "") { m_dFaiARMA = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dTheataARMA");
            if (sValueAttr != "") { m_dTheataARMA = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dWARMA");
            if (sValueAttr != "") { m_dWARMA = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dYARMA");
            if (sValueAttr != "") { m_dYARMA = Convert.ToDouble(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dR1ARiv");
            if (sValueAttr != "") { m_dR1ARiv = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dSgx");
            if (sValueAttr != "") { m_dSgx = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dAvx");
            if (sValueAttr != "") { m_dAvx = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dAx");
            if (sValueAttr != "") { m_dAx = Convert.ToDouble(sValueAttr); }
            sValueAttr = csPrptyXml.GetAttribute("m_dWARv");
            if (sValueAttr != "") { m_dWARv = Convert.ToDouble(sValueAttr); }

            sValueAttr = csPrptyXml.GetAttribute("m_dConstCoeff");
            if (sValueAttr != "") { m_dConstCoeff = Convert.ToDouble(sValueAttr); }

            return bRtn;
        }

        // Getter,Setter
        /// <summary> </summary>
        public bool MINUS_CUT { get { return m_bMinusCutFlg; } set { m_bMinusCutFlg = value; } }
        /// <summary> </summary>
        public int KIND { get { return m_iKind; } set { m_iKind = value; } }
        /// <summary> 最大値のGetter,Setterです。</summary>
        public double RND_MAX { get { return m_dMax; } set { m_dMax = value; } }
        /// <summary> </summary>
        public double RND_MIN { get { return m_dMin; } set { m_dMin = value; } }
        /// <summary> </summary>
        public double GAUSS_MEAN { get { return m_dMean; } set { m_dMean = value; } }
        /// <summary> </summary>
        public double GAUSS_SIGMA { get { return m_dSigma; } set { m_dSigma = value; } }
        /// <summary> </summary>
        public double AR_R1 { get { return m_dR1AR; } set { m_dR1AR = value; } }
        /// <summary> </summary>
        public double AR_SCALE_W { get { return m_dWAR; } set { m_dWAR = value; } }
        /// <summary> </summary>
        public double AR_SCALE_Y { get { return m_dYAR; } set { m_dYAR = value; } }
        /// <summary> </summary>
        public double ARMA_FAI { get { return m_dFaiARMA; } set { m_dFaiARMA = value; } }
        /// <summary> </summary>
        public double ARMA_THEATA { get { return m_dTheataARMA; } set { m_dTheataARMA = value; } }
        /// <summary> </summary>
        public double ARMA_SCALE_W { get { return m_dWARMA; } set { m_dWARMA = value; } }
        /// <summary> </summary>
        public double ARMA_SCALE_Y { get { return m_dYARMA; } set { m_dYARMA = value; } }
        /// <summary> </summary>
        public double TF_R1 { get { return m_dR1ARiv; } set { m_dR1ARiv = value; } }
        /// <summary> </summary>
        public double TF_SGX { get { return m_dSgx; } set { m_dSgx = value; } }
        /// <summary> </summary>
        public double TF_AVX { get { return m_dAvx; } set { m_dAvx = value; } }
        /// <summary> </summary>
        public double TF_AX { get { return m_dAx; } set { m_dAx = value; } }
        /// <summary> </summary>
        public double TM_SCALE_W { get { return m_dWARv; } set { m_dWARv = value; } }
        /// <summary> </summary>
        public double CONST_COEFF { get { return m_dConstCoeff; } set { m_dConstCoeff = value; } }


        // =============================================
        // === バージョンアップ時の互換性を保つ為の処理 ===
        /// <summary>保存バージョン情報</summary>
        private string m_sDecodedVersion;

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> string sDecodedVersion = GetDecodedVersion( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 保存バージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>メンバー変数に設定されているバージョン情報を返す</para>
        /// </remarks>
        public new string GetDecodedVersion()
        {
            return m_sDecodedVersion;
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報取得</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> string sVersion = GetNowVersion( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>string 現在のバージョン情報</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public new string GetNowVersion()
        {
            return "1.00";
        }

        /// <summary><para>method outline:</para>
        /// <para>バージョン情報設定</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> SetNowVersion( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>現在のバージョン情報をメンバー変数に設定する</para>
        /// </remarks>
        public new void SetNowVersion()
        {
            m_sDecodedVersion = GetNowVersion();
        }

        /// <summary><para>method outline:</para>
        /// <para>復元後の整合性確保処理</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para> PostDeserialize( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>シリアライズされた旧バージョン情報を復元する際、過去の整合性をとる時に使用する
        /// バージョンによって変数等追加がない場合には、実装の必要がない
        /// </para>
        /// </remarks>
        public override void PostDeserialize()
        {
            base.PostDeserialize();

            if (GetDecodedVersion() != GetNowVersion())
            {
                //旧バージョンから順にバージョンを上げて行く
                switch (GetDecodedVersion())
                {
                    case "1.00":
                        break;
                }
                SetNowVersion();
            }
        }
    }
}
