// <summary>ソースコード：モデル用プロパティスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImple.McHyHdFormulaSampleH13
{
    /// <summary><para>class outline:</para>
    /// <para>モデル用プロパティス画面用 .net のフォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.2.0][2011/11/11][新規作成]</para>
    /// <para>remarks:</para>
    /// <para>必ず　McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIFから派生の事</para>
    /// </remarks>
    public partial class McTestDataGeneratorPrptyDetailForm : McDotNetModelCellPropertyDetailBaseForm, McModelCellPropertyDetailFormIF
    {
        McTestDataGeneratorPropertyInfo m_csTmpPrpty = null;
        McTestDataGeneratorPropertyInfo m_csPrpty = null;
        McTestDataGeneratorInitialData m_csTmpInit = null;
        McTestDataGeneratorInitialData m_csInit = null;


        /// <summary>
        /// <para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>McMyModelDetailForm csPropertyDetailForm = new McMyModelDetailForm();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McTestDataGeneratorPrptyDetailForm()
        {
            InitializeComponent();
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>プロパティ表示編集</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>EditParameter( );</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void EditParameter()
        {
            m_csTmpPrpty = this.m_csPropertyInfo as McTestDataGeneratorPropertyInfo;
            m_csPrpty = this.m_csOriginalPropertyInfo as McTestDataGeneratorPropertyInfo;
            m_csTmpInit = this.m_csInitialInfo as McTestDataGeneratorInitialData;
            m_csInit = this.m_csOriginalInitialInfo as McTestDataGeneratorInitialData;

            if (m_csTmpPrpty.KIND == 1)
            {
                RNDradioButton.Checked = true;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                SlectTabControl.SelectedIndex = 0;
            }
            else if (m_csTmpPrpty.KIND == 2)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = true;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                SlectTabControl.SelectedIndex = 1;
            }
            else if (m_csTmpPrpty.KIND == 3)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = true;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                SlectTabControl.SelectedIndex = 2;
            }
            else if (m_csTmpPrpty.KIND == 4)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = true;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                SlectTabControl.SelectedIndex = 3;
            }
            else if (m_csTmpPrpty.KIND == 5)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = true;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                SlectTabControl.SelectedIndex = 4;
            }
            else if (m_csTmpPrpty.KIND == 6)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = true;
                ConstCoeffRadioButton.Checked = false;
                SlectTabControl.SelectedIndex = 5;
            }
            else if (m_csTmpPrpty.KIND == 7)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = true;
                SlectTabControl.SelectedIndex = 6;
            }
            // 画面表示情報編集
            RandMaxTextBox.Text =  m_csTmpPrpty.RND_MAX.ToString();
            RandMinTextBox.Text = m_csTmpPrpty.RND_MIN.ToString();

            GaussMeanTextBox.Text = m_csTmpPrpty.GAUSS_MEAN.ToString();
            GaussSigmaTextBox.Text = m_csTmpPrpty.GAUSS_SIGMA.ToString();

            BMInitTextBox.Text = m_csTmpInit.BM_X0.ToString();

            ARInitTextBox.Text = m_csTmpInit.AR_X0.ToString();
            ARR1textBox.Text = m_csTmpPrpty.AR_R1.ToString();
            ARScaleWTextBox.Text = m_csTmpPrpty.AR_SCALE_W.ToString();
            ARScaleYtextBox.Text = m_csTmpPrpty.AR_SCALE_Y.ToString();

            ARMRInitTextBox.Text = m_csTmpInit.ARMA_X0.ToString();
            ARMRFaiTextBox.Text = m_csTmpPrpty.ARMA_FAI.ToString();
            ARMRTheataTextBox.Text = m_csTmpPrpty.ARMA_THEATA.ToString();
            ARMRScaleWTextBox.Text = m_csTmpPrpty.ARMA_SCALE_W.ToString();
            ARMRScaleYTextBox.Text = m_csTmpPrpty.ARMA_SCALE_Y.ToString();

            TFInitTextBox.Text = m_csTmpInit.TF_X0.ToString();
            TFR1textBox.Text = m_csTmpPrpty.TF_R1.ToString();
            TFSGXtextBox.Text = m_csTmpPrpty.TF_SGX.ToString();
            TFAVXtextBox.Text = m_csTmpPrpty.TF_AVX.ToString();
            TFAXtextBox.Text = m_csTmpPrpty.TF_AX.ToString();
            TFScaleWtextBox.Text = m_csTmpPrpty.TM_SCALE_W.ToString();

            ConstCoeffTextBox.Text = m_csTmpPrpty.CONST_COEFF.ToString();

        }



        /// <summary><para>method outline:</para>
        /// <para>設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ParaSet_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>「設定」ボタンを押下された時の処理を記述</para>
        /// </remarks>
        private void ParaSet_Click(object sender, EventArgs e)
        {
            // 設定ボタン押下時の処理を記述する。
            // ①入力データの整合性チェックする。
            // 　入力データに異常があれば異常項目を通知し、メソッド終了（return）
            // ②既存の情報と変更があるかチェックする。
            // ③②で変更があった場合
            // 　入力データの保存をする。
            // 　m_csPropertyInfoおよびm_csInitialInfoへ入力データを保存
            // 　DialogResultへDialogResult.OKをセット
            // ③②で変更が無かった場合
            // 　DialogResultへDialogResult.Cancelをセット
            // ④画面終了（Close）
            m_csPrpty.MINUS_CUT = m_csTmpPrpty.MINUS_CUT;
            m_csPrpty.KIND = m_csTmpPrpty.KIND;

            m_csPrpty.RND_MAX = m_csTmpPrpty.RND_MAX;
            m_csPrpty.RND_MIN = m_csTmpPrpty.RND_MIN;
            m_csPrpty.GAUSS_MEAN = m_csTmpPrpty.GAUSS_MEAN;
            m_csPrpty.GAUSS_SIGMA = m_csTmpPrpty.GAUSS_SIGMA;
            m_csPrpty.AR_R1 = m_csTmpPrpty.AR_R1;
            m_csPrpty.AR_SCALE_W = m_csTmpPrpty.AR_SCALE_W;
            m_csPrpty.AR_SCALE_Y = m_csTmpPrpty.AR_SCALE_Y;
            m_csPrpty.ARMA_FAI = m_csTmpPrpty.ARMA_FAI;
            m_csPrpty.ARMA_THEATA = m_csTmpPrpty.ARMA_THEATA;
            m_csPrpty.ARMA_SCALE_W = m_csTmpPrpty.ARMA_SCALE_W;
            m_csPrpty.ARMA_SCALE_Y = m_csTmpPrpty.ARMA_SCALE_Y;
            m_csPrpty.TF_R1 = m_csTmpPrpty.TF_R1;
            m_csPrpty.TF_SGX = m_csTmpPrpty.TF_SGX;
            m_csPrpty.TF_AVX = m_csTmpPrpty.TF_AVX;
            m_csPrpty.TF_AX = m_csTmpPrpty.TF_AX;
            m_csPrpty.TM_SCALE_W = m_csTmpPrpty.TM_SCALE_W;

            m_csPrpty.CONST_COEFF = m_csTmpPrpty.CONST_COEFF;

            m_csInit.BM_X0 = m_csTmpInit.BM_X0;
            m_csInit.AR_X0 = m_csTmpInit.AR_X0;
            m_csInit.ARMA_X0 = m_csTmpInit.ARMA_X0;
            m_csInit.TF_X0 = m_csTmpInit.TF_X0;

            DialogResult = DialogResult.OK;     // 設定変更がある場合

            //DialogResult = DialogResult.Cancel; // 設定変更がない場合

            Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>キャンセル処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Cancel_Click(sender,e);</para>
        /// </example>
        /// <param name="sender">Object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>「キャンセル」ボタンを押下された時の処理を記述</para>
        /// </remarks>
        private void Cancel_Click(object sender, EventArgs e)
        {
            DialogResult = DialogResult.Cancel;
            Close();
        }

        private void RNDradioButton_CheckedChanged(object sender, EventArgs e)
        {
            RNDradioButton.Checked = true;
            GAUSSradioButton.Checked = false;
            BMradioButton.Checked = false;
            ARadioButton.Checked = false;
            ARMRradioButton.Checked = false;
            TFradioButton.Checked = false;
            ConstCoeffRadioButton.Checked = false;
            m_csTmpPrpty.KIND = 1;
            SlectTabControl.SelectedIndex = 0;
        }

        private void GAUSSradioButton_CheckedChanged(object sender, EventArgs e)
        {
            RNDradioButton.Checked = false;
            GAUSSradioButton.Checked = true;
            BMradioButton.Checked = false;
            ARadioButton.Checked = false;
            ARMRradioButton.Checked = false;
            TFradioButton.Checked = false;
            ConstCoeffRadioButton.Checked = false;
            m_csTmpPrpty.KIND = 2;
            SlectTabControl.SelectedIndex = 1;
        }

        private void BMradioButton_CheckedChanged(object sender, EventArgs e)
        {
            RNDradioButton.Checked = false;
            GAUSSradioButton.Checked = false;
            BMradioButton.Checked = true;
            ARadioButton.Checked = false;
            ARMRradioButton.Checked = false;
            TFradioButton.Checked = false;
            ConstCoeffRadioButton.Checked = false;
            m_csTmpPrpty.KIND = 3;
            SlectTabControl.SelectedIndex = 2;
        }

        private void ARadioButton_CheckedChanged(object sender, EventArgs e)
        {
            RNDradioButton.Checked = false;
            GAUSSradioButton.Checked = false;
            BMradioButton.Checked = false;
            ARadioButton.Checked = true;
            ARMRradioButton.Checked = false;
            TFradioButton.Checked = false;
            ConstCoeffRadioButton.Checked = false;
            m_csTmpPrpty.KIND = 4;
            SlectTabControl.SelectedIndex = 3;
        }

        private void ARMRradioButton_CheckedChanged(object sender, EventArgs e)
        {
            RNDradioButton.Checked = false;
            GAUSSradioButton.Checked = false;
            BMradioButton.Checked = false;
            ARadioButton.Checked = false;
            ARMRradioButton.Checked = true;
            TFradioButton.Checked = false;
            ConstCoeffRadioButton.Checked = false;
            m_csTmpPrpty.KIND = 5;
            SlectTabControl.SelectedIndex = 4;
        }

        private void TFradioButton_CheckedChanged(object sender, EventArgs e)
        {
            RNDradioButton.Checked = false;
            GAUSSradioButton.Checked = false;
            BMradioButton.Checked = false;
            ARadioButton.Checked = false;
            ARMRradioButton.Checked = false;
            TFradioButton.Checked = true;
            ConstCoeffRadioButton.Checked = false;
            m_csTmpPrpty.KIND = 6;
            SlectTabControl.SelectedIndex = 5;
        }

        private void ConstCoeffRadioButton_Click(object sender, EventArgs e)
        {
            RNDradioButton.Checked = false;
            GAUSSradioButton.Checked = false;
            BMradioButton.Checked = false;
            ARadioButton.Checked = false;
            ARMRradioButton.Checked = false;
            TFradioButton.Checked = false;
            ConstCoeffRadioButton.Checked = true;
            m_csTmpPrpty.KIND = 7;
            SlectTabControl.SelectedIndex = 6;
        }

        private void RandMaxTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.RND_MAX = Convert.ToDouble(RandMaxTextBox.Text);
        }

        private void RandMinTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.RND_MIN = Convert.ToDouble(RandMinTextBox.Text);
        }

        private void GaussMeanTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.GAUSS_MEAN = Convert.ToDouble(GaussMeanTextBox.Text);
        }

        private void GaussSigmaTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.GAUSS_SIGMA = Convert.ToDouble(GaussSigmaTextBox.Text);
        }

        private void BMInitTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpInit.BM_X0 = Convert.ToDouble(BMInitTextBox.Text);
        }

        private void ARInitTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpInit.AR_X0 = Convert.ToDouble(ARInitTextBox.Text);
        }

        private void ARR1textBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.AR_R1 = Convert.ToDouble(ARR1textBox.Text);
        }

        private void ARScaleWTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.AR_SCALE_W = Convert.ToDouble(ARScaleWTextBox.Text);
        }

        private void ARScaleYtextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.AR_SCALE_Y = Convert.ToDouble(ARScaleYtextBox.Text);
        }

        private void ARMRInitTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpInit.ARMA_X0 = Convert.ToDouble(ARMRInitTextBox.Text);
        }

        private void ARMRFaiTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.ARMA_FAI = Convert.ToDouble(ARMRFaiTextBox.Text);
        }

        private void ARMRTheataTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.ARMA_THEATA = Convert.ToDouble(ARMRTheataTextBox.Text);
        }

        private void ARMRScaleWTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.ARMA_SCALE_W = Convert.ToDouble(ARMRScaleWTextBox.Text);
        }

        private void ARMRScaleYTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.ARMA_SCALE_Y = Convert.ToDouble(ARMRScaleYTextBox.Text);
        }

        private void TFInitTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpInit.TF_X0 = Convert.ToDouble(TFInitTextBox.Text);
        }

        private void TFR1textBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.TF_R1 = Convert.ToDouble(TFR1textBox.Text);
        }

        private void TFSGXtextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.TF_SGX = Convert.ToDouble(TFSGXtextBox.Text);
        }

        private void TFAVXtextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.TF_AVX = Convert.ToDouble(TFAVXtextBox.Text);
        }

        private void TFAXtextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.TF_AX = Convert.ToDouble(TFAXtextBox.Text);
        }

        private void TFScaleWtextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.TM_SCALE_W = Convert.ToDouble(TFScaleWtextBox.Text);
        }

        private void ConstCoeffTextBox_TextChanged(object sender, EventArgs e)
        {
            m_csTmpPrpty.CONST_COEFF = Convert.ToDouble(ConstCoeffTextBox.Text);
        }

        private void MinusCheckBox_CheckedChanged(object sender, EventArgs e)
        {

            m_csTmpPrpty.MINUS_CUT = MinusCheckBox.Checked;

        }

        private void SlectTabControl_SelectedIndexChanged(object sender, EventArgs e)
        {
            System.Windows.Forms.TabControl csTbCtl = sender as System.Windows.Forms.TabControl;
            int iSlctIdx = csTbCtl.SelectedIndex;


            if (iSlctIdx == 0)
            {
                RNDradioButton.Checked = true;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                m_csTmpPrpty.KIND = 1;
            }
            else if (iSlctIdx == 1)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = true;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                m_csTmpPrpty.KIND = 2;
            }
            else if (iSlctIdx == 2)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = true;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                m_csTmpPrpty.KIND = 3;
            }
            else if (iSlctIdx == 3)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = true;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                m_csTmpPrpty.KIND = 4;
            }
            else if (iSlctIdx == 4)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = true;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = false;
                m_csTmpPrpty.KIND = 5;
            }
            else if (iSlctIdx == 5)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = true;
                ConstCoeffRadioButton.Checked = false;
                m_csTmpPrpty.KIND = 6;
            }
            else if (iSlctIdx == 6)
            {
                RNDradioButton.Checked = false;
                GAUSSradioButton.Checked = false;
                BMradioButton.Checked = false;
                ARadioButton.Checked = false;
                ARMRradioButton.Checked = false;
                TFradioButton.Checked = false;
                ConstCoeffRadioButton.Checked = true;
                m_csTmpPrpty.KIND = 7;
            }

        }


    }
}