﻿// <summary>ソースコード：マージモデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.OptionImpl.McMergeForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>マージモデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/01/13][新規作成]</para>
    /// </remarks>
    public class McMergeDefine
    {
        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MERGE_FACTORY_LIB_ID = new HySID("McMerge_Factory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        // ToDo 提供するモデルの種別と名称を定義して下さい。
        /// <summary>テスト用モデル種別</summary>
        public static readonly HySObjectKind MERGE_MODEL_KIND = new HySObjectKind("McMerge_Model");
        /// <summary>テスト用モデル名称</summary>
        public static readonly HySString MERGE_MODEL_NAME = new HySString("マージモデル");

        //********************************
        //===== 送受信パターン定義 =======
        //********************************
        // 受信パターン
        /// <summary>過去データ</summary>
        public static readonly HySID IN_PATTERN_PAST = new HySID("PastIn");
        /// <summary>最新データ</summary>
        public static readonly HySID IN_PATTERN_NEW = new HySID("NewIn");

        // 送信パターン
        /// <summary>マージデータ</summary>
        public static readonly HySID OUT_PATTERN_MERGED = new HySID("MergedOut");
    }
}
