﻿// <summary>ソースコード：マージモデルファクトリクラス型紙</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>マージモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/01/13][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McMergeForDevelop.McMergeFactory();
        }
    }
}

namespace CommonMP.HYMCO.OptionImpl.McMergeForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>マージモデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/01/13][新規作成]</para>
    /// </remarks>
    public class McMergeFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return McMergeDefine.MERGE_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (csModelKind.Equals(McMergeDefine.MERGE_MODEL_KIND) == true)
            {
                csCalModel = new McMergeModel();
            }
            else
            {
                // Do Nothing
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind.Equals(McMergeDefine.MERGE_MODEL_KIND) == true)
            {
                csCalInfoData = new McMergeCalInfo();
            }
            else
            {
                // Do Nothing
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(McMergeDefine.MERGE_MODEL_KIND) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(60); // δT設定 60秒
                // 受信可能なパターン
                {
                    // 第１パターン(過去データ)
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McMergeDefine.IN_PATTERN_PAST,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "過去データ") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意入力", HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR);  // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                    // 第２パターン(最新データ)
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McMergeDefine.IN_PATTERN_NEW,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "最新データ") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意入力", HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR);  // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }

                // 送信パターンの設定
                {
                    // 第１パターン(マージデータ)
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McMergeDefine.OUT_PATTERN_MERGED,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "マージデータ") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意出力", HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else
            {
                // Do Noghing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind.Equals(McMergeDefine.MERGE_MODEL_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_ETC, // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    McMergeDefine.MERGE_MODEL_KIND, // モデルの識別子
                    McMergeDefine.MERGE_MODEL_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("過去データと最新データをマージするモデル。(但し、１次元時系列データのみ)");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName(new HySString("DefaultModel"));
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            return m_csCalModelInforList;
        }

    }
}
