﻿// <summary>ソースコード：マージモデル要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;


namespace CommonMP.HYMCO.OptionImpl.McMergeForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>マージモデル要素演算データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/01/13][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McMergeCalInfo : McCalInfo
    {
        /// <summary>出力データ</summary>
        public double m_dOut=0.0;


        /// <summary>データの次元数</summary>
        public long m_lDimNum = 0;
        /// <summary>配列数：Ｄｉｍ１ </summary>
        public long m_lDim1 = 0;
        /// <summary>配列数：Ｄｉｍ２ </summary>
        public long m_lDim2 = 0;
        /// <summary>配列数：Ｄｉｍ３ </summary>
        public long m_lDim3 = 0;
        /// <summary>セル内の変数の数</summary>
        public long m_lDataDimInCell = 0;

        //// <summary>マージデータ一時保管場所</summary>
        //public McTimeSeriesD1CellArrayTranInfo m_csMargedDataObj =null;
        /// <summary>既に入力したデータ</summary>
        public HySTime m_LastInTime = HySTime.DEFAULT_TIME.Clone() + new HySTime(1);
        /// <summary>既に出力したデータ</summary>
        public HySTime m_LastOutTime = HySTime.DEFAULT_TIME.Clone() + new HySTime(1);

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McMergeCalInfo csRtn = new McMergeCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McMergeCalInfo csOrdDt = (McMergeCalInfo)csOrgInfo;

            this.m_dOut = csOrdDt.m_dOut;            
            return true;
        }

    }
}
