﻿using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{
    /// <summary><para>class outline:</para>
    /// <para>テストサンプル要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class DmyBasinCalInfo : McCalInfo
    {
        /// <summary>ワーク：物理的意味はない</summary>
        public long     m_lStockNum = 5;
        /// <summary>ワーク：物理的意味はない</summary>
        public double[] m_dCapacitance = null;        // 容量：[m3]
        /// <summary>ワーク：物理的意味はない</summary>
        public double[] m_dResistanceIn = null;         // 流入抵抗：[1/m3]
        /// <summary>ワーク：物理的意味はない</summary>
        public double[] m_dResistanceOut = null;         // 流出抵抗：[1/m3]
        /// <summary>ワーク：物理的意味はない</summary>
        public double[] m_dInductanceOut = null;         // 流出抵抗：[1/m3]
        /// <summary>ワーク：物理的意味はない</summary>
        public double   m_dOutResistanceOut = 1.0 / 20.0;   // [1/m3]
        /// <summary>ワーク：物理的意味はない</summary>
        public double   m_dArea = 1000.0 * 1000.0;     // 面積：[m2]
        /// <summary>ワーク：物理的意味はない</summary>
        public double   m_dK = 0.5;
        /// <summary>ワーク：物理的意味はない</summary>
        public double[] m_dQ = null;        // 蓄積量：[m3]
        /// <summary>ワーク：物理的意味はない:前回値</summary>
        public double[] m_dPrevI = null;        // 蓄積量：[m3/sec]
        /// <summary>ワーク：物理的意味はない:前回値</summary>
        public double[] m_dPrevDltQ = null;        // 前回蓄積変化量：[m3/sec]
        /// <summary>ワーク：物理的意味はない:前回値</summary>
        public long[] m_lDlyTm = null;
        /// <summary>ワーク：物理的意味はない:前回値</summary>
        public long m_lDlyMx = 10;
        /// <summary>ワーク：物理的意味はない:前回値</summary>
        public double[,] m_TransQ = null;
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dTotalOut = 0.0;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> new DmyBasinCalInfo() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public DmyBasinCalInfo()
        {

            m_dCapacitance = new double[m_lStockNum];
            m_dResistanceIn = new double[m_lStockNum];
            m_dResistanceOut = new double[m_lStockNum];
            m_dInductanceOut = new double[m_lStockNum];
            m_dQ = new double[m_lStockNum];

            m_dPrevDltQ = new double[m_lStockNum];
            m_dPrevI = new double[m_lStockNum];
            m_lDlyTm = new long[m_lStockNum];

            m_dCapacitance[0] = 100640.0;
            m_dCapacitance[1] = 200770.0;
            m_dCapacitance[2] = 718400.0;
            m_dCapacitance[3] = 51840000.0;
            m_dCapacitance[4] = 91840000.0;

            m_dResistanceIn[0] = 1.0 / 1000.0;
            m_dResistanceIn[1] = 1.0 / 400.0;
            m_dResistanceIn[2] = 1.0 / 150.0;
            m_dResistanceIn[3] = 1.0 / 30.0;
            m_dResistanceIn[4] = 1.0 / 15.0;

            m_dResistanceOut[0] = 1.0 / 500.0;
            m_dResistanceOut[1] = 1.0 / 200.0;
            m_dResistanceOut[2] = 1.0 / 50.0;
            m_dResistanceOut[3] = 1.0 / 10.0;
            m_dResistanceOut[4] = 1.0 / 5.0;

            m_dInductanceOut[0] = 500.0 / 1000.0;
            m_dInductanceOut[1] = 200.0 / 1000.0;
            m_dInductanceOut[2] = 50.0 / 1000.0;
            m_dInductanceOut[3] = 10.0 / 1000.0;
            m_dInductanceOut[4] = 5.0 / 1000.0;

            m_dQ[0] = 10.0;
            m_dQ[1] = 3770.0;
            m_dQ[2] = 518400.0;
            m_dQ[3] = 49840000.0;
            m_dQ[4] = 51840000.0;

            m_dPrevI[0] = 10.0;
            m_dPrevI[1] = 10.0;
            m_dPrevI[2] = 10.0;
            m_dPrevI[3] = 10.0;
            m_dPrevI[4] = 5.0;

            m_dPrevDltQ[0] = 0.0;
            m_dPrevDltQ[1] = 0.0;
            m_dPrevDltQ[2] = 0.0;
            m_dPrevDltQ[3] = 0.0;
            m_dPrevDltQ[4] = 0.0;

            m_dOutResistanceOut = 0.0;
            for (long lLp = 0; lLp < m_lStockNum; lLp++)
            {
                m_dOutResistanceOut += m_dResistanceOut[lLp];
            }
            m_lDlyTm[0] = 3;
            m_lDlyTm[1] = 3;
            m_lDlyTm[2] = 5;
            m_lDlyTm[3] = 8;
            m_lDlyTm[4] = 9;

            m_TransQ = new double[m_lStockNum,m_lDlyMx];
            for (long lLp = 0; lLp < m_lDlyMx; lLp++)
            {
                for (long lLp2 = 0; lLp2 < m_lStockNum; lLp2++)
                {
                    m_TransQ[lLp2, lLp] = 0.0;
                }
                
            }
        }
        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            DmyBasinCalInfo csRtn = new DmyBasinCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }  
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            DmyBasinCalInfo csOrdDt = csOrgInfo as DmyBasinCalInfo;
            if (csOrdDt != null)
            {
                m_lStockNum = csOrdDt.m_lStockNum;
                for (long lLp = 0; lLp < m_lStockNum; lLp++)
                {
                    m_dCapacitance[lLp] = csOrdDt.m_dCapacitance[lLp];        // [m3]
                    m_dResistanceIn[lLp] = csOrdDt.m_dResistanceIn[lLp];         // [1/m3]
                    m_dResistanceOut[lLp] = csOrdDt.m_dResistanceOut[lLp];         // [m3]
                    m_dInductanceOut[lLp] = csOrdDt.m_dInductanceOut[lLp];
                    m_dQ[lLp] = csOrdDt.m_dQ[lLp];        // [m3]
                    m_dPrevI[lLp] = csOrdDt.m_dPrevI[lLp];        // [m3]
                    m_dPrevDltQ[lLp] = csOrdDt.m_dPrevDltQ[lLp];        // [m3]
                    m_lDlyTm[lLp] = csOrdDt.m_lDlyTm[lLp];        // [m3]
                }
                m_dOutResistanceOut = csOrdDt.m_dOutResistanceOut;
                m_dArea = csOrdDt.m_dArea;
                m_dK = csOrdDt.m_dK;
                m_dTotalOut = csOrdDt.m_dTotalOut;
                for (long lLp = 0; lLp < m_lDlyMx; lLp++)
                {
                    for (long lLp2 = 0; lLp2 < m_lStockNum; lLp2++)
                    {
                        m_TransQ[lLp2, lLp] = csOrdDt.m_TransQ[lLp2, lLp];
                    }

                }
            }
            return true;
        }
    }
}
