﻿// <summary>ソースコード：テスト用降雨発生要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{
    /// <summary><para>class outline:</para>
    /// <para>ソースコード：テスト用降雨発生要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class DmyRainFallCalInfo : McCalInfo, IDeserializationCallback
    {
        // 地点降雨計算用


        // 短期用
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dData=0.0;
        /// <summary>ワーク：物理的意味はない</summary>
        public int m_iCnt = 0;
        /// <summary>ワーク：物理的意味はない</summary>
        public int m_iOffset = 0;
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dAcc = 0.0;
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dInth = 0.0;
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dMax = 10.0;

        // 長期用
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dDataLg = 0.0;
        /// <summary>ワーク：物理的意味はない</summary>
        public int m_iCntLg = 0;
        /// <summary>ワーク：物理的意味はない</summary>
        public int m_iOffsetLg = 0;

        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dAccLg = 0.0;
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dInthLg = 0.0;
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dMaxLg = 10.0;

        /// <summary>ワーク：物理的意味はない</summary>
        public int m_iCntOFF = 0;
        /// <summary>ワーク：物理的意味はない</summary>
        public double m_dDataOFF = 0.0;
        /// <summary>ワーク：物理的意味はない</summary>
        public int m_iOffsetOFF = 0;

        /// <summary>乱数 </summary>
        [NonSerialized]
        public Random m_Rnd = new Random();

        /// <summary>乱数の種を各モデルで異ならせる為の　共通変数</summary>
        [NonSerialized]
        public static int iRndSeed = 1;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> new DmyRainFallCalInfo( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public DmyRainFallCalInfo()
        {
            iRndSeed += 1;
            int iSeed = (int)(HySCalendar.CreateNowTime().GetTime() / 10000.0) + iRndSeed.GetHashCode() * 123;
            m_Rnd = new Random(iSeed);
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            DmyRainFallCalInfo csRtn = new DmyRainFallCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            DmyRainFallCalInfo csOrdDt = (DmyRainFallCalInfo)csOrgInfo;
            if( csOrdDt != null )
            {
                m_dData = csOrdDt.m_dData;
                m_iCnt = csOrdDt.m_iCnt;
                m_iOffset = csOrdDt.m_iOffset;
                m_dAcc = csOrdDt.m_dAcc;
                m_dInth = csOrdDt.m_dInth;
                m_dMax = csOrdDt.m_dMax;

                m_dDataLg = csOrdDt.m_dDataLg;
                m_iCntLg = csOrdDt.m_iCntLg;
                m_iOffsetLg = csOrdDt.m_iOffsetLg;
                m_dAccLg = csOrdDt.m_dAccLg;
                m_dInthLg = csOrdDt.m_dInthLg;
                m_dMaxLg = csOrdDt.m_dMaxLg;
            }
            return true;
        }
        /// <summary><para>method outline:</para>
        /// <para>逆シリアル化時追加処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> IDeserializationCallback.OnDeserialization(csObj)</para>
        /// </example>
        /// <param name="csObj">ダミー</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>予約処理</para>
        /// </remarks>
        void IDeserializationCallback.OnDeserialization(Object csObj)
        {
            iRndSeed += 1;
            int iSeed = (int)(HySCalendar.CreateNowTime().GetTime() / 1000.0) + iRndSeed*10;
            m_Rnd = new Random(iSeed);
        }
    }
}
