// <summary>ソースコード：演算要素モデルネットワーク生成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;
using CommonMP.HYSSOP.CoreImpl.HSViewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;

using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;
using CommonMP.HYMCO.CoreImpl.Model;

using CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB;

using CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{
    /// <summary><para>class outline:</para>
    /// <para>演算要素モデルネットワーク生成クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    ///<para>remarks:</para>
    /// <para>
    /// 各モデル要素を組み合わせて、全体も出るを作成するクラスの例。
    /// 出力は構造定義ファイルに出力される。
    /// </para>
    /// </remarks>
    public class SampleModelNetworkGenerator : McModelNetworkGeneratorBase
    {
// ★★★★★★★★★★★★★★★★★★★★★★★★     
//  複数の演算要素を使用して、それらを接続する場合に用いる「演算要素接続状態を作成するクラス」のコーディング例である。
//  モデルは単一の演算要素モデルだけではなく、複数の演算要素を組み合わせたい場合がある。
//  従って本クラスは、複数の演算要素モデルを組み合わせてモデルを作成する。
//  作成した構造は、構造定義ファイル本体に書き出す。
//  ＸＭＬ化処理は、 HySXmlNode クラスが行うので、
//  本クラスは、　HySXmlNode クラスへ情報を積み込めばよい
// ★★★★★★★★★★★★★★★★★★★★★★★★

        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成前のチェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CheckBefoModelGeneration(
        ///                       ref csMDGInfo)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 演算要素モデルネットワーク作成の前に、期待通りの情報が取得されているかをチェックする
        /// </para>
        /// </remarks>
        public override bool CheckBefoModelGeneration(ref McModelDataGenerationInfoIF csMDGInfo)
        {
            bool bRtn = false;
            // 処理中断フラグが true ならば　直ちに処理中断
            if (this.m_bBreakFlg == true) { return bRtn; }
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            // ToDo 
            // モデル生成に必要な情報が入っているか否かをチェックする
            // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            McModelDataGenerationInfo csMdlDataInfo = csMDGInfo as McModelDataGenerationInfo;
            if (csMdlDataInfo != null)
            {
                bRtn = true;
                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
                // ↓↓↓　此処からが,画面等で設定された情報を取得するコーディング例です　↓↓↓
                // 使用する各種データファイルの取得方法
                //例：その１、落水線データファイルを取得する場合（共通GIS情報）
                HySString csFileName = new HySString("");
                bool bLclRtn = csMdlDataInfo.GetInfo(HySGISDataKindDefine.KIND_GIS_DRAINAGE_DIRECTION_MATRIX, ref csFileName);
                //csFileName 内に　落水線情報を格納したファイル名（フルパス）が入っている。
                //例：その２、流量配分データ を取得したい場合（共通手入力情報I
                bLclRtn = csMdlDataInfo.GetInfo(CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB.McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_1, ref csFileName);
                //csFileName 内に　流量配分データを格納したファイル名（フルパス）が入っている。
                //例：その３、独自データの場合(ファイルを読む部分までサンプルコードを入れている)
                bLclRtn = csMdlDataInfo.GetInfo(SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND, ref csFileName);
                if (bLclRtn == true)
                {
                    /*
                    // 此処でファイル情報を読む
                    // 例： 
                    HySFile csAInfFile = new HySFile(csFileName);
                    csAInfFile.Open(HySFile.OPEN_MODE.OPEN, HySFile.READ_WRITE_MODE.READ, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    HySString sOut = new HySString();
                    csAInfFile.ReadText(ref sOut);
                    csAInfFile.Close();
                    // XMLファイルを読む場合
                    // 例：
                    HySXmlReader csXmlReader = new HySXmlReader(csFileName);
                    HySXmlNode csXmlRootNode = csXmlReader.GetRootNode();
                    if (csXmlRootNode is HySXmlNode)
                    {  // XMLファイルが有る場合
                       .........
                    }
                    */
                }
                //csFileName 内に　独自の情報を格納したファイル名（フルパス）が入っている。
                // ↑↑↑↑　此処まで,画面等で設定された情報を取得するコーディング例です　↑↑↑

                // 上記で取得した情報に不足等あれば、
                // bRtn = false;
                // に設定して下さい。
                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算システム全体を制御するプロパティ情報の生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateSystemPorperty(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する
        /// 個別のモデルに対するプロパティではなく、全体を制御するプロパティ情報を生成する
        ///   例：同期／非同期動作区分、部分系動作／収束演算区分　等
        /// </para>
        /// </remarks>
        public override HySXmlNode CreateSystemPorperty(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csXmlParent,
                    ref HySXmlWriter csXmlWriter)
        {
            // 構造定義ファイル
            HySXmlNode csRtnNode = csXmlWriter.CreateElement(McDefine.xml_PROPERTY );
            csRtnNode.SetAttribute(McDefine.xml_DATAFUSIONTIMING, "ASYNCHRONOUS"); // <-- 非同期型
            csRtnNode.SetAttribute(McDefine.xml_TIMESTEP, "60");  // 系全体を進める時間間隔
            //  <Property DataFusionTiming="ASYNCHRONOUS" TimeStep="60" />  この様なタグが生成される

            return csRtnNode;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算要素／接続線生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModels(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csXmlParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csXmlParent">親XMLノードクラス</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義ファイルへ書き込む情報をXMLノードとして設定する
        /// 個別の演算要素を組み合わせて（ネットワークを形成して）一つのモデルを構築する
        /// </para>
        /// </remarks>
        public override bool CreateModels(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csXmlParent,
                    ref HySXmlWriter csXmlWriter)
        {
            bool bRtn = true;

            // 処理中断フラグが true ならば　直ちに処理中断
            if (this.m_bBreakFlg == true) { return false; }


            // 本来は、McModelDataGenerationInfoIF csMDGInfo から取得した情報を元に、配置する演算要素、演算要素間の接続、を行う。
            // これらのアルゴリズムは、各モデル開発者が　研究開発し、実装する。
            // 此処では、構築するモデルを　如何にして　構造定義ファイル化するかというサンプルを記述する。

            McModelDataGenerationInfo csMdlDataInfo = csMDGInfo as McModelDataGenerationInfo;
            if (csMdlDataInfo != null)
            {
                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
                // ↓↓↓　此処からが,画面等で設定された情報を取得するコーディング例です　↓↓↓
                // 使用する各種データファイルの取得方法
                //例：その１、落水線データファイルを取得する場合（共通GIS情報）
                HySString csFileName=new HySString("");
                csMdlDataInfo.GetInfo(HySGISDataKindDefine.KIND_GIS_DRAINAGE_DIRECTION_MATRIX, ref csFileName);
                //csFileName 内に　落水線情報を格納したファイル名（フルパス）が入っている。
                //例：その２、流量配分データ を取得したい場合（共通手入力情報I
                csMdlDataInfo.GetInfo(CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB.McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_1, ref csFileName);
                //csFileName 内に　流量配分データを格納したファイル名（フルパス）が入っている。
                //例：その３、独自データの場合
                csMdlDataInfo.GetInfo(SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND, ref csFileName);
                //csFileName 内に　独自の情報を格納したファイル名（フルパス）が入っている。
                // ↑↑↑↑　此処まで,画面等で設定された情報を取得するコーディング例です　↑↑↑
                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★


                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★
                // ↓↓↓　此処からが,構造定義ファイル作成の例です　↓↓↓

                //----------------------------------
                // Step No 1  演算要素を配置します
                //----------------------------------

                // 1.ダミー降雨（上流）
                McElementTagInf csElmInf = new McElementTagInf(
                                                 new HySID("RainFall01"),   // 本モデル内でのユニークID
                                                 SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL,  // モデルの種別
                                                 SampleMdlGenDefine.MODEL_FACTORY_LIB_ID,   // <-- ファクトリID
                                                 -438,  // X位置
                                                 -61);  // Y位置
                csElmInf.SetElementName(new HySString("ダミー降雨（上流）"));
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                HySXmlNode csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // ダミー降雨（上流）から送信する端子を生成
                McPortTagInf csRF1HtPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("HetRain01"));
                this.AddPortTag(ref csElmNode, csRF1HtPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（モニター）
                McPortTagInf csRF1RnOutPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("RainOut02"));
                this.AddPortTag(ref csElmNode, csRF1RnOutPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（下流へ）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）


                // 2.ダミー降雨（横流）
                csElmInf = new McElementTagInf(
                                         new HySID("RainFall02"),
                                         SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL,
                                         SampleMdlGenDefine.MODEL_FACTORY_LIB_ID,
                                         -325,
                                         -154);
                csElmInf.SetElementName(new HySString("ダミー降雨（横）"));  // 必須ではない
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // ダミー降雨（横流）から送信する端子を生成
                McPortTagInf csRFSideHtPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("SidHetRain01"));
                this.AddPortTag(ref csElmNode, csRFSideHtPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（モニター）
                McPortTagInf csRFSideRnOutPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("SidRainOut02"));
                this.AddPortTag(ref csElmNode, csRFSideRnOutPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（下流へ）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）

                // 3.ダミー流域（上流）
                csElmInf = new McElementTagInf(
                                         new HySID("DmyBasin01"),
                                         SampleMdlGenDefine.TEST_DMYBASIN_KIND,
                                         SampleMdlGenDefine.MODEL_FACTORY_LIB_ID,
                                         -359,
                                         -61);
                csElmInf.SetElementName(new HySString("上流流域")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_BASIN); // 必須ではない
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // ダミー降雨（上流）が受信する端子を生成
                McPortTagInf csBs1In = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("1BsnIN"));
                this.AddPortTag(ref csElmNode, csBs1In, ref csXmlWriter); // 要素タグに端子タグを追加（流入）
                // ダミー降雨（上流）から送信する端子を生成
                McPortTagInf csBs1HtPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("HetBsn01"));
                this.AddPortTag(ref csElmNode, csBs1HtPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（モニター）
                McPortTagInf csBs1OutPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("BsnOut02"));
                this.AddPortTag(ref csElmNode, csBs1OutPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（下流へ）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）

                // 4.ダミー流出（横流）
                csElmInf = new McElementTagInf(
                     new HySID("DmyBasin02"),
                     SampleMdlGenDefine.TEST_DMYBASIN_KIND,
                     SampleMdlGenDefine.MODEL_FACTORY_LIB_ID,
                     -204,
                     -156);
                csElmInf.SetElementName(new HySString("横流域")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_BASIN); // 必須ではない
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // ダミー降雨（横流）が受信する端子を生成
                McPortTagInf csBs2In = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("2BsnIN"));
                this.AddPortTag(ref csElmNode, csBs2In, ref csXmlWriter); // 要素タグに端子タグを追加（流入）
                // ダミー降雨（横流）から送信する端子を生成
                McPortTagInf csBsFSideHtPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("SidHetBsn01"));
                this.AddPortTag(ref csElmNode, csBsFSideHtPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（モニター）
                McPortTagInf csBsSideOutPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("SidBsnOut02"));
                this.AddPortTag(ref csElmNode, csBsSideOutPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（河流へ）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）

                // 5.上流河道
                csElmInf = new McElementTagInf(
                     new HySID("SmplRiver01"),
                     CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.KINEMATIC_WAVE_KIND,
                     CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.SAMPLE_MODEL_LIB,
                     -203,
                     -60);
                csElmInf.SetElementName(new HySString("上流河道")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_LANE); // 必須ではない
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 上流河道が受信する端子を生成
                McPortTagInf csUPRvInPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("1RvIN"));
                this.AddPortTag(ref csElmNode, csUPRvInPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（上流からの入力）
                McPortTagInf csURvSideInPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("1RvSideIN"));
                this.AddPortTag(ref csElmNode, csURvSideInPortInf, ref csXmlWriter); // 要素タグに端子タグを追加(横流入)
                // 上流河道から送信する端子を生成
                McPortTagInf csUPRvOutPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("Rv1Out0"));
                this.AddPortTag(ref csElmNode, csUPRvOutPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（下流へ）
                McPortTagInf csURvMonitorPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("Rv1Monitor"));
                this.AddPortTag(ref csElmNode, csURvMonitorPortInf, ref csXmlWriter); // 要素タグに端子タグを追加(モニター用)

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）


                // 6.分岐
                csElmInf = new McElementTagInf(
                     new HySID("DmyBranch"),
                     SampleMdlGenDefine.TEST_BRANCH_KIND,
                     SampleMdlGenDefine.MODEL_FACTORY_LIB_ID,
                     -114,
                     -59);
                csElmInf.SetElementName(new HySString("分岐"));
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 分岐が受信する端子を生成
                McPortTagInf csBrchInPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("BrnchIN"));
                this.AddPortTag(ref csElmNode, csBrchInPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（上流からの入力）
                // 分岐から送信する端子を生成
                McPortTagInf csBrchOutPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("BrchOut0"));
                this.AddPortTag(ref csElmNode, csBrchOutPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（下流へ）
                McPortTagInf csBrchSideOutPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("BrSideOut"));
                this.AddPortTag(ref csElmNode, csBrchSideOutPortInf, ref csXmlWriter); // 要素タグに端子タグを追加(分流)

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）


                // 7.下流河道
                csElmInf = new McElementTagInf(
                     new HySID("SmplRiver02"),
                     CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.KINEMATIC_WAVE_KIND,
                     CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.SAMPLE_MODEL_LIB,
                      65,
                     -58);
                csElmInf.SetElementName(new HySString("下流本流")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_LANE); // 必須ではない
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 上流河道が受信する端子を生成
                McPortTagInf cs2RvInPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("2RvIN"));
                this.AddPortTag(ref csElmNode, cs2RvInPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（上流からの入力）
                // 上流河道から送信する端子を生成
                McPortTagInf cs2vMonitorPortInf = new McPortTagInf(McPortTagInf.SendReceive.SEND, new HySID("2RvMonitor"));
                this.AddPortTag(ref csElmNode, cs2vMonitorPortInf, ref csXmlWriter); // 要素タグに端子タグを追加(モニター用)

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）


                // 8.下流分流河道
                csElmInf = new McElementTagInf(
                     new HySID("SmplRiver03"),
                     CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.KINEMATIC_WAVE_KIND,
                     CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.SAMPLE_MODEL_LIB,
                     65,
                     -132);
                csElmInf.SetElementName(new HySString("下流分流")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_LANE); // 必須ではない
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 上流河道が受信する端子を生成
                McPortTagInf cs3RvInPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("3RvIN"));
                this.AddPortTag(ref csElmNode, cs3RvInPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（上流からの入力）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）


                // 9.上流ハイドロ／ハイエト画面モニター
                csElmInf = new McElementTagInf(
                     new HySID("HHMntorU"),
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO,
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.SYSTEM_MODEL_FACTORY,
                     -396,
                     -7);
                csElmInf.SetElementName(new HySString("上流ハイドロハイエト")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_OUTPUT); // (出力要素形式)
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 上流ハイドロ／ハイエト画面モニターが受信する端子を生成
                McPortTagInf cs1MntRainPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("1MntRainIN"));
                this.AddPortTag(ref csElmNode, cs1MntRainPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（雨量入力）
                McPortTagInf cs1MntHdrPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("1MntHdrIN"));
                this.AddPortTag(ref csElmNode, cs1MntHdrPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（流量入力）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）


                // 10.横流ハイドロ／ハイエト画面モニター
                csElmInf = new McElementTagInf(
                     new HySID("HHMntorSide"),
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO,
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.SYSTEM_MODEL_FACTORY,
                     -282,
                     -202);
                csElmInf.SetElementName(new HySString("横流ハイドロハイエト")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_OUTPUT); // (出力要素形式)
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 上流ハイドロ／ハイエト画面モニターが受信する端子を生成
                McPortTagInf csSidMntRainPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("SidMntRainIN"));
                this.AddPortTag(ref csElmNode, csSidMntRainPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（雨量入力）
                McPortTagInf csSidMntHdrPortInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("SidMntHdrIN"));
                this.AddPortTag(ref csElmNode, csSidMntHdrPortInf, ref csXmlWriter); // 要素タグに端子タグを追加（流量入力）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）


                // 11.上流縦断画面モニター
                csElmInf = new McElementTagInf(
                     new HySID("MntLngU"),
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED,
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.SYSTEM_MODEL_FACTORY,
                     -206,
                     -5);
                csElmInf.SetElementName(new HySString("上流縦断面")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_OUTPUT); // (出力要素形式)
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 上流縦断画面モニターが受信する端子を生成
                McPortTagInf csMntLngUInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("csMntLngUInf"));
                this.AddPortTag(ref csElmNode, csMntLngUInf, ref csXmlWriter); // 要素タグに端子タグを追加（断面入力）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）

                // 12.下流縦断画面モニター
                csElmInf = new McElementTagInf(
                     new HySID("MntLngL"),
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED,
                     CommonMP.HYMCO.Interface.McModelLibraryDefine.SYSTEM_MODEL_FACTORY,
                     67,
                     -6);
                csElmInf.SetElementName(new HySString("下流縦断面")); // 必須ではない
                csElmInf.SetElementShape(McDefine.HYM_DRAW_SUB_KIND_OUTPUT); // (出力要素形式)
                this.AddElement(csElmInf); // 生成した要素は保存しておく <-- 重要
                csElmNode = this.CreateElementTag(csElmInf, ref csXmlWriter); // 要素タグ生成
                // 上流縦断画面モニターが受信する端子を生成
                McPortTagInf csMntLngLInf = new McPortTagInf(McPortTagInf.SendReceive.RECEIVE, new HySID("csMntLngLInf"));
                this.AddPortTag(ref csElmNode, csMntLngLInf, ref csXmlWriter); // 要素タグに端子タグを追加（断面入力）

                csXmlParent.AppendChild(csElmNode); // タグを追加（これが大切：親クラス側で、ＸＭＬファイル化する）

                //----------------------------------
                // Step No 2  演算要素を接続します
                //----------------------------------

                // 1. 上流ダミー降雨発生モデルとダミー流出モデルを接続する

                // 配線情報設定
                HySCellDataGetter csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                HySID csSndPtnID = SampleMdlGenDefine.OUT_RAINFALL;
                HySID csRcvPtnID = SampleMdlGenDefine.RAINFALL_IN;
                // 内挿処理設定
                HySDefine.InterpolateType eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                long lMaxRecord = 32;
                long lDim1 = 1;
                long lDim2 = 0;
                long lDim3 = 0;
                ConnectionPropertyInf csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                ConnectionTagInf csCnct1 = new ConnectionTagInf(
                    new HySID("MainWaterFall"),
                    csRF1RnOutPortInf.GetPortID(), // 送信側端子ID
                    csBs1In.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("接続線１"));
                this.AddConnection(csCnct1);

                // 2. 横流ダミー降雨発生モデルとダミー流出モデルを接続する

                // 配線情報設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.OUT_RAINFALL;
                csRcvPtnID = SampleMdlGenDefine.RAINFALL_IN;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("SideWaterFall"),
                    csRFSideRnOutPortInf.GetPortID(), // 送信側端子ID
                    csBs2In.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("接続線１"));
                this.AddConnection(csCnct1);


                // 3. ダミー流出モデルを河道モデルへ接続する

                // 配線情報設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.OUT_WATER_Q;
                csRcvPtnID = CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.IN_PATTERN_TOP;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("TopInURv"),
                    csBs1OutPortInf.GetPortID(), // 送信側端子ID
                    csUPRvInPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                csCnct1.SetConnectionName(new HySString("上流入力"));
                this.AddConnection(csCnct1);

                // 4. ダミー流出モデルを河道モデルへ接続する(横流入)

                // 配線情報設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.OUT_WATER_Q;
                csRcvPtnID = CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.IN_PATTERN_LATERAL;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("SideInURv"),
                    csBsSideOutPortInf.GetPortID(), // 送信側端子ID
                    csURvSideInPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                csCnct1.SetConnectionName(new HySString("上流入力"));
                this.AddConnection(csCnct1);

                // 4. 上流河道を分流モデルへ接続する

                // 配線情報設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.OUT_PATTERN_BOTTOM;
                csRcvPtnID = SampleMdlGenDefine.IN_WATERQ;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("BrnchIn"),
                    csUPRvOutPortInf.GetPortID(), // 送信側端子ID
                    csBrchInPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                csCnct1.SetConnectionName(new HySString(""));
                this.AddConnection(csCnct1);


                // 5. 分流モデルを下本流河道へ接続する

                // 配線情報設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.BOTTOM_OUT;
                csRcvPtnID = CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.IN_PATTERN_TOP;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("BrnchMainOut"),
                    csBrchOutPortInf.GetPortID(), // 送信側端子ID
                    cs2RvInPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);

                // 6. 分流モデルを下分流河道へ接続する

                // 配線情報設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.SIDE_OUT;
                csRcvPtnID = CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.IN_PATTERN_TOP;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("BrnchSideOut"),
                    csBrchSideOutPortInf.GetPortID(), // 送信側端子ID
                    cs3RvInPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);

                // モニター接続
                // 7. 上流ハイドロ・ハイエトモニター接続する

                // 降雨配線設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.OUT_RAINFALL;
                csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.HYETO_GRAPH_RAIN_SERIAL;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("MntorRain_U"),
                    csRF1HtPortInf.GetPortID(), // 送信側端子ID
                    cs1MntRainPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);

                // 流量配線設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.OUT_WATER_Q;
                //csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.LINE_GRAPH_SINGLE_CELL_ANY;
                csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.HYETO_GRAPH_SINGLE_CELL_SERIAL;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("MntorHH_U"),
                    csBs1HtPortInf.GetPortID(), // 送信側端子ID
                    cs1MntHdrPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);

                // 8. 横流ハイドロ・ハイエトモニター接続する

                // 降雨配線設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.OUT_RAINFALL;
                csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.HYETO_GRAPH_RAIN_SERIAL;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("MntorRain_Side"),
                    csRFSideHtPortInf.GetPortID(), // 送信側端子ID
                    csSidMntRainPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);

                // 流量配線設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = SampleMdlGenDefine.OUT_WATER_Q;
                //csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.LINE_GRAPH_SINGLE_CELL_ANY;
                csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.HYETO_GRAPH_SINGLE_CELL_SERIAL;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 1;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("MntorHH_Side"),
                    csBsFSideHtPortInf.GetPortID(), // 送信側端子ID
                    csSidMntHdrPortInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.SINGLE_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);

                // 9. 上流断面モニター接続する

                // 降雨配線設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.OUT_PATTERN_ALL;
                csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.RIVERBED_SHAPE_D1_CELL_SERIAL;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 51;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("MntorUPRvier"),
                    csURvMonitorPortInf.GetPortID(), // 送信側端子ID
                    csMntLngUInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.D1_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);


                // 10. 下流断面モニター接続する

                // 降雨配線設定
                csCellGetter = new HySCellDataGetter(1);
                csCellGetter.SetIdx(0, 0);
                // モデルの送受信パターン設定
                csSndPtnID = CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.OUT_PATTERN_ALL;
                csRcvPtnID = CommonMP.HYSSOP.CoreImpl.HSViewer.HySMoniterScreen.RIVERBED_SHAPE_D1_CELL_SERIAL;
                // 内挿処理設定
                eInterpltTyp = HySDefine.InterpolateType.LINEAR;
                // レコード数
                lMaxRecord = 32;
                lDim1 = 51;
                lDim2 = 0;
                lDim3 = 0;
                csCnctPrpty = new ConnectionPropertyInf(
                    csCellGetter, csSndPtnID, csRcvPtnID, eInterpltTyp,
                    lMaxRecord, lDim1, lDim2, lDim3
                    );

                csCnct1 = new ConnectionTagInf(
                    new HySID("MntorLWRvier"),
                    cs2vMonitorPortInf.GetPortID(), // 送信側端子ID
                    csMntLngLInf.GetPortID(), // 受信側端子ID
                    McTranInfoDefine.D1_CELL_SERIAL,  // <-- 伝送データのタイプ
                    McModelLibraryDefine.SYSTEM_MODEL_FACTORY,  // <-- ここは固定
                    csCnctPrpty
                    );
                //csCnct1.SetConnectionName(new HySString("本流"));
                this.AddConnection(csCnct1);

                // ↑↑↑↑　此処までが,構造定義ファイル作成の例です　↑↑↑
                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★ 
            }
            return bRtn;
        }


        /// <summary><para>method outline:</para>
        /// <para>自ライブライ以外の演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateExternalModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 自ライブライ外（他のライブラリ）のモデルに対するパラメータ設定等を行いたい場合に使用する
        /// 例えば、A氏が作成した演算要素を　自らのモデル内の構成要素として採用したい場合、そのパラメータを設定する為のクラスを自分で生成する。
        /// 通常は、A氏が作成した要素を良く知っていなければ使用できない。
        /// </para>
        /// </remarks>
        public override McModelParameterGenerator CreateExternalModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            McModelParameterGenerator csModelDataGenerator = null;
            if (McModelSampleDefine.SAMPLE_MODEL_LIB.Equals(csLibraryID) == true)
            {
                if (McModelSampleDefine.KINEMATIC_WAVE_KIND.Equals(csModelKind) == true)
                {   // サンプル用　河道モデルならば
                    csModelDataGenerator = new CommonMP.HYMCO.OptionImpl.ModelGeneratorSample.McSampleKinematicWavePrptyGenerator();
                    csModelDataGenerator.SetID(csModelID);
                    
                }
            }
            else if (McModelLibraryDefine.SYSTEM_MODEL_FACTORY.Equals(csLibraryID) == true)
            {
                if (McModelLibraryDefine.MODEL_SCREEN_OUT_LINES.Equals(csModelKind) == true)
                {    // 時系列任意入力計算結果モニターグラフ出力
                    csModelDataGenerator = new McLineGraphScreenPrptyGenerator();
                    csModelDataGenerator.SetID(csModelID);
                    ((McLineGraphScreenPrptyGenerator)csModelDataGenerator).SetModKind(csModelKind);
                }
                else if (McModelLibraryDefine.MODEL_SCREEN_OUT_HYETO_HYDRO.Equals(csModelKind) == true)
                {   // 時系列ハイエト／ハイドロ入力計算結果モニターグラフ出力
                    csModelDataGenerator = new McLineGraphScreenPrptyGenerator();
                    csModelDataGenerator.SetID(csModelID);
                    ((McLineGraphScreenPrptyGenerator)csModelDataGenerator).SetModKind(csModelKind);
                }
                else if (McModelLibraryDefine.MODEL_SCREEN_OUT_REVERBED.Equals(csModelKind) == true)
                {   // １次元配列縦断データ入力計算結果モニターグラフ出力
                    csModelDataGenerator = new McLineGraphScreenPrptyGenerator();
                    csModelDataGenerator.SetID(csModelID);
                    ((McLineGraphScreenPrptyGenerator)csModelDataGenerator).SetModKind(csModelKind);
                }
                // コードを一つに纏めることも可能であるが、本ソースはサンプルである為、冗長でも分かりやすいコーディングにしてある
            }
            return csModelDataGenerator;
        }
    }
}
