﻿// <summary>ソースコード：ＨＹＭＣＯ演算モデル用データ作成クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.CoreImpl.HSGIS;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;

using CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper;
// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{
    /// <summary><para>class outline:</para>
    /// <para>McSampleKinematicWave用演算モデル用パラメータ等情報生成クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McSampleKinematicWavePrptyGenerator : McModelParameterGeneratorBase
    {
// ★★★★★★★★★★★★★★★★★★★★★★★★     
//  個別のモデル毎の　プロパティ情報／初期化情報等を作成し　
//  プロパティ用構造定義ファイル／初期化情報用構造定義ファイルへ書き出す。
//  ＸＭＬ化処理は、 HySXmlNode等の クラスが行うので、
//  本クラスは、　HySXmlNode クラスへ情報を積み込めばよい
// ★★★★★★★★★★★★★★★★★★★★★★★★

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateModelData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csPropertyInfoParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csPropertyInfoParent">親XMLノードクラス（プロパティ情報用）</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義プロパティファイルへ情報を設定する
        /// </para>
        /// </remarks>
        protected override bool CreateModelPropertyDetailData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csPropertyInfoParent,
                    ref HySXmlWriter csXmlWriter)
        {
            bool bRtn = false;
            McModelDataGenerationInfo csMdlDataInfo = csMDGInfo as McModelDataGenerationInfo;
            if (csMdlDataInfo != null)
            {

                // ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                // 此処からサンプルコーディング

                CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McSampleModelFactory csFct = new CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McSampleModelFactory();
                McCellModelPropertyInfo csPrpty = csFct.CreateModelProperty(
                    CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.SAMPLE_MODEL_LIB,
                    CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.KINEMATIC_WAVE_KIND) as McCellModelPropertyInfo;

                // ------------------------
                // ①　プロパティ情報の設定
                // ------------------------
                HySID csElmID = (HySID)this.GetID();
                {
                    // IDに応じて、何処に配置された要素かがわかるのでそれに応じてパラメータを設定する
                }


                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
                // ↓↓↓　此処からが,画面等で設定された情報を取得するコーディング例です　↓↓↓
                // 使用する各種データファイルの取得方法
                //例：その１、落水線データファイルを取得する場合（共通GIS情報）
                HySString csFileName = new HySString("");
                csMdlDataInfo.GetInfo(HySGISDataKindDefine.KIND_GIS_DRAINAGE_DIRECTION_MATRIX, ref csFileName);
                //csFileName 内に　落水線情報を格納したファイル名（フルパス）が入っている。
                //例：その２、流量配分データ を取得したい場合（共通手入力情報I
                csMdlDataInfo.GetInfo(CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB.McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_1, ref csFileName);
                //csFileName 内に　流量配分データを格納したファイル名（フルパス）が入っている。
                //例：その３、独自データの場合
                csMdlDataInfo.GetInfo(SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND, ref csFileName);
                //csFileName 内に　独自の情報を格納したファイル名（フルパス）が入っている。
                // ↑↑↑↑　此処まで,画面等で設定された情報を取得するコーディング例です　↑↑↑

                // 上記で取得した情報を元に、
                // csPrptyに　各値を設定して下さい
                // に設定して下さい。
                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

                // ------------------------
                // ②　XML書き出し
                // ------------------------
                HySXmlNode csNode = csPrpty.XmlOUT(ref csXmlWriter);

                // 親ＸＭＬに追加する
                csPropertyInfoParent.AppendChild(csNode);
                bRtn = true;

                // 此処からサンプルコーディング
                // ↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

                bRtn = true;
            }
            return bRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>初期化情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn  = CreateInitialData(
        ///                       ref csMDGInfo,
        ///                       ref  HySXmlNode csInitialInfoParent,
        ///                       ref csXmlWriter)
        /// </para>
        /// </example>
        /// <param name="csMDGInfo">モデルプデータジェネレーター作成条件</param>
        /// <param name="csInitialInfoParent">親XMLノードクラス（初期化情報）</param>
        /// <param name="csXmlWriter">XMLファイル書き出しクラス</param>
        /// <returns>bool true:正常　、false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>
        /// 引数で要求されたシミュレーション用情報から構造定義初期化情報を設定する
        /// </para>
        /// </remarks>
        protected override bool CreateInitialDetailData(
                    ref McModelDataGenerationInfoIF csMDGInfo,
                    ref  HySXmlNode csInitialInfoParent,
                    ref HySXmlWriter csXmlWriter)
        {
            bool bRtn = false;
            McModelDataGenerationInfo csMdlDataInfo = csMDGInfo as McModelDataGenerationInfo;
            if (csMdlDataInfo != null)
            {

                // ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
                // 此処からサンプルコーディング
                CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McSampleModelFactory csFct = new CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McSampleModelFactory();
                McInitialInfo csInit = csFct.CreateModelInitialInfo(
                    CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.SAMPLE_MODEL_LIB,
                    CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McModelSampleDefine.KINEMATIC_WAVE_KIND) as McInitialInfo;
                // ------------------------
                // ①　初期化情報の設定
                // ------------------------
                HySID csElmID = (HySID)this.GetID();
                {
                    // IDに応じて、何処に配置された要素かがわかるのでそれに応じてパラメータを設定する
                }

                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
                // ↓↓↓　此処からが,画面等で設定された情報を取得するコーディング例です　↓↓↓
                // 使用する各種データファイルの取得方法
                //例：その１、落水線データファイルを取得する場合（共通GIS情報）
                HySString csFileName = new HySString("");
                csMdlDataInfo.GetInfo(HySGISDataKindDefine.KIND_GIS_DRAINAGE_DIRECTION_MATRIX, ref csFileName);
                //csFileName 内に　落水線情報を格納したファイル名（フルパス）が入っている。
                //例：その２、流量配分データ を取得したい場合（共通手入力情報I
                csMdlDataInfo.GetInfo(CommonMP.HYMCO.CoreOptions.McViewer.MdlGenScreenCommonLIB.McMdlGenCommonScreenDefine.MODEL_GENERATOR_DATA_KIND_1, ref csFileName);
                //csFileName 内に　流量配分データを格納したファイル名（フルパス）が入っている。
                //例：その３、独自データの場合
                csMdlDataInfo.GetInfo(SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND, ref csFileName);
                //csFileName 内に　独自の情報を格納したファイル名（フルパス）が入っている。
                // ↑↑↑↑　此処まで,画面等で設定された情報を取得するコーディング例です　↑↑↑

                // 上記で取得した情報を元に、
                // csInitに　各値を設定して下さい
                // に設定して下さい。
                // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★

                // ------------------------
                // ②　XML書き出し
                // ------------------------
                HySXmlNode csNode = csInit.XmlOUT(ref csXmlWriter);

                // 親ＸＭＬに追加する
                csInitialInfoParent.AppendChild(csNode);

                // 此処からサンプルコーディング
                // ↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

                bRtn = true;
            }
            return bRtn;
        }
    }
}
