﻿// <summary>ソースコード：モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class SampleMdlGenDefine
    {
 
        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        // ToDo モデルファクトリＩＤを定義してください。
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = new HySID("HYMCO.Sample.ModelGenarationSampleFactory");


        //********************************
        //===== モデル関連定義 ========
        //********************************
        // ToDo 提供するモデルの種別と名称を定義して下さい。


        /// <summary>モデルジェネレーター説明用）：地点での降雨データ発生モデル種別</summary>
        public static readonly HySObjectKind TEST_RAINFALL_POINT_MODEL = new HySObjectKind("McDebugTest.RainDataGenerator");
        /// <summary>モデルジェネレーター説明用）：地点での降雨データ発生モデル名称</summary>
        public static readonly HySString TEST_RAINFALL_POINT_MODEL_NAME = new HySString("（モデルジェネレーター説明用）：地点でのダミー降雨データ発生モデル");

        /// <summary>モデルジェネレーター説明用）：ダミー流出モデル種別</summary>
        public static readonly HySObjectKind TEST_DMYBASIN_KIND = new HySObjectKind("McDebugTest.DmyBasin");
        /// <summary>モデルジェネレーター説明用）：ダミー流出モデル名称</summary>
        public static readonly HySString TEST_DMYBASIN_NAME = new HySString("（モデルジェネレーター説明用）：ダミー流出モデル");

        /// <summary>モデルジェネレーター説明用）：ダミー分流モデル種別</summary>
        public static readonly HySObjectKind TEST_BRANCH_KIND = new HySObjectKind("McDebugTest.DmyBranch");
        /// <summary>モデルジェネレーター説明用）：ダミー分流モデル名称</summary>
        public static readonly HySString TEST_BRANCH_NAME = new HySString("（モデルジェネレーター説明用）：ダミー分流モデル");


        //********************************
        //===== モデルの伝送パターン定義 ========
        //********************************
        /// <summary>ダミー雨量発生：送信パターンその１</summary>
        public static readonly HySID OUT_RAINFALL = new HySID("RAINFALL");

        /// <summary>ダミー流出モデル：受信パターンその１</summary>
        public static readonly HySID RAINFALL_IN = new HySID("RAINFALL_IN");
        /// <summary>ダミー流出モデル：送信パターンその１</summary>
        public static readonly HySID OUT_WATER_Q = new HySID("QOut");
        
        /// <summary>ダミー分流モデル：受信パターンその１</summary>
        public static readonly HySID IN_WATERQ = new HySID("QIn");
        /// <summary>ダミー分流モデル：送信パターンその１ 分岐側</summary>
        public static readonly HySID SIDE_OUT = new HySID("SIDE_OUT");
        /// <summary>ダミー分流モデル：送信パターンその２ 本流側</summary>
        public static readonly HySID BOTTOM_OUT = new HySID("BOTTOM_OUT");



        //********************************
        //===== モデルジェネレーター関連クラス定義 ========
        //********************************
        /// <summary>モデルジェネレーター種別</summary>
        public static readonly HySObjectKind MODEL_NETWORK_GENERATOR_KIND = new HySObjectKind("SampleModelNetowrkGenerator");
        /// <summary>モデルジェネレーター名称</summary>
        public static readonly HySString MODEL_NETWORK_GENERATOR_NAME = new HySString("サンプル　モデル接続構造作成ツール");

        //********************************
        //===== モデルジェネレーター用のデータを
        //   手入力する場合の画面関連クラス定義 ========
        //********************************
        // -- Sample -- 用の為、自由に定義
        /// <summary>サンプルモデル関連　Ａ情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_A_KIND = new HySObjectKind("SampleModelData_A");
        /// <summary>サンプルモデル関連　Ａ情報名称</summary>
        public static readonly HySString MODEL_GENERATOR_DATA_A_NAME = new HySString("サンプル　Ａ情報");
        ///// <summary>サンプルモデル関連　Ａ情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_A_NAME = new HySString("サンプル　Ａ情報設定画面");


        /// <summary>サンプルモデル関連　Ｂ情報設定画面種別</summary>
        public static readonly HySObjectKind MODEL_GENERATOR_DATA_B_KIND = new HySObjectKind("SampleModelData_B");
        /// <summary>サンプルモデル関連　Ｂ情報名称</summary>
        public static readonly HySString MODEL_GENERATOR_DATA_B_NAME = new HySString("サンプル　Ｂ情報");
        ///// <summary>サンプルモデル関連　Ｂ情報設定画面名称</summary>
        //public static readonly HySString MODEL_GENERATOR_SCREEN_B_NAME = new HySString("サンプル　Ｂ情報設定画面");


        //********************************
        //===== 手入力画面が生成する情報の共通定義 ========
        //********************************
        // -- Sample -- 用の為、自由に定義
        /// <summary>情報：Ａセット　キーワード</summary>
        public static readonly HySString MODEL_SETTING_FILE_A = new HySString("MdlSettingAData");
        /// <summary>情報：Ｂセット　キーワード</summary>
        public static readonly HySString MODEL_SETTING_FILE_B = new HySString("MdlSettingBData");



    }
}
