﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.ModelGeneratorSample.SampleMdlGenFactory();
        }
    }
}


// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class SampleMdlGenFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return SampleMdlGenDefine.MODEL_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL.Equals(csModelKind) == true)
            {
                csCalModel = new DmyRainFallModel();
            }
            else if (SampleMdlGenDefine.TEST_DMYBASIN_KIND.Equals(csModelKind) == true)
            {
                csCalModel = new DmyBasinModel();
            }
            if (csModelKind.Equals(SampleMdlGenDefine.TEST_BRANCH_KIND) == true)
            {
                csCalModel = new DmyBranchModel( );
            }
            // ToDo　引数で与えられた　モデル識別子に従って、演算モデルを返して下さい。（知らない識別子の場合には null を返す）
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL.Equals(csModelKind) == true)
            {
                csCalInfoData = new DmyRainFallCalInfo();
            }
            else if (SampleMdlGenDefine.TEST_DMYBASIN_KIND.Equals(csModelKind) == true)
            {
                csCalInfoData = new DmyBasinCalInfo();
            }
            if (csModelKind.Equals(SampleMdlGenDefine.TEST_BRANCH_KIND) == true)
            {
                csCalInfoData = new DmyBranchCalInfo();
            }
            // ToDo　引数で与えられた　モデル識別子に従って、演算データを返して下さい。（知らない識別子の場合には null を返す）
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;
            if (SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL.Equals(csModelKind) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(60.0 * 60.0); // δT設定
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        new HySID("RAINFALL"),
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "雨量") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "雨量", HySDataCharacteristicInCell.DATA_KIND.SCALOR_RAIN_FALL, "mm/H");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (SampleMdlGenDefine.TEST_DMYBASIN_KIND.Equals(csModelKind) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(60.0 * 60.0); // δT設定

                // パラメータ設定
                csRtnCellPrptyDt.AddInfoType("m_dArea", "流域面積（ｍ2）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dArea", 1000.0 * 1000.0);
                csRtnCellPrptyDt.AddInfoType("m_dCapacitance[0]", "容量係数１（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCapacitance[0]", 100640.0);
                csRtnCellPrptyDt.AddInfoType("m_dCapacitance[1]", "容量係数２（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCapacitance[1]", 200770.0);
                csRtnCellPrptyDt.AddInfoType("m_dCapacitance[2]", "容量係数３（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCapacitance[2]", 718400.0);
                csRtnCellPrptyDt.AddInfoType("m_dCapacitance[3]", "容量係数４（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCapacitance[3]", 51840000.0);
                csRtnCellPrptyDt.AddInfoType("m_dCapacitance[4]", "容量係数５（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCapacitance[4]", 91840000.0);

                csRtnCellPrptyDt.AddInfoType("m_dResistanceIn[0]", "流入抵抗係数１（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceIn[0]", 1.0 / 1000.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceIn[1]", "流入抵抗係数２（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceIn[1]", 1.0 / 400.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceIn[2]", "流入抵抗係数３（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceIn[2]", 1.0 / 150.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceIn[3]", "流入抵抗係数４（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceIn[3]", 1.0 / 20.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceIn[4]", "流入抵抗係数５（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceIn[4]", 1.0 / 15.0);

                csRtnCellPrptyDt.AddInfoType("m_dResistanceOut[0]", "流出抵抗係数１（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceOut[0]", 1.0 / 500.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceOut[1]", "流出抵抗係数２（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceOut[1]", 1.0 / 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceOut[2]", "流出抵抗係数３（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceOut[2]", 1.0 / 50.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceOut[3]", "流出抵抗係数４（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceOut[3]", 1.0 / 10.0);
                csRtnCellPrptyDt.AddInfoType("m_dResistanceOut[4]", "流出抵抗係数５（1/(ｍ3・sec)）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dResistanceOut[4]", 1.0 / 5.0);

                csRtnCellPrptyDt.AddInfoType("m_lDlyTm[0]", "流出遅れ係数１", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDlyTm[0]", 3);
                csRtnCellPrptyDt.AddInfoType("m_lDlyTm[1]", "流出遅れ係数２", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDlyTm[1]", 3);
                csRtnCellPrptyDt.AddInfoType("m_lDlyTm[2]", "流出遅れ係数３", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDlyTm[2]", 5);
                csRtnCellPrptyDt.AddInfoType("m_lDlyTm[3]", "流出遅れ係数４", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDlyTm[3]", 8);
                csRtnCellPrptyDt.AddInfoType("m_lDlyTm[4]", "流出遅れ係数５", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDlyTm[4]", 9);
                
                // 受信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        SampleMdlGenDefine.RAINFALL_IN,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "雨量") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "雨量", HySDataCharacteristicInCell.DATA_KIND.SCALOR_RAIN_FALL, "mm/H");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        SampleMdlGenDefine.OUT_WATER_Q,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "流量") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (SampleMdlGenDefine.TEST_BRANCH_KIND.Equals(csModelKind) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(60.0 * 60.0); // δT設定
                
                csRtnCellPrptyDt.AddInfoType("m_dBranchRatio", "分岐率（0.0～1.0）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dBranchRatio", 0.3);
                // 受信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        SampleMdlGenDefine.IN_WATERQ,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "流入流量") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        SampleMdlGenDefine.BOTTOM_OUT,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "本流出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        SampleMdlGenDefine.SIDE_OUT,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "分流出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            // ToDo　引数で与えられた　モデル識別子に従って、プロパティ表示／設定データを生成し、モデル固有設定デフォルト値を設定して返して下さい。
            //else if( csModelKind.Equals(    
            else
            {
                // Do Noghing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;
            if (SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL.Equals(csModelKind) == true )
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                // パラメーター設定
                csRtnDt.AddInfoType("m_dMax", "最高雨量制限係数(短期)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dMax", 9.0);
                csRtnDt.AddInfoType("m_dMaxLg", "最高雨量制限係数(長期)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dMaxLg", 4.0);
            }
            else if (SampleMdlGenDefine.TEST_DMYBASIN_KIND.Equals(csModelKind)==true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                csRtnDt.AddInfoType("m_dQ[0]", "初期蓄積係数１（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dQ[0]", 10640.0);
                csRtnDt.AddInfoType("m_dQ[1]", "初期蓄積係数２（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dQ[1]", 20770.0);
                csRtnDt.AddInfoType("m_dQ[2]", "初期蓄積係数３（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dQ[2]", 518400.0);
                csRtnDt.AddInfoType("m_dQ[3]", "初期蓄積係数４（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dQ[3]", 49840000.0);
                csRtnDt.AddInfoType("m_dQ[4]", "初期蓄積係数５（ｍ3）", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dQ[4]", 91840000.0);
            }
            if (csModelKind.Equals(SampleMdlGenDefine.TEST_BRANCH_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            // ToDo　引数で与えられた　モデル識別子に従って、初期情報データを生成し、モデル固有設定デフォルト値を設定して返して下さい。
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                     McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE,
                    SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL,
                    SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL_NAME);
            csModelInfo.SetVersionInf("（モデルジェネレーター説明用）：地点での降雨データ発生モデル");
            csModelInfo.SetSummaryInf("テスト用に（地点）雨量データを発生さます。単なる数値を弄っているだけなので物理的妥当性はありません。モデル自動生成ツール開発者用のサンプルで使用します。");
            csModelInfo.SetCreatorInf("モデル自動生成ツール（モデルジェネレーター）開発者");
            csModelInfo.SetIconName("DefaultModel");
            csModelInfo.SetManualFileName(".\\Sample\\ModelGeneratorMdlSample.pdf");
            m_csCalModelInforList.AddLast(csModelInfo);


            csModelInfo = new McModelInfo(
                     (HySID)this.GetFactoryID(),
                     McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                     McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE,
                     SampleMdlGenDefine.TEST_DMYBASIN_KIND, // モデルの識別子
                     SampleMdlGenDefine.TEST_DMYBASIN_NAME  // モデルの名称
              );
            csModelInfo.SetVersionInf("（モデルジェネレーター説明用）：ダミー流出モデル");
            csModelInfo.SetSummaryInf("単なる数値を弄っているだけなので物理的妥当性はありません。モデル自動生成ツール開発者用のサンプルで使用します。");
            csModelInfo.SetCreatorInf("モデル自動生成ツール（モデルジェネレーター）開発者");
            csModelInfo.SetIconName("Basin");
            csModelInfo.SetManualFileName(".\\Sample\\ModelGeneratorMdlSample.pdf");
            m_csCalModelInforList.AddLast(csModelInfo);

            csModelInfo = new McModelInfo(
                     (HySID)this.GetFactoryID(),
                     McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                     McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_MODEL_SAMPLE,
                     SampleMdlGenDefine.TEST_BRANCH_KIND, // モデルの識別子
                     SampleMdlGenDefine.TEST_BRANCH_NAME  // モデルの名称
              );
            csModelInfo.SetVersionInf("（モデルジェネレーター説明用）：ダミー分岐モデル");
            csModelInfo.SetSummaryInf("単なる数値を弄っているだけなので物理的妥当性はありません。モデル自動生成ツール開発者用のサンプルで使用します。");
            csModelInfo.SetCreatorInf("モデル自動生成ツール（モデルジェネレーター）開発者");
            csModelInfo.SetIconName("DefaultModel");
            csModelInfo.SetManualFileName(".\\Sample\\ModelGeneratorMdlSample.pdf");
            m_csCalModelInforList.AddLast(csModelInfo);

            // To Do 新しく作成したモデル情報を作成し、リンクリスト（m_csCalModelInforList）に追加（AddLast）して下さい

            return m_csCalModelInforList;
        }

        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ================= start of モデルデータ半自動作成ツール用メソッド ============================
        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelNetworkGeneratorList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルネットワーク生成クラス情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルネットワーク生成クラス情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetModelNetworkGeneratorList()
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();
            
            McModelInfo csModelInfo = null;

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                SampleMdlGenDefine.MODEL_NETWORK_GENERATOR_KIND, 
                SampleMdlGenDefine.MODEL_NETWORK_GENERATOR_NAME);

            csModelInfo.SetVersionInf("Ver X ");
            csModelInfo.SetSummaryInf("モデル自動生成ツールを製作する開発者の為のサンプルです。使用方法のみをコーディングしているため、生成されるモデルの物理的妥当性はありません。");
            csModelInfo.SetCreatorInf("モデル自動生成ツール（モデルジェネレーター）開発者");

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            return csRtnList;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算要素モデルネットワーク生成クラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelNetworkGenerator csMdlNetworkGen = CreateModelNetworkGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelNetworkGenerator 演算要素モデルネットワーク生成クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelNetworkGenerator CreateModelNetworkGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            McModelNetworkGenerator csNetworkGenerator = null;

            if (csModelKind.Equals(SampleMdlGenDefine.MODEL_NETWORK_GENERATOR_KIND) == true)
            {
                csNetworkGenerator = new CommonMP.HYMCO.OptionImpl.ModelGeneratorSample.SampleModelNetworkGenerator();
                csNetworkGenerator.SetID(csModelID);
            }
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }

            return csNetworkGenerator;
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデル用パラメータ情報半自動生成クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelParameterGenerator csParaGen = CreateModelParameterGenerator(csLibraryID, csModelKind, csModelID) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <param name="csModelID">モデルID</param>
        /// <returns>McModelParameterGenerator 演算モデル用パラメータ等情報生成</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelParameterGenerator CreateModelParameterGenerator(HySID csLibraryID, HySObjectKind csModelKind, HySID csModelID)
        {
            McModelParameterGenerator csModelDataGenerator = null;

            if (SampleMdlGenDefine.TEST_DMYBASIN_KIND.Equals(csModelKind) == true)
            {
                csModelDataGenerator = new CommonMP.HYMCO.OptionImpl.ModelGeneratorSample.DmyBasinDataGenerator();
                csModelDataGenerator.SetID(csModelID);
            }
            else if (SampleMdlGenDefine.TEST_RAINFALL_POINT_MODEL.Equals(csModelKind) == true)
            {
                csModelDataGenerator = new CommonMP.HYMCO.OptionImpl.ModelGeneratorSample.DmyRainFallDataGenerator();
                csModelDataGenerator.SetID(csModelID);
            }
            else if (SampleMdlGenDefine.TEST_BRANCH_KIND.Equals(csModelKind) == true)
            {
                csModelDataGenerator = new CommonMP.HYMCO.OptionImpl.ModelGeneratorSample.DmyBranchDataGenerator();
                csModelDataGenerator.SetID(csModelID);
            }
            // ToDo　引数で与えられた　モデル識別子に従って、演算モデルを返して下さい。（知らない識別子の場合には null を返す）
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }

            return csModelDataGenerator;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデルジェネレータが必要とする独自データのリスト情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorNeedDataList(csLibraryID, csModelKind )</para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルジェネレータが必要とするデータのリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデルジェネレータが必要とするデータ(McMdlGenNeedData)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetModelGeneratorNeedDataList(HySID csLibraryID, HySObjectKind csModelKind)
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();

            McMdlGenNeedData csNeedData = new McMdlGenNeedData(SampleMdlGenDefine.MODEL_FACTORY_LIB_ID, SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND, SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_NAME);
            csRtnList.AddLast(csNeedData);
            csNeedData = new McMdlGenNeedData(SampleMdlGenDefine.MODEL_FACTORY_LIB_ID, SampleMdlGenDefine.MODEL_GENERATOR_DATA_B_KIND, SampleMdlGenDefine.MODEL_GENERATOR_DATA_B_NAME);
            csRtnList.AddLast(csNeedData);


            return csRtnList;
        }

        // ================= end  of モデルデータ半自動作成ツール用メソッド ============================
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
    }
}
