// <summary>ソースコード：モデル用プロパティスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;


// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{
    public partial class SampleMdlGenSetFormAInf : McDotNetModelDataGeneratorFormBase //Form
    {
        /// <summary>定義ファイルパス</summary>
        private static HySString DEF_PATH = new HySString("\\temp\\ModelGenerator");

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McMdlGenInfSettingForm()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        public SampleMdlGenSetFormAInf()
        {
            InitializeComponent();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定ボタン</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>OKButton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void OKButton_Click(object sender, EventArgs e)
        {
            // ①
            // McModelDataGenerationInfo　m_csMDGInfo に対して設定情報を格納する。
            // ↓↓↓↓↓↓↓↓↓↓↓↓↓↓↓
            // コーディング例：

            // 生成情報書き出しファイル
            HySString csParaAFileName = HySEnvInf.GetHomeDirectory() + HySEnvInf.GetEnvInf("GIS_MODEL_DATA_GENERATION_DIRECTORY") + new HySString("DataA.csv");
                    HySFile csParaAFile = new HySFile(csParaAFileName);
                    csParaAFile.Open(HySFile.OPEN_MODE.CREATE, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
                    csParaAFile.WriteText("DmyData");
                    csParaAFile.Close();

            // パラメーター設定
            McModelDataGenerationInfo csMDGInfo = this.GetMdlGenerationInfo();
            csMDGInfo.SetInfo(SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND, csParaAFileName);

            // コーディング例：
            // ↑↑↑↑↑↑↑↑↑↑↑↑↑↑↑

            // ②
            // 制御画面側に　設定完了を通知する
            this.NoticeModelDataSet();
            //this.GetCtlScreen();
            this.Close();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>キャンセルボタン</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>NGButton_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void NGButton_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        /// <summary>
        /// <para>method outline:</para>
        /// <para>設定テキストボックスクリック</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>WriteFiletextBox_Click( sender, e )</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void WriteFiletextBox_Click(object sender, EventArgs e)
        {
            SaveFileDialog saveFileDialog1 = new SaveFileDialog();

            HySString csFullPath = HySEnvInf.GetHomeDirectory() + DEF_PATH;
            saveFileDialog1.InitialDirectory = csFullPath.ToString();
            saveFileDialog1.Filter = "XML CSVファイル(*.xml *.csv)|*.xml;*.csv|すべてのファイル(*.*)|*.*";
            saveFileDialog1.FilterIndex = 1;
            saveFileDialog1.RestoreDirectory = true;

            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                this.WriteFiletextBox.Text = saveFileDialog1.FileName;
            }
            saveFileDialog1.Dispose();
        }

    }
}