﻿// <summary>ソースコード：モデル用プロパティスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_SCREEN_FACTORY_CREATOR_IMPLE : PROPERTY_SCREEN_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_SCREEN_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_SCREEN_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_SCREEN_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルプロパティスクリーンファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyScreenFactoryBase CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.ModelGeneratorSample.SampleMdlGenScreenFactory();
        }
    }
}


// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.ModelGeneratorSample
{  
    /// <summary><para>class outline:</para>
    /// <para>モデル用プロパティスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/25][新規作成]</para>
    /// </remarks>
    public class SampleMdlGenScreenFactory : McPropertyScreenFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Init(HySFactoryMng csFactoryMng)
        {
            // ファクトリ管理クラス取得
            m_csFactoryMng = (HySFactoryManager)csFactoryMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // To Do モデル作成側ファクトリクラスと同じ値にして下さい
            return SampleMdlGenDefine.MODEL_FACTORY_LIB_ID;
        }

 
        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen = CreatePropertyScreen( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelPropertyScreen モデルプロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelPropertyScreen CreatePropertyScreen(HySKind csModelKind)
        {
            McModelPropertyScreen csScreen = null;

            if (SampleMdlGenDefine.TEST_BRANCH_KIND.Equals(csModelKind) == true)
            {   // ダミー分岐モデルならば
                csScreen = new DmyBranchModelPropertyScreen();
            }  
            else
            {   // DoNothing
            }
            return csScreen;
        }


        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
        // ================= start of モデルデータ半自動作成ツール用メソッド ============================
        // モデルデータ半自動作成ツール（モデルジェネレーター）を作成する開発者は下記メソッド群を
        // オーバーライド実装して下さい。


        /// <summary>
        /// <para>method outline:</para>
        /// <para>演算要素モデルジェネレーター固有画面情報リスト提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetModelGeneratorScreenList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算要素モデルジェネレーター固有画面情報リスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>演算要素モデルジェネレーター固有画面情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetModelGeneratorScreenList()
        {
            HySDataLinkedList csRtnList = new HySDataLinkedList();

            McModelInfo csModelInfo = null;

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND,
                SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_NAME);

            csModelInfo.SetVersionInf("Ver X ");
            csModelInfo.SetSummaryInf("モデルジェネレーションサンプル用モデル生成の為の情報Ａを設定する画面クラス");
            csModelInfo.SetCreatorInf("モデルジェネレーションサンプル開発者");

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                new HySObjectKind(""),  // <-- ダミー値
                SampleMdlGenDefine.MODEL_GENERATOR_DATA_B_KIND,
                SampleMdlGenDefine.MODEL_GENERATOR_DATA_B_NAME);

            csModelInfo.SetVersionInf("Ver X ");
            csModelInfo.SetSummaryInf("モデルジェネレーションサンプル用モデル生成の為の情報Ｂを設定する画面クラス");
            csModelInfo.SetCreatorInf("モデルジェネレーションサンプル開発者");

            csRtnList.AddLast(csModelInfo); // 演算要素モデルネットワーク生成クラス情報の追加

            return csRtnList;
        }
        /// <summary><para>method outline:</para>
        /// <para>個別モデル用設定スクリーンクラスの生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelDataGeneratorScreen csMdlGen = CreateModelDataGeneratorScreen(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelDataGeneratorScreen 個別モデル用設定スクリーン</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelDataGeneratorScreen CreateModelDataGeneratorScreen(HySKind csModelKind)
        {
            McModelDataGeneratorScreen csScreen = null;
            if (SampleMdlGenDefine.MODEL_GENERATOR_DATA_A_KIND.Equals(csModelKind) == true)
            {
                csScreen = new SampleMdlGenSetScreenAInf();
            }
            else if (SampleMdlGenDefine.MODEL_GENERATOR_DATA_B_KIND.Equals(csModelKind) == true)
            {
                csScreen = new SampleMdlGenSetScreenBInf();
            }
            else
            {
                // Do Nothing
            }
            return csScreen;
        }

        // ================= end  of モデルデータ半自動作成ツール用メソッド ============================
        // ★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★★
    }
}
