﻿// <summary>ソースコード：テストCSVファイル入力データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>テストCSVファイル入力データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McTestINFileInfo : McCalInfo
    {
        /// <summary> 出力数 </summary>
        public long m_lOutPutPortNum = 0;
        /// <summary> データを出力した演算時刻 </summary>
        public HySTime[] m_csLastDataOutTime = null;

        /// <summary>１レコード内のデータ数 </summary>
        public long m_lDataNum = 1;

        /// <summary> 読み出したデータ保管場所 </summary>
        public HySCSVFileData m_csReadCSVData = null;

        /// <summary>出力がシングルセルデータ（McTimeSeriesSingleCellTranInfo）の時に出力するデータ系列番号：０相対
        ///  （読み込みデータの何番目の系列を出すか？） 
        ///</summary>
        public long m_lOutDataIdx = 0;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McTestINFileInfo csRtn = new McTestINFileInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McTestINFileInfo csOrgDt = (McTestINFileInfo)csOrgInfo;

            this.m_lOutPutPortNum = csOrgDt.m_lOutPutPortNum;
            for (long lLp = 0; lLp < m_lOutPutPortNum; lLp++)
            {
                this.m_csLastDataOutTime[lLp] = csOrgDt.m_csLastDataOutTime[lLp].Clone();
            }

            this.m_lDataNum = csOrgDt.m_lDataNum;
            if (csOrgDt.m_csReadCSVData != null)
            {
                this.m_csReadCSVData = (HySCSVFileData)HySDataDuplicate.DupliCateData(csOrgDt.m_csReadCSVData);
            }
            this.m_lOutDataIdx = csOrgDt.m_lOutDataIdx;

            return true;
        }

    }
}
