﻿// <summary>ソースコード：ＨＹＭＣＯサンプルモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McSampleModelFactory();
        }
    }
}

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{
    /// <summary><para>class outline:</para>
    /// <para>サンプルモデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class McSampleModelFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSampleModelFactory csFactory = new McSampleModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McSampleModelFactory( )
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return McModelSampleDefine.SAMPLE_MODEL_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {
                //csCalModel = new McPrimitiveKinematicWave();
                csCalModel = new McSampleKinematicWave();
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {
                csCalModel = new McTestBasin();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {
                csCalModel = new McTestOutFileModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {
                csCalModel = new McTestINFileModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {
                csCalModel = new McTestReadD2CSVFileModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND)
            {   //３次元時系列ＣＳＶファイル出力ならば
                csCalModel = new McTestOutD3CSVFileModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_D3CSV_FILE_IN_KIND)
            {   //３次元時系列ＣＳＶファイル入力ならば
                csCalModel = new McTestReadD3CSVFileModel();
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csCalModel = new SampleCodeModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csCalModel = new TranInfoInOutSampleModel();
            }
            else if (csModelKind == McModelSampleDefine.TEST_GIS_OUT_TESTMODEL_KIND)
            {
                csCalModel = new McGISTest2DMeshDataGenerateModel();
            }
            else
            {
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {
                //csCalInfoData = new McPrimitiveKinematicWaveCalInfo();
                csCalInfoData = new McSampleKinematicWaveCalInfo();
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {
                csCalInfoData = new McTestBasinCalInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {
                csCalInfoData = new McTestOutFileInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {
                csCalInfoData = new McTestINFileInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {
                csCalInfoData = new McTestReadD2CSVFileInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND)
            {   //３次元時系列ＣＳＶファイル出力ならば
                csCalInfoData = new McTestOutD3CSVFileInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_D3CSV_FILE_IN_KIND)
            {   //３次元時系列ＣＳＶファイル入力ならば
                csCalInfoData = new McTestReadD3CSVFileInfo();
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csCalInfoData = new SampleCodelCalInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csCalInfoData = new TranInfoInOutSampleCalInfo();
            }
            else if (csModelKind == McModelSampleDefine.TEST_GIS_OUT_TESTMODEL_KIND)
            {
                csCalInfoData = new McGISTest2DMeshDataGenerateInfo();
            }
            else
            {
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {   // サンプル河道（KinematicWabe)モデル
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime((double)48 * 3600 / 2400); // δT設定

                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", "モデル内セル分割数+1", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 51);
                csRtnCellPrptyDt.AddInfoType("m_dRough", "粗度", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dRough", 0.03);
                csRtnCellPrptyDt.AddInfoType("m_dSlope", "河床勾配", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dSlope", 1.0 / 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dLength", "河道長", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dLength", 100000.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);

                csRtnCellPrptyDt.AddInfoType("m_inLQ", "横流入させる分割セル番号(0相対）上流から", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_inLQ", 20);

                // 受信可能なパターン
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_PATTERN_TOP,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "上流端流入") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_PATTERN_LATERAL,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "支流からの横流入") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // 最初の変数は流量
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.OUT_PATTERN_ALL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "セル全体出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {   // テスト用流量発生クラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(72); // δT設定 秒

                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQb", "流量ｂ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQb", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQp", "流量ｐ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQp", 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dCp", "ｃ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dCp", 10.0);

                //csRtnCellPrptyDt.AddInfoType("OutDataKindNum", "出力データの種別数", McDefine.ValKind.LONG);
                //csRtnCellPrptyDt.SetInfo("OutDataKindNum", 1);
                //csRtnCellPrptyDt.AddInfoType("OutDataKind", "出力データ種別", McDefine.ValKind.STRING);
                //csRtnCellPrptyDt.SetInfo("OutDataKind", "流量：ｍ３／ｓｅｃ");

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.OUT_PATTERN_BOTTOM,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "下流端流出") as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {   // テスト用ＣＳＶファイル出力データクラス

                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                csRtnCellPrptyDt.AddInfoType("m_csOutFileNameWithPath", "出力ファイル名（パス付き）", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csOutFileNameWithPath", "");//"..\\temp\\TestFileOut.csv");

                // 受信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "任意入力") as McTranInfoPattern;
                    {

                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意入力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_ONE,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "任意入力") as McTranInfoPattern;
                    {

                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意入力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 第３パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_D2,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        "任意入力") as McTranInfoPattern;
                    {

                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意入力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // CommonMPVer1.0 で作成したプロジェクトファイルの互換性を保つため　Ver1.1で追加
                csRtnCellPrptyDt.AddInfoType("sVer", "バージョン情報", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("sVer", "1.1");
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {   // テスト用ＣＳＶファイル入力データクラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", "入力ファイル名（パス付き）", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "");//"..\\ModelData\\Sample\\TestFileIn.csv");
                csRtnCellPrptyDt.AddInfoType("m_lSeriesNum", "入力ﾃﾞｰﾀ系列数(時刻部は除く) ある時刻に複数の情報がある場合に設定が必要", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lSeriesNum", 1);
                csRtnCellPrptyDt.AddInfoType("m_lOutDataIdx", "出力系列番号(0相対) ある時刻に複数の情報がありかつ、ﾎﾟｲﾝﾄ時系列伝送ﾃﾞｰﾀに出力する時必要", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lOutDataIdx", 0);
                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_ONE,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        "任意出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意出力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 第２パターン
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        "任意出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意出力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
                // CommonMPVer1.0 で作成したプロジェクトファイルの互換性を保つため　Ver1.1で追加
                csRtnCellPrptyDt.AddInfoType("sVer", "バージョン情報", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("sVer", "1.1");
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {   // テスト用２次元時系列ＣＳＶファイル入力データクラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", "入力ファイル名（パス付き）", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "..\\ModelData\\Sample\\TestDim2FileIn.csv");
                csRtnCellPrptyDt.AddInfoType("m_lDim1", "入力データの配列１", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim1", 16);
                csRtnCellPrptyDt.AddInfoType("m_lDim2", "入力データの配列２", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim2", 16);
                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_D2,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        "任意出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意出力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
                // CommonMPVer1.0 で作成したプロジェクトファイルの互換性を保つため　Ver1.1で追加
                csRtnCellPrptyDt.AddInfoType("sVer", "バージョン情報", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("sVer", "1.1");
            }
            else if (csModelKind == McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND)
            {   // テスト用３次元時系列ＣＳＶファイル出力データクラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                csRtnCellPrptyDt.AddInfoType("m_csOutFileNameWithPath", "出力ファイル名（パス付き）", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csOutFileNameWithPath", "");// "..\\temp\\TestFileOutD3.csv");

                // 受信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_D3,
                        McTranInfoDefine.D3_CELL_SERIAL,
                        "任意入力") as McTranInfoPattern;
                    {

                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意入力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // CommonMPVer1.0 で作成したプロジェクトファイルの互換性を保つため　Ver1.1で追加
                csRtnCellPrptyDt.AddInfoType("sVer", "バージョン情報", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("sVer", "1.1");
            }
            else if (csModelKind == McModelSampleDefine.TEST_D3CSV_FILE_IN_KIND)
            {   // テスト用３次元時系列ＣＳＶファイル入力データクラス
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.AddInfoType("m_csInFileNameWithPath", "入力ファイル名（パス付き）", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("m_csInFileNameWithPath", "..\\ModelData\\Sample\\TestDim3FileIn.csv");
                csRtnCellPrptyDt.AddInfoType("m_lDim1", "入力データの配列１", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim1", 4);
                csRtnCellPrptyDt.AddInfoType("m_lDim2", "入力データの配列２", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim2", 2);
                csRtnCellPrptyDt.AddInfoType("m_lDim3", "入力データの配列３", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lDim3", 2);
                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                // 送信パターンの設定
                {
                    // 第１パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McModelSampleDefine.IN_OUT_PATTERN_ANY_D3,
                        McTranInfoDefine.D3_CELL_SERIAL,
                        "任意出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, "任意出力", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "任意");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
                // CommonMPVer1.0 で作成したプロジェクトファイルの互換性を保つため　Ver1.1で追加
                csRtnCellPrptyDt.AddInfoType("sVer", "バージョン情報", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("sVer", "1.1");
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csRtnCellPrptyDt = new SampleCodePropertyData(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)90); // δT設定 90秒
                // 受信パターンの設定
                {
                    // 受信パターンその１
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("LineIN"), McTranInfoDefine.D1_CELL_SERIAL, "１次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.GET_NEXT_DATA); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("AreaIN"), McTranInfoDefine.D2_CELL_SERIAL, "２次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "雨量", HySDataCharacteristicInCell.DATA_KIND.SCALOR_RAIN_FALL, "mm/Hour");      // Index0 には、雨量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                {
                    // 送信パターンその１
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("LineOut"), McTranInfoDefine.D1_CELL_SERIAL, "１次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(5); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速（縦断方向)", HySDataCharacteristicInCell.DATA_KIND.VECTOR_L_VELOCITY, "m/sec");         // Index2 には、流速が入る
                            csCellChara.SetDataKind(3, "流速（横断方向)", HySDataCharacteristicInCell.DATA_KIND.VECTOR_W_VELOCITY, "m/sec");         // Index3 には、流速が入る
                            csCellChara.SetDataKind(4, "流速（深さ方向)", HySDataCharacteristicInCell.DATA_KIND.VECTOR_D_VELOCITY, "m/sec");         // Index4 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("AreaOut"), McTranInfoDefine.D2_CELL_SERIAL, "２次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "雨量", HySDataCharacteristicInCell.DATA_KIND.SCALOR_RAIN_FALL, "mm/Hour");                 // Index0 には、雨量が入る
                            csCellChara.SetDataKind(1, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index1 には、流量が入る
                            csCellChara.SetDataKind(2, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index2 には、水位が入る
                            csCellChara.SetDataKind(3, "流速（縦断方向)", HySDataCharacteristicInCell.DATA_KIND.VECTOR_L_VELOCITY, "m/sec");         // Index3 には、流速が入る
                            csCellChara.SetDataKind(4, "流速（横断方向)", HySDataCharacteristicInCell.DATA_KIND.VECTOR_W_VELOCITY, "m/sec");         // Index4 には、流速が入る
                            csCellChara.SetDataKind(5, "流速（深さ方向)", HySDataCharacteristicInCell.DATA_KIND.VECTOR_D_VELOCITY, "m/sec");         // Index5 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその３
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("Rain"), McTranInfoDefine.D2_CELL_SERIAL, "雨量のみ出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "雨量", HySDataCharacteristicInCell.DATA_KIND.SCALOR_RAIN_FALL, "mm/Hour");                 // Index0 には、雨量が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその４
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("Rain"), McTranInfoDefine.D2_CELL_SERIAL, "水位のみ出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index2 には、水位が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)60); // δT設定 60秒

                // 受信パターンの設定
                {
                    // 受信パターンその０
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("SINGLE_CELL_SERIAL_IN"), McTranInfoDefine.SINGLE_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:０次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_SERIAL_IN"), McTranInfoDefine.D1_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:１次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_SERIAL_IN"), McTranInfoDefine.D2_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:２次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその３
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_SERIAL_IN"), McTranInfoDefine.D3_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:３次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその４－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_SERIAL_IN"), McTranInfoDefine.D1_GIS_SERIAL, "ﾊﾟﾀｰﾝ例:ＧＩＳ＿1次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその４
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_SERIAL_IN"), McTranInfoDefine.D2_GIS_MESH_SERIAL, "ﾊﾟﾀｰﾝ例:ＧＩＳ＿２次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその５
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_SERIAL_IN"), McTranInfoDefine.D3_GIS_MESH_SERIAL, "ﾊﾟﾀｰﾝ例:ＧＩＳ＿３次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    //　非時系列
                    
                    // 受信パターンその６
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_IN"), McTranInfoDefine.D1_CELL, "ﾊﾟﾀｰﾝ例:非時系列１次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその７
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_IN"), McTranInfoDefine.D2_CELL, "ﾊﾟﾀｰﾝ例:非時系列２次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその８
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_IN"), McTranInfoDefine.D3_CELL, "ﾊﾟﾀｰﾝ例:非時系列３次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその９－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_IN"), McTranInfoDefine.D1_GIS, "ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿1次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその９
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_IN"), McTranInfoDefine.D2_GIS_MESH, "ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿２次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // 受信パターンその１０
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_IN"), McTranInfoDefine.D3_GIS_MESH, "ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿３次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                }
                // 送信パターンの設定
                {
                    // 送信パターンその０
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("SINGLE_CELL_SERIAL_Out"), McTranInfoDefine.SINGLE_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:０次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_SERIAL_Out"), McTranInfoDefine.D1_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:１次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその２
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_SERIAL_Out"), McTranInfoDefine.D2_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:２次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその３
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_SERIAL_Out"), McTranInfoDefine.D3_CELL_SERIAL, "ﾊﾟﾀｰﾝ例:３次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその４－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_SERIAL_Out"), McTranInfoDefine.D1_GIS_SERIAL, "ﾊﾟﾀｰﾝ例:ＧＩＳ＿1次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその４
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_SERIAL_Out"), McTranInfoDefine.D2_GIS_MESH_SERIAL, "ﾊﾟﾀｰﾝ例:ＧＩＳ＿２次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその５
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_SERIAL_Out"), McTranInfoDefine.D3_GIS_MESH_SERIAL, "ﾊﾟﾀｰﾝ例:ＧＩＳ＿３次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 非時系列
                    // 送信パターンその６
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_CELL_Out"), McTranInfoDefine.D1_CELL, "ﾊﾟﾀｰﾝ例:非時系列１次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその７
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_CELL_Out"), McTranInfoDefine.D2_CELL, "ﾊﾟﾀｰﾝ例:非時系列２次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその８
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_CELL_Out"), McTranInfoDefine.D3_CELL, "ﾊﾟﾀｰﾝ例:非時系列３次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその９－１
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D1_GIS_Out"), McTranInfoDefine.D1_GIS, "ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿１次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその９
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_Out"), McTranInfoDefine.D2_GIS_MESH, "ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿２次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // 送信パターンその１０
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D3_GIS_MESH_Out"), McTranInfoDefine.D3_GIS_MESH, "ﾊﾟﾀｰﾝ例:非時系列ＧＩＳ＿３次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataCharacteristicInCell.DATA_KIND.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind == McModelSampleDefine.TEST_GIS_OUT_TESTMODEL_KIND)
            {   // テスト用２次元GISデータ発生モデル
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)60*5); // δT設定 60秒

                csRtnCellPrptyDt.AddInfoType("m_lLatDim", "緯度方向メッシュ配列数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lLatDim", 30);
                csRtnCellPrptyDt.AddInfoType("m_lLonDim", "経度方向メッシュ配列数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lLonDim", 40);

                csRtnCellPrptyDt.AddInfoType("dLatCenter", "中心：緯度（度）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("dLatCenter", 35.5);
                csRtnCellPrptyDt.AddInfoType("dLonCenter", "中心：経度（度）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("dLonCenter", 138.0);
                csRtnCellPrptyDt.AddInfoType("dLatWidth", "範囲：緯度方向（度）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("dLatWidth", 0.11);
                csRtnCellPrptyDt.AddInfoType("dLonWidth", "範囲：経度方向（度）", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("dLonWidth", 0.12);

                // 受信パターンの設定
                {
                }
                // 送信パターンの設定
                {
                    // 送信パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("D2_GIS_MESH_SERIAL_Out"), McTranInfoDefine.D2_GIS_MESH_SERIAL, "ＧＩＳ＿２次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataCharacteristicInCell.DATA_KIND.QUANTITY_OF_WATER_FLOW, "m3/s");
                            csCellChara.SetDataKind(1, "水位", HySDataCharacteristicInCell.DATA_KIND.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "雨量", HySDataCharacteristicInCell.DATA_KIND.SCALOR_RAIN_FALL, "mm/Hour");      // Index2 には、雨量が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else
            {
                // Do nothing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind == McModelSampleDefine.KINEMATIC_WAVE_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("H_Initial", "初期水位", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("H_Initial", 1.0);
                csRtnDt.AddInfoType("Q_Initial", "初期流量", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 0.1);
                csRtnDt.AddInfoType("V_Initial", "初期流速", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("V_Initial", 0.1);
            }
            else if (csModelKind == McModelSampleDefine.BASIN)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("m_dOutQ0", "流量初期値", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dOutQ0", 0.01);
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_OUT_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                csRtnDt.AddInfoType("OUTTIME_LAG", "出力時間間隔（秒）", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("OUTTIME_LAG", 1.0 * 3600.0);
            }
            else if (csModelKind == McModelSampleDefine.TEST_FILE_IN_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND) == true)
            {   //３次元時系列ＣＳＶファイル出力ならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                csRtnDt.AddInfoType("OUTTIME_LAG", "出力時間間隔（秒）", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("OUTTIME_LAG", 1.0 * 3600.0);
            }
            else if (csModelKind.Equals(McModelSampleDefine.TEST_D3CSV_FILE_IN_KIND) == true)
            {   //３次元時系列ＣＳＶファイル入力ならば
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csRtnDt = new SampleCodelInitialData(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelSampleDefine.TEST_TRANINFO_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else if (csModelKind == McModelSampleDefine.TEST_GIS_OUT_TESTMODEL_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;
            
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    McModelSampleDefine.BASIN, // モデルの識別子
                    McModelSampleDefine.BASIN_NAME  // モデルの名称
                                           );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("テスト用の流量発生モデルです。（モデルディバッグ時に用いる）出力は１地点のみ。：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Basin");
            csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); // <-- モデル解説書
            
            csModelInfo.SetLibraryDispMode(false);  // ライブラリーツリーは非表示
            
            m_csCalModelInforList.AddLast(csModelInfo);



            csModelInfo = new McModelInfo(
                        (HySID)this.GetFactoryID(),
                        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                        new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                        McModelSampleDefine.TEST_GIS_OUT_TESTMODEL_KIND, // モデルの識別子
                        McModelSampleDefine.TEST_GIS_OUT_TESTMODEL_NAME  // モデルの名称
                                 );

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("システム開発時のディバッグ用テストＧＩＳデータ発生用モデル（２次元メッシュデータのみ）：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("DefaultModel");
            csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);



            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    McModelSampleDefine.KINEMATIC_WAVE_KIND, // モデルの識別子
                    McModelSampleDefine.KINEMATIC_WAVE_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("コーディングサンプル：簡易河道モデルのサンプルです。：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("Lane");
            csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);



            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_OUTPUT_MODEL, // <-- 出力要素は、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("OUTPUT_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    McModelSampleDefine.TEST_FILE_OUT_KIND, // モデルの識別子
                    McModelSampleDefine.TEST_FILE_OUT_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("コーディングサンプル：ファイル出力クラス（ポイント、１次元、２次元のＣＳＶ形式、モデルディバッグ時に用いる）：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); // <-- モデル解説書
            csModelInfo.SetIconName("csvWrite");
            
            m_csCalModelInforList.AddLast(csModelInfo);



            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL, // <-- 入力要素は、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("INPUT_SAMPLE_MODELS"),  // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McModelSampleDefine.TEST_FILE_IN_KIND, // モデルの識別子
                McModelSampleDefine.TEST_FILE_IN_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("コーディングサンプル：ファイル入力クラス（１次元変数：時系列 ＣＳＶ形式、モデルディバッグ時に用いる）：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); // <-- モデル解説書
            csModelInfo.SetIconName("csvRead");
            
            m_csCalModelInforList.AddLast(csModelInfo);



            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL, // <-- 入力要素は、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("INPUT_SAMPLE_MODELS"),  // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND, // モデルの識別子
                McModelSampleDefine.TEST_2DCSV_FILE_IN_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("コーディングサンプル：ファイル入力クラス（２次元変数：時系列 ＣＳＶ形式、モデルディバッグ時に用いる）：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); // <-- モデル解説書
            csModelInfo.SetIconName("csvRead");
            
            m_csCalModelInforList.AddLast(csModelInfo);
            


            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_OUTPUT_MODEL, // <-- 出力要素は、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("OUTPUT_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND,
                McModelSampleDefine.TEST_D3CSV_FILE_OUT_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("コーディングサンプル：ファイル出力クラス（３次元変数：時系列ＣＳＶ形式、モデルディバッグ時に用いる）：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("csvWrite");
            
            m_csCalModelInforList.AddLast(csModelInfo);



            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_INPUT_MODEL, // <-- 入力要素は、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("INPUT_SAMPLE_MODELS"),  // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                McModelSampleDefine.TEST_D3CSV_FILE_IN_KIND,
                McModelSampleDefine.TEST_D3CSV_FILE_IN_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("コーディングサンプル：ファイル入力クラス（３次元変数：時系列 ＣＳＶ形式、モデルディバッグ時に用いる）：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("csvRead");
            
            m_csCalModelInforList.AddLast(csModelInfo);



            // 伝送データ取り扱い例を示したコーディング例
            csModelInfo = new McModelInfo(
                        (HySID)this.GetFactoryID(),
                        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                        new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                        McModelSampleDefine.TEST_TRANINFO_KIND, // モデルの識別子
                        McModelSampleDefine.TEST_TRANINFO_NAME  // モデルの名称
                             );

            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("伝送データの取り扱いを示したコーディング例です（処理は何もしない）。２個のモデル接続を直接接続してディバッガ－で動作の参考等に使用してください：コーディングサンプルなので、正式プロジェクトには使用しないで下さい。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName("DefaultModel");
            //csModelInfo.SetLibraryDispMode(false);  // <-- コメントを外すと、ライブラリ管理画面上に表示されなくなります。
            csModelInfo.SetManualFileName(".\\Sample\\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);



            // 特別モデル型紙の情報
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_SAMPLE_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    McModelSampleDefine.CODE_SAMPLE_MODEL_KIND, // モデルの識別子
                    McModelSampleDefine.CODE_SAMPLE_MODEL_NAME  // モデルの名称
                                         );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("コーディング例です。（処理は何もしない）");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName(new HySString("DefaultModel"));
            csModelInfo.SetLibraryDispMode(false);  // <-- ライブラリ管理画面上に表示させない場合の例。

            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加


            return m_csCalModelInforList;
        }

    }
}
