﻿// <summary>ソースコード：モデル用プロパティスクリーンファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Viewer;
using CommonMP.HYMCO.CoreImpl.Controller;

using CommonMP.HYMCO.CoreOptions.McViewer.DotNetViewer;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯスクリーンファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>
    /// [CommonMP][ver 1.0.0][2009/09/17][新規作成]
    /// [CommonMP][ver 1.1.0][2010/10/01][修正]
    /// </para>
    /// </remarks>
    public class HYMCO_SCREEN_FACTORY_CREATOR_IMPLE : PROPERTY_SCREEN_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_SCREEN_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_SCREEN_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_SCREEN_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルプロパティスクリーンファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public virtual McPropertyScreenFactoryBase CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper.McSamplePropertyScreenFactory();
        }
    }
}



// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McSampleModelForDeveloper
{  
    /// <summary><para>class outline:</para>
    /// <para>モデル用プロパティスクリーンファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/06/25][新規作成]</para>
    /// </remarks>
    public class McSamplePropertyScreenFactory : McPropertyScreenFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>初期処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Init(csFactoryMng) </para>
        /// </example>
        /// <param name="csFactoryMng">ファクトリ管理</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override void Init(HySFactoryMng csFactoryMng)
        {
            // ファクトリ管理クラス取得
            m_csFactoryMng = (HySFactoryManager)csFactoryMng;
        }

        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // To Do モデル作成側ファクトリクラスと同じ値にして下さい
            return McModelSampleDefine.SAMPLE_MODEL_LIB;
        }

 
        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ画面クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelPropertyScreen csScreen = CreatePropertyScreen( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別（＝画面種別）</param>
        /// <returns>McModelPropertyScreen モデルプロパティ画面クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McModelPropertyScreen CreatePropertyScreen(HySKind csModelKind)
        {
            McModelPropertyScreen csScreen = null;

            if (csModelKind.Equals(McModelSampleDefine.CODE_SAMPLE_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csScreen = new McDotNetModelSamplePropertyScreen();
            }
            else if (csModelKind.Equals(McModelSampleDefine.TEST_FILE_OUT_KIND) == true)
            {   // １次元、２次元ＣＳＶファイル出力ならば
                csScreen = new McDotNetTestOutCSVModelPropertyScreen();
            }
            else if (csModelKind.Equals(McModelSampleDefine.TEST_D3CSV_FILE_OUT_KIND)==true)
            {   //３次元時系列ＣＳＶファイル出力ならば
                csScreen = new McDotNetTestOutCSVModelPropertyScreen();
            }
            else if (csModelKind.Equals(McModelSampleDefine.TEST_FILE_IN_KIND)==true)
            {   // １次元時系列ＣＳＶファイル入力ならば
                csScreen = new McDotNetTestReadCSVModelPropertyScreen();
            }
            else if (csModelKind.Equals(McModelSampleDefine.TEST_2DCSV_FILE_IN_KIND)==true)
            {   // ２次元時系列ＣＳＶファイル入力ならば
                csScreen = new McDotNetTestReadCSVModelPropertyScreen();
            }
            else if (csModelKind.Equals(McModelSampleDefine.TEST_D3CSV_FILE_IN_KIND)==true)
            {   //３次元時系列ＣＳＶファイル入力ならば
                csScreen = new McDotNetTestReadCSVModelPropertyScreen();
            }
            else
            {
            }
            // ToDo　引数で与えられた　モデル識別子に従って、演算モデルを返して下さい。（知らない識別子の場合には null を返す）
            //else if( csModelKind.Equals(    

            return csScreen;
        }

        //
    }
}
