﻿// <summary>ソースコード：重み付き合計モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.OptionImpl.McMultiplyWeightForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>重み付き合計モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/01/24][新規作成]</para>
    /// </remarks>
    public class McMultiplyWeightDefine
    {
        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MULTIPLY_WEIGHT_FACTORY_LIB_ID = new HySID("McMultiplyWeight_Factory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>モデル種別</summary>
        public static readonly HySObjectKind MULTIPLY_WEIGHT_MODEL_KIND = new HySObjectKind("McMultiplyWeight_Model");
        /// <summary>モデル名称</summary>
        public static readonly HySString MULTIPLY_WEIGHT_MODEL_NAME = new HySString("重み付き合計モデル");

        //********************************
        //===== 送受信パターン定義 =======
        //********************************
        // 送信パターン
        /// <summary>結合データ</summary>
        public static readonly HySID OUT_PATTERN_MULTIPLY_WEIGHT = new HySID("MultiplyWeightOut");

        //********************************
        //=========== その他 =============
        //********************************
        /// <summary>最大入力端子数</summary>
        public const long MAX_INPUT_NUM = 5;
    }
}
