﻿// <summary>ソースコード：重み付き合計モデル要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.OptionImpl.McMultiplyWeightForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>重み付き合計モデル要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/01/24][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McMultiplyWeightCalInfo : McCalInfo
    {
        /// <summary>重み付き合計</summary>
        public double m_dOut;

        /// <summary>重み</summary>
        public double[] m_dWeight = null;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McMultiplyWeightCalInfo csRtn = new McMultiplyWeightCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McMultiplyWeightCalInfo csOrdDt = (McMultiplyWeightCalInfo)csOrgInfo;

            this.m_dOut = csOrdDt.m_dOut;
            this.m_dWeight = new double[McMultiplyWeightDefine.MAX_INPUT_NUM];
            for (long lLp = 0; lLp < csOrdDt.m_dWeight.Length; lLp++)
            {
                this.m_dWeight[lLp] = csOrdDt.m_dWeight[lLp];
            }

            return true;
        }

    }
}
