﻿// <summary>ソースコード：メインプログラム</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Windows.Forms;

using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;


namespace CommonMPMain
{
    static class CommonMPProgram
    {
        /// <summary><para>class outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// </remarks>
        [STAThread]
        static void Main()
        {
            // 二重起動チェックを行う。
            if( System.Diagnostics.Process.GetProcessesByName(
                System.Diagnostics.Process.GetCurrentProcess().ProcessName).Length <= 1)
            {   // 起動されていない場合のみ起動する。
                System.Threading.Thread.CurrentThread.CurrentUICulture = System.Globalization.CultureInfo.CurrentCulture;

                // システム制御生成
                HySSystemController csSysCtl = new HySSystemController();
                csSysCtl.SetSystemController(csSysCtl);
                csSysCtl.SetConfigureFileName(new HySString("CommonMP.cfg"));

                // システム制御初期処理
                csSysCtl.Initialize();
                // システム起動
                csSysCtl.WakeUp();

                // メイン画面起動
                csSysCtl.Run();
            }
        }
    }
}