﻿// <summary>ソースコード：モデル共通定義クラスサンプル</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.MyModelLIB
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class MyModelDefine
    {
        // ToDo
        // 下記にとらわれず、必要と思われる定義を設定して下さい。（自DLL内クラスで共通に使用すると思われる常数）


        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        // ToDo モデルファクトリＩＤを定義してください。
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = new HySID("MyModelFactory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        // ToDo 提供するモデルの種別と名称を定義して下さい。
        /// <summary>テスト用モデル種別</summary>
        public static readonly HySObjectKind MY_MODEL_KIND = new HySObjectKind("MyModel");
        /// <summary>テスト用モデル名称</summary>
        //public static readonly HySString MY_MODEL_NAME = new HySString("演算モデル型紙");
        public static readonly HySString MY_MODEL_NAME = new HySString(Properties.MyModelResources.MODEL_MY_MODEL_NAME);

        /* * **********  コーディング例です ************
        /// <summary>水文系モデル型紙モデル種別</summary>
        public static readonly HySObjectKind MY_HYDROLOGICAL_MODEL_KIND = new HySObjectKind("MyHydrologicalModel");
        /// <summary>水文系モデル型紙モデル名称</summary>
        public static readonly HySString MY_HYDROLOGICAL_MODEL_NAME = new HySString("水文系モデル型紙");

        /// <summary>水理系モデル型紙モデル種別</summary>
        public static readonly HySObjectKind MY_HYDRAULICS_MODEL_KIND = new HySObjectKind("MyHydraulicsModel");
        /// <summary>水理系モデル型紙モデル名称</summary>
        public static readonly HySString MY_HYDRAULICS_MODEL_NAME = new HySString("水理系モデル型紙");

        /// <summary>独自モデル型紙モデル種別</summary>
        public static readonly HySObjectKind MY_SPECIAL_MODEL_KIND = new HySObjectKind("MySpecialModel");
        /// <summary>独自モデル型紙モデル名称</summary>
        public static readonly HySString MY_SPECIAL_MODEL_NAME = new HySString("独自モデル型紙");
        /** ********************************************/
    }
}
