﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス型紙</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            // ToDo 自作のモデルファクトリ（ネームスペース付き）を new して下さい。
            return new CommonMP.HYMCO.OptionImpl.MyModelLIB.MyModelFactory();
        }
    }
}

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.MyModelLIB
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class MyModelFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return MyModelDefine.MODEL_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (csModelKind.Equals(MyModelDefine.MY_MODEL_KIND) == true)
            {
                csCalModel = new MyModel();
            }
            /*  コーディング例
            else if (csModelKind.Equals(MyModelDefine.MY_HYDROLOGICAL_MODEL_KIND) == true)
            {   // 水文系モデル型紙
                csCalModel = new MyHydrologicalModel();
            }
            else if (csModelKind.Equals(MyModelDefine.MY_HYDRAULICS_MODEL_KIND) == true)
            {   // 水理系モデル型紙ならば
                csCalModel = new MyHydraulicsModel();
            }
            else if (csModelKind.Equals(MyModelDefine.MY_SPECIAL_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csCalModel = new MySpecialModel();
            }
             * */
            // ToDo　引数で与えられた　モデル識別子に従って、演算モデルを返して下さい。（知らない識別子の場合には null を返す）
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind.Equals(MyModelDefine.MY_MODEL_KIND) == true)
            {
                csCalInfoData = new MyCalInfo();
            }
            /* * コーディング例
            else if (csModelKind.Equals(MyModelDefine.MY_HYDROLOGICAL_MODEL_KIND) == true)
            {   // 水文系モデル型紙
                csCalInfoData = new MyHydrologicalCalInfo();
            }
            else if (csModelKind.Equals(MyModelDefine.MY_HYDRAULICS_MODEL_KIND) == true)
            {   // 水理系モデル型紙ならば
                csCalInfoData = new MyHydraulicsCalInfo();
            }
            else if (csModelKind.Equals(MyModelDefine.MY_SPECIAL_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csCalInfoData = new MySpecialCalInfo();
            }
             * */
            // ToDo　引数で与えられた　モデル識別子に従って、演算データを返して下さい。（知らない識別子の場合には null を返す）
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(MyModelDefine.MY_MODEL_KIND) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(60); // δT設定 60秒
                // 受信可能なパターン
                {
                }
                // 送信パターンの設定
                {
                }
            }
            /* * コーディング例
            else if (csModelKind.Equals(MyModelDefine.MY_HYDROLOGICAL_MODEL_KIND) == true)
            {   // 水文系モデル型紙

                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)60); // δT設定 60秒

                // ToDo 下記を参考にして　各モデルのプロパティ情報を設定します
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQb", "流量ｂ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQb", 200.0);
                csRtnCellPrptyDt.AddInfoType("m_dQp", "流量ｐ", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dQp", 2000.0);

                // ToDo 下記を参考にして　モデルが受信出来るパターン／送信出来るパターンを設定します。
                // 受信パターンの設定
                {
                    // 下記を参考にして受信パターンを設定してください。
                    // start of 受信パターンその１設定
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("LineIN"), McTranInfoDefine.D1_CELL_SERIAL, "１次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は３変数
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定（受信パターンのみ）
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // end of 受信パターンその１設定
                    // 複数の受信パターンを設定できます。（受信パターンその２）
                    // その場合には、上記　start of 受信パターンその１設定 から　end of 受信パターンその１設定までを繰り返します。
                }
                // 送信パターンの設定
                {
                    // 下記を参考にして送信パターンを設定してください。
                    // start of 送信パターンその１設定
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("BottomOut"), McTranInfoDefine.SINGLE_CELL_SERIAL, "最下端流出") as McTranInfoPattern;
                    {
                        //csTrnPtn.SetDim(1); // セルの配列（１次元：１個のみ）
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその１設定
                    // 複数の送信パターンを設定できます。
                    // その場合には、上記　start of 送信パターンその１設定 から　end of 送信パターンその１設定までを繰り返します。
                    // （送信パターンその２）
                }
            }
            else if (csModelKind.Equals(MyModelDefine.MY_HYDRAULICS_MODEL_KIND) == true)
            {   // 水理系モデル型紙ならば
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)72); // δT設定 72秒

                // ToDo 下記を参考にして　各モデルのプロパティ情報を設定します
                csRtnCellPrptyDt.AddInfoType("m_lCelNumber", "モデル内セル分割数", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lCelNumber", 51);
                csRtnCellPrptyDt.AddInfoType("m_dRough", "粗度", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dRough", 0.03);
                csRtnCellPrptyDt.AddInfoType("m_dSlope", "河床勾配", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dSlope", 1.0 / 2000.0);
                csRtnCellPrptyDt.AddInfoType("m_dLength", "河道長", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dLength", 100000.0);
                csRtnCellPrptyDt.AddInfoType("m_dWidth", "川幅", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dWidth", 200.0);

                // ToDo 下記を参考にして　モデルが受信出来るパターン／送信出来るパターンを設定します。
                // 受信パターンの設定
                {
                    // 下記を参考にして受信パターンを設定してください。
                    // start of 受信パターンその１設定
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("LineOut"), McTranInfoDefine.D1_CELL_SERIAL, "１次元出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(5); // セル内の情報は５変数
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速（縦断方向)", HySDataKindDefine.VECTOR_L_VELOCITY, "m/sec");         // Index2 には、流速が入る
                            csCellChara.SetDataKind(3, "流速（横断方向)", HySDataKindDefine.VECTOR_W_VELOCITY, "m/sec");         // Index3 には、流速が入る
                            csCellChara.SetDataKind(4, "流速（深さ方向)", HySDataKindDefine.VECTOR_D_VELOCITY, "m/sec");         // Index4 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定（受信パターンのみ）
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // end of 受信パターンその１設定
                    // 複数の受信パターンを設定できます。
                    // その場合には、上記　start of 受信パターンその１設定 から　end of 受信パターンその１設定までを繰り返します。
                    // start of 受信パターンその２設定
                }
                // 送信パターンの設定
                {
                    // 下記を参考にして送信パターンを設定してください。
                    // start of 送信パターンその１設定
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("BottomOut"), McTranInfoDefine.SINGLE_CELL_SERIAL, "最下端流出") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);  // セル内の情報は３変数
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその１設定
                    // 複数の送信パターンを設定できます。
                    // その場合には、上記　start of 送信パターンその１設定 から　end of 送信パターンその１設定までを繰り返します。
                    // start of 送信パターンその２設定
                }
            }
            else if (csModelKind.Equals(MyModelDefine.MY_SPECIAL_MODEL_KIND) == true)
            {   // 独自モデル型紙ならば
                csRtnCellPrptyDt = new MySpecialPropertyData(csLibraryID, csModelKind); // 独自のプロパティデータクラスを生成します。
                csRtnCellPrptyDt.SetStepTime((double)90); // δT設定 90秒

                // ToDo 自作した　独自プロパティデータのメソッドに従って、値を設定してゆきます

                // ToDo 独自モデルであっても、下記を参考にして　モデルが受信出来るパターン／送信出来るパターンを設定します。
                // 受信パターンの設定
                {
                    // 下記を参考にして受信パターンを設定してください。
                    // start of 受信パターンその１設定
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("LineIN"), McTranInfoDefine.D1_CELL_SERIAL, "１次元入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3); // セル内の情報は３変数
                        {
                            csCellChara.SetDataKind(0, "流量", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec"); // Index0 には、流量が入る
                            csCellChara.SetDataKind(1, "水位", HySDataKindDefine.WATER_LEVEL, "m");                 // Index1 には、水位が入る
                            csCellChara.SetDataKind(2, "流速", HySDataKindDefine.SCALOR_VELOCITY, "m/sec");         // Index2 には、流速が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    // end of 受信パターンその１設定
                    // 複数の受信パターンを設定できます。
                    // その場合には、上記　start of 受信パターンその１設定 から　end of 受信パターンその１設定までを繰り返します。
                }
                // 送信パターンの設定
                {
                    // 下記を参考にして送信パターンを設定してください。
                    // start of 送信パターンその１設定
                    McTranInfoPattern　csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(new HySID("Rain"), McTranInfoDefine.D2_CELL_SERIAL, "水位のみ出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, "水位", HySDataKindDefine.WATER_LEVEL, "m");                 // Index2 には、水位が入る
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // end of 送信パターンその１設定
                    // 複数の送信パターンを設定できます。（受信パターンその２）
                    // その場合には、上記　start of 送信パターンその１設定 から　end of 送信パターンその１設定までを繰り返します。
                    // （送信パターンその２）
                }
            }
             * */
            // ToDo　引数で与えられた　モデル識別子に従って、プロパティ表示／設定データを生成し、モデル固有設定デフォルト値を設定して返して下さい。
            //else if( csModelKind.Equals(    
            else
            {
                // Do Noghing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind.Equals(MyModelDefine.MY_MODEL_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

                // コーディング例
                // csRtnDt.AddInfoType("m_dData", "初期値", McDefine.ValKind.DOUBLE);
                // csRtnDt.SetInfo("m_dData", 1.0); 
            }
            /* * コーディング例
            else if (csModelKind.Equals(MyModelDefine.MY_HYDROLOGICAL_MODEL_KIND) == true)
            {   // 水文系モデル型紙
                // ToDo 下記の例に従って、モデルの初期値を設定してください。
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                csRtnDt.AddInfoType("m_dData", "初期値", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dData", 1.0);
            }
            else if (csModelKind.Equals(MyModelDefine.MY_HYDRAULICS_MODEL_KIND) == true)
            {   // 水理系モデル型紙ならば
                // ToDo 下記の例に従って、モデルの初期値を設定してください。
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                csRtnDt.AddInfoType("m_dData", "初期値", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("m_dData", 1.0);
            }
            else if (csModelKind.Equals(MyModelDefine.MY_SPECIAL_MODEL_KIND) == true)
            {   // 特別モデル型紙ならば
                csRtnDt = new MySpecialInitialData(csLibraryID, csModelKind); // モデル独自の初期設定データクラスを生成する
                // ToDo 初期値を設定する
            }
             * */
            // ToDo　引数で与えられた　モデル識別子に従って、初期情報データを生成し、モデル固有設定デフォルト値を設定して返して下さい。
            //else if( csModelKind.Equals(    
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい
                    new HySObjectKind("CAL_SAMPLE_MODELS"), // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    MyModelDefine.MY_MODEL_KIND, // モデルの識別子
                    MyModelDefine.MY_MODEL_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("コーディング型紙です。");
            csModelInfo.SetSummaryInf(Properties.MyModelResources.MODEL_SUMMARY_MY_MODEL);  //<-- バイリンガル化により日本語／英語切替をリソースに記述
            //csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetCreatorInf(Properties.MyModelResources.MODEL_CREATOR_MY_MODEL);  //<-- バイリンガル化により日本語／英語切替をリソースに記述
            csModelInfo.SetIconName(new HySString("DefaultModel"));

            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            /* *  コーディング例
            // 水文系モデル型紙の情報を公開
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_SAMPLE_MODELS"), // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    MyModelDefine.MY_HYDROLOGICAL_MODEL_KIND, // モデルの識別子
                    MyModelDefine.MY_HYDROLOGICAL_MODEL_NAME  // モデルの名称
                                           );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("水文系コーディング型紙です。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName(new HySString("DefaultModel"));
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            // 水理系モデル型紙の情報を公開
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_SAMPLE_MODELS"), // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    MyModelDefine.MY_HYDRAULICS_MODEL_KIND, // モデルの識別子
                    MyModelDefine.MY_HYDRAULICS_MODEL_NAME  // モデルの名称
                                         );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("水理系コーディング型紙です。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName(new HySString("DefaultModel"));
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            // 特別モデル型紙の情報を公開
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_SAMPLE_MODELS"), // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    MyModelDefine.MY_SPECIAL_MODEL_KIND, // モデルの識別子
                    MyModelDefine.MY_SPECIAL_MODEL_NAME  // モデルの名称
                                         );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("コーディング型紙です。");
            csModelInfo.SetCreatorInf("CommonMP　モデル開発者");
            csModelInfo.SetIconName(new HySString("DefaultModel"));
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            * */

            // To Do 新しく作成したモデル情報を作成し、リンクリスト（m_csCalModelInforList）に追加（AddLast）して下さい

            return m_csCalModelInforList;
        }

    }
}
