﻿// <summary>ソースコード：要素演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.NeuralNetworkSample
{
    /// <summary><para>class outline:</para>
    /// <para>サンプルニューラルネットワーク要素内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class NeuralNetworkCalInfo : McCalInfo
    {
        /// <summary>学習／連想モード：０：学習、１：連想 </summary>
        public long m_lMode = 0;

        /// <summary>学習済み結果保存ファイル名</summary>
        public String m_csLearnedResultStockFile;

         /// <summary>学習係数 </summary>
        public double m_dAlpha = 0.1;
        /// <summary>学習慣性係数 </summary>
        public double m_dInertia = 0.75;
        /// <summary>学習打ち切り判定用誤差 </summary>
        public double m_dE2Limit = 0.001;
        /// <summary>シグモイド関数の傾き（値が大きいほど　急激な立ち上がりとなる：非線形性が増す） </summary>
        public double m_dSlope = 5.0;
        /// <summary>最大学習回数</summary>
        public long m_iMaxLearnNum = 10000;
        /// <summary>学習パターン数 </summary>
        public long m_iLearnPtnNum = 1;

        /// <summary>ニューラルネットワーク構造</summary>
        public NeruralNetworkStructInf m_csNetInf = new NeruralNetworkStructInf();
        /*
        /// <summary>層の数 :一応最大４層までとする</summary>
        public long m_lLayerNum = 3;
        /// <summary>各層のニューロン数</summary>
        public int[] m_iNeuronNumber;
        /*
        // この例では　Max４層までの対応とする
        /// <summary> ０－１　間層の結合係数 </summary>
        public double[,] m_dW01 = null;
        /// <summary> １－２　間層の結合係数 </summary>
        public double[,] m_dW12 = null;
        /// <summary> ２－３　間層の結合係数 </summary>
        public double[,] m_dW23 = null;
        //// <summary> ３－４　間層の結合係数 </summary>
        //public double[,] m_dW34 = null;
        */

        //注意
        // 此処に、学習過程での　各層の結合係数を入れておけば、計算中断／再開に対応できるが、
        // ここでは、そこまでの例は対応しない

        /// <summary>学習用入力パターンを受信するデータ配列インデックス値（０相対） </summary>
        public long LEARN_INPUT_PATTERN_ID = -1;
        /// <summary>学習用教師パターンを受信するデータ配列インデックス値（０相対） </summary>
        public long LEARN_TEACH_PATTERN_ID = -1;
        /// <summary>連想用入力パターンを受信するデータ配列インデックス値（０相対） </summary>
        public long RECOG_INPUT_PATTERN_ID = -1;
        /// <summary>連想用用出力パターンを送信するデータ配列インデックス値（０相対） </summary>
        public long RECOG_OUTPUT_PATTERN_ID = -1;
        /// <summary>学習用中誤差信号を送信するするデータ配列インデックス値（０相対） </summary>
        public long LEARN_ERROR_OUT_PATTERN_ID = -1;

        /// <summary>学習パターン入力データ </summary>
        public double[] dInputData = null;
        /// <summary>学習教師パターン入力データ </summary>
        public double[] dTchPtn = null;
        /// <summary>学習済みフラグ(=True:学習済み)</summary>
        public bool m_bLearnFlg = false;

        /// <summary>連想出力データ </summary>
        public double[] dOnputData = null;

        /// <summary>学習ワーク時刻 </summary>
        [NonSerialized]
        public HySTime m_csLearningTime = HySCalendar.CreateNowTime();


        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            NeuralNetworkCalInfo csRtn = new NeuralNetworkCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            NeuralNetworkCalInfo csOrdDt = (NeuralNetworkCalInfo)csOrgInfo;

            // this.m_dData = csOrdDt.m_dData; コーディングイメージです

            // To Do
            // 此処に、追加したメンバーをコピーする処理を入れます。
            
            return true;
        }

        /// <summary><para>class outline:</para>
        /// <para>ニューラルネットワーク構造データクラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
        /// <para>remarks</para>
        /// <para>ネットワークの構造及び、結合係数を保持するクラス</para>
        /// </remarks>
        [Serializable]
        public class NeruralNetworkStructInf : HySDataRoot
        {
            /// <summary>層の数 :一応最大４層までとする</summary>
            public long m_lLayerNum = 3;
            /// <summary>各層のニューロン数</summary>
            public int[] m_iNeuronNumber;

            // この例では　Max４層までの対応とする
            /// <summary> ０－１　間層の結合係数 </summary>
            public double[,] m_dW01 = null;
            /// <summary> １－２　間層の結合係数 </summary>
            public double[,] m_dW12 = null;
            /// <summary> ２－３　間層の結合係数 </summary>
            public double[,] m_dW23 = null;
            //// <summary> ３－４　間層の結合係数 </summary>
            //public double[,] m_dW34 = null;
        }

    }
}
