﻿// <summary>ソースコード：ニューラルネットワークコーディングサンプル</summary>
// <author>CommonMP</author>
using System;
using System.Collections.Generic;
using System.Text;

namespace CommonMP.HYMCO.OptionImpl.NeuralNetworkSample
{
    /// <summary><para>class outline:</para>
    /// <para>ニューラルネットワーク全体</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/01][新規作成]</para>
    /// </remarks>
    public class NN_NeuralNetwork
    {
        /// <summary>層の数 </summary>
        protected long m_lLayerNum;
        /// <summary>各層のニューロン数</summary>
        protected int[] m_iNeuronNumber;

        /// <summary>ニューロン層配列</summary>
        protected NN_Layer[] m_csLayer;
        /// <summary>ニューロン層間結合ネットワーク配列</summary>
        protected NN_Network[] m_csNetwork;

        /// <summary>２乗誤差 </summary>
        protected double m_dE2 = 0.0;
        /// <summary>２乗誤差判定用ワーク 変数</summary>
        double[] dOutputDt = null;

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NN_NeuralNetwork csObj = new NN_NeuralNetwork() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected NN_NeuralNetwork()
        { }

        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> NN_NeuralNetwork csObj = new NN_NeuralNetwork(lLayerNum) </para>
        /// </example>
        /// <param name="lLayerNum">レイヤーの数</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public NN_NeuralNetwork(long lLayerNum)
        {
            m_lLayerNum = lLayerNum;
            m_iNeuronNumber = new int[m_lLayerNum];
            m_csLayer = new NN_Layer[m_lLayerNum];
            m_csNetwork = new NN_Network[m_lLayerNum - 1];
        }
        /// <summary><para>method outline:</para>
        /// <para>層数取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> long lNum = GetLayerNum() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>レイヤーの数</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public long GetLayerNum()
        {
            return m_lLayerNum;
        }

        /// <summary><para>method outline:</para>
        /// <para>各層内のニューロン数設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLayerNeuronNum(iLayerIdx,iNeuronNum)</para>
        /// </example>
        /// <param name="iLayerIdx">ニューロン層インデックス（０相対）</param>
        /// <param name="iNeuronNum">ニューロン数</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLayerNeuronNum(int iLayerIdx, int iNeuronNum)
        {
            m_iNeuronNumber[iLayerIdx] = iNeuronNum;
        }

        /// <summary><para>method outline:</para>
        /// <para>ニューラルネットワーク生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>CreateNeuralNetwork( )</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void CreateNeuralNetwork()
        {
            m_csLayer[0] = new NN_InputLayer();
            m_csLayer[0].CreateNeuron(m_iNeuronNumber[0]);
            for (long lLp = 1; lLp < m_lLayerNum-1; lLp++)
            {
                m_csLayer[lLp] = new NN_Layer();
                m_csLayer[lLp].CreateNeuron(m_iNeuronNumber[lLp]);

                m_csNetwork[lLp - 1] = new NN_Network();
                m_csNetwork[lLp - 1].CreateNetwork(ref m_csLayer[lLp], ref m_csLayer[lLp - 1]);
            }
            m_csLayer[m_lLayerNum - 1] = new NN_OutputLayer();
            m_csLayer[m_lLayerNum - 1].CreateNeuron(m_iNeuronNumber[m_lLayerNum - 1]);

            m_csNetwork[m_lLayerNum - 2] = new NN_Network();
            m_csNetwork[m_lLayerNum - 2].CreateNetwork(ref m_csLayer[m_lLayerNum - 1], ref m_csLayer[m_lLayerNum - 2]);

            dOutputDt = new double[m_iNeuronNumber[m_lLayerNum - 1]];
        }

        /// <summary><para>method outline:</para>
        /// <para>学習処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Learn(dInputDt,dTeacherDt)</para>
        /// </example>
        /// <param name="dInputDt">入力データ</param>
        /// <param name="dTeacherDt">教師データ</param>
        /// <returns>学習２乗誤差</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double Learn(double[] dInputDt, double[] dTeacherDt)
        {
            m_dE2 = 0.0;
            NN_Neuron.bClippingFlg = true; // 学習性能を高める為クリッピング処理を行う
            // 想起
            ((NN_InputLayer)m_csLayer[0]).Recognize(dInputDt);

            // 想起結果取得
            ((NN_OutputLayer)m_csLayer[m_lLayerNum - 1]).GetOut(ref dOutputDt);

            // ２乗誤差計算
            m_dE2 = 0.0;
            for (int i = 0; i < m_iNeuronNumber[m_lLayerNum - 1]; i++)
            {
                m_dE2 += (dTeacherDt[i] - dOutputDt[i]) * (dTeacherDt[i] - dOutputDt[i]);    
            }

            // 学習
            ((NN_OutputLayer)m_csLayer[m_lLayerNum - 1]).Learn(dTeacherDt);

            return m_dE2;
        }

        /// <summary><para>method outline:</para>
        /// <para>想起処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Recognize(dInputDt,dOutputDt)</para>
        /// </example>
        /// <param name="dInputDt">連想入力</param>
        /// <param name="dOutputDt">連想出力</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void Recognize(double[] dInputDt, ref double[] dOutputDt)
        {
            NN_Neuron.bClippingFlg = false;
            ((NN_InputLayer)m_csLayer[0]).Recognize(dInputDt);
            ((NN_OutputLayer)m_csLayer[m_lLayerNum - 1]).GetOut(ref dOutputDt);
        }
        /// <summary><para>method outline:</para>
        /// <para>結合の重みの初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>WeightInitialize(dMax,dMin )</para>
        /// </example>
        /// <param name="dMax">最大値</param>
        /// <param name="dMin">最小値（負値もOK)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void WeightInitialize(double dMax, double dMin)
        {
            for (long lLp = 0; lLp < m_lLayerNum -1; lLp++)
            {
                m_csNetwork[lLp].WeightInitialize(dMax, dMin);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>ニューロン間結合ネットワーク設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetLayerWeight(iNetworkIdx,dW01)</para>
        /// </example>
        /// <param name="iNetworkIdx">ニューロン層インデックス（０相対）</param>
        /// <param name="dW01">結合係数配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetLayerWeight(int iNetworkIdx, double[,] dW01)
        {
            //m_iNeuronNumber[iLayerIdx] = iNeuronNum;
            m_csNetwork[iNetworkIdx].m_dW = dW01;
        }
        /// <summary><para>method outline:</para>
        /// <para>ニューロン間結合ネットワーク取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>double[,] dW = GetLayerWeight()</para>
        /// </example>
        /// <param name="iNetworkIdx">ニューロン層インデックス（０相対）</param>
        /// <returns>ニューロン間結合ネットワーク</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public double[,] GetLayerWeight(int iNetworkIdx)
        {
            //m_iNeuronNumber[iLayerIdx] = iNeuronNum;
            return m_csNetwork[iNetworkIdx].m_dW;
        }
    }
}
