﻿// <summary>ソースコード：モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.NeuralNetworkSample
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class NeuralNetworkSampleDefine
    {
        // ToDo
        // 下記にとらわれず、必要と思われる定義を設定して下さい。（自DLL内クラスで共通に使用すると思われる常数）

        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        // ToDo モデルファクトリＩＤを定義してください。
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID MODEL_FACTORY_LIB_ID = new HySID("NeuralNetworkSampleFactory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        // ToDo 提供するモデルの種別と名称を定義して下さい。
        /// <summary>サンプルニューラルネットワークモデル種別</summary>
        public static readonly HySObjectKind NEURALNET_MODEL_KIND = new HySObjectKind("NeuralNetworkModel");
        /// <summary>サンプルニューラルネットワークモデル名称</summary>
        public static readonly HySString NEURALNET_MODEL_NAME = new HySString("サンプルニューラルネットワーク");
        //public static readonly HySString NEURALNET_MODEL_NAME = new HySString(Properties.MyModelResources.MODEL_MY_MODEL_NAME);
        /// <summary>サンプルニューラルネットワークモデルテスト用データ発生種別</summary>
        public static readonly HySObjectKind NEURALNET_MODEL_TEST_KIND = new HySObjectKind("NeuralNetworkModelTEST");
        /// <summary>サンプルニューラルネットワークモデルテスト用データ発生名称</summary>
        public static readonly HySString NEURALNET_MODEL_NAME_TEST = new HySString("サンプルニューラルネットワーク　テスト用データ発生");

        /// <summary>学習入力パターンID</summary>
        public static HySID LEARN_INPUT_PATTERN_ID = new HySID("LearnInputPattern");
        /// <summary>学習教師パターンID</summary>
        public static HySID LEARN_TEACH_PATTERN_ID = new HySID("LearnTeachPattern");
        /// <summary>連想入力パターンID</summary>
        public static HySID RECOG_INPUT_PATTERN_ID = new HySID("RecogInputPattern");
        /// <summary>連想出力パターンID</summary>
        public static HySID RECOG_OUTPUT_PATTERN_ID = new HySID("RecogOutputPattern");
        /// <summary>学習エラー出力パターンID</summary>
        public static HySID LEARN_ERROR_OUT_PATTERN_ID = new HySID("LearnErrorOutPattern");
    }
}
