﻿// <summary>ソースコード：ＨＹＭＣＯモデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;


namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.TestModel.TestModelFactory();
        }
    }
}

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.TestModel
{
    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2008/10/01][新規作成]</para>
    /// </remarks>
    public class TestModelFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return TestModelDefine.MODEL_FACTORY_LIB_ID;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (csModelKind.Equals(TestModelDefine.MyForecastModel_MODEL_KIND) == true)
            {
                csCalModel = new MyForecastModel();
            }
            else if (csModelKind.Equals(TestModelDefine.MyStateCalModel_MODEL_KIND) == true)
            {
                csCalModel = new MyStateCalModel();
            }
            //<@Add_CreateCalModel/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind.Equals(TestModelDefine.MyForecastModel_MODEL_KIND) == true)
            {
                csCalInfoData = new MyForecastModelCalInfo();
            }
            else if (csModelKind.Equals(TestModelDefine.MyStateCalModel_MODEL_KIND) == true)
            {
                csCalInfoData = new MyStateCalModelCalInfo();
            }
            //<@Add_CreateCalInfo/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(TestModelDefine.MyForecastModel_MODEL_KIND) == true)
            {
                csRtnCellPrptyDt = new MyForecastModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(60); // δT設定

                //↓プロパティ情報設定↓
                csRtnCellPrptyDt.AddInfoType("m_dForeModelConst", "未来計算型モデル定数", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dForeModelConst", 0.01);
                //↑プロパティ情報設定↑

                //csRtnDt.AddInfoType("m_dData", "変数値", McDefine.ValKind.DOUBLE);
                //csRtnDt.SetInfo("m_dData", 99.9); 
                // ToDo 引数で与えられたモデル識別子に従って、プロパティ情報データを生成し、モデル固有設定値を設定して下さい。
                // 受信可能なパターン
                // ToDo　提供するモデルが受信可能なパターンを設定して下さい。
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      TestModelDefine.Upper,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "上流端入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "流量(入力情報)", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "流量(内部状態)", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR  );
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                // ToDo　提供するモデルが送信可能なパターンを設定して下さい。
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      TestModelDefine.Lower,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "流量(出力情報)", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "流量(内部状態)", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else if (csModelKind.Equals(TestModelDefine.MyStateCalModel_MODEL_KIND) == true)
            {
                csRtnCellPrptyDt = new MyStateCalModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime(60); // δT設定

                //↓プロパティ情報設定↓
                csRtnCellPrptyDt.AddInfoType("m_dStateModelConst", "現状計算型モデル定数", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dStateModelConst", 0.01);
                //↑プロパティ情報設定↑

                //csRtnDt.AddInfoType("m_dData", "変数値", McDefine.ValKind.DOUBLE);
                //csRtnDt.SetInfo("m_dData", 99.9); 
                // ToDo 引数で与えられたモデル識別子に従って、プロパティ情報データを生成し、モデル固有設定値を設定して下さい。
                // 受信可能なパターン
                // ToDo　提供するモデルが受信可能なパターンを設定して下さい。
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      TestModelDefine.Upper,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "上流端入力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "流量（入力情報）", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "流量（内部状態）", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR  );
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }
                // 送信パターンの設定
                // ToDo　提供するモデルが送信可能なパターンを設定して下さい。
                {
                    // 第1パターン
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                      TestModelDefine.Lower,
                      McTranInfoDefine.SINGLE_CELL_SERIAL,
                      "下流端出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "流量（出力情報）", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                            csCellChara.SetDataKind(1, "流量（内部状態）", HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/sec");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            //<@Add_CreateModelProperty/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }
            McInitialInfo csRtnDt = null;

            if (csModelKind.Equals(TestModelDefine.MyForecastModel_MODEL_KIND) == true)
            {
                csRtnDt = new MyForecastModelInitialData(csLibraryID, csModelKind);

                //↓初期化情報設定↓
                csRtnDt.AddInfoType("Q_Initial", "初期流量(出力情報)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 0.1);
                csRtnDt.AddInfoType("Q_internal_Initial", "初期流量(内部状態)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_internal_Initial", 0.1);
                //↑初期化情報設定↑

                // コーディング例
                // csRtnDt.AddInfoType("m_dData", "初期値", McDefine.ValKind.DOUBLE);
                // csRtnDt.SetInfo("m_dData", 1.0); 
                // ToDo　引数で与えられた　モデル識別子に従って、初期情報データを生成し、モデル固有設定デフォルト値を設定して下さい。
            }
            else if (csModelKind.Equals(TestModelDefine.MyStateCalModel_MODEL_KIND) == true)
            {
                csRtnDt = new MyStateCalModelInitialData(csLibraryID, csModelKind);

                //↓初期化情報設定↓
                csRtnDt.AddInfoType("Q_Initial", "初期流量(出力情報)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_Initial", 0.1);
                csRtnDt.AddInfoType("Q_internal_Initial", "初期流量(内部状態)", McDefine.ValKind.DOUBLE);
                csRtnDt.SetInfo("Q_internal_Initial", 0.1);
                //↑初期化情報設定↑

                // コーディング例
                // csRtnDt.AddInfoType("m_dData", "初期値", McDefine.ValKind.DOUBLE);
                // csRtnDt.SetInfo("m_dData", 1.0); 
                // ToDo　引数で与えられた　モデル識別子に従って、初期情報データを生成し、モデル固有設定デフォルト値を設定して下さい。
            }
            //<@Add_CreateModelInitialInfo/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            else
            {
                // Do Nothing
            }
            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo = null;

            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_MODELS"), // To Do   LibraryCategoryXML.xmlに定義されている値の中で、該当するモデル種別を設定してください
                TestModelDefine.MyForecastModel_MODEL_KIND, // モデルの識別子
                TestModelDefine.MyForecastModel_MODEL_NAME  // モデルの名称
            );
            csModelInfo.SetVersionInf("Ver1.0 "); // モデルのバージョン
            csModelInfo.SetSummaryInf("現在の入力状況から、未来（δt後）の状態を算出します。自モデルの内部状態は変化しません。"); // モデルの簡単な説明
            csModelInfo.SetCreatorInf("TestUser"); // モデル開発者名
            csModelInfo.SetIconName(new HySString(@".\UserAnalysisTestModelFactory\MyModelIcon")); // To Do モデル固有アイコン（アイコンを使用しないときは "MyModelIcon" を設定してください）
            csModelInfo.SetManualFileName(@".\UserAnalysisTestModelFactory\MyModelPDF.pdf"); // To Do モデル固有の解説情報等あれば設定してください。
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加


            csModelInfo = new McModelInfo(
                (HySID)this.GetFactoryID(),
                McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                new HySObjectKind("CAL_MODELS"), // To Do   LibraryCategoryXML.xmlに定義されている値の中で、該当するモデル種別を設定してください
                TestModelDefine.MyStateCalModel_MODEL_KIND, // モデルの識別子
                TestModelDefine.MyStateCalModel_MODEL_NAME  // モデルの名称
            );
            csModelInfo.SetVersionInf("Ver1.0 "); // モデルのバージョン
            csModelInfo.SetSummaryInf("現在の入力状況から、現時点の状態を算出します。自モデルの内部状態は変化します。"); // モデルの簡単な説明
            csModelInfo.SetCreatorInf("TestUser"); // モデル開発者名
            csModelInfo.SetIconName(new HySString(@".\UserAnalysisTestModelFactory\MyModelIcon2")); // To Do モデル固有アイコン（アイコンを使用しないときは "MyModelIcon2" を設定してください）
            csModelInfo.SetManualFileName(@".\UserAnalysisTestModelFactory\MyModelPDF2.pdf"); // To Do モデル固有の解説情報等あれば設定してください。
            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加
            //<@Add_GetCalModelInfoList/> ウイザードによる追加の目印　目印を削除しないで下さい　削除した場合には、モデルの追加は、手動で行う必要があります。
            return m_csCalModelInforList;
        }

    }
}
