using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace CommonMP.HYMCO.OptionImpl.CommonControlLibrary
{
    /// <summary>
    /// TextBoxg۰
    /// </summary>
    public class ExTextBox : System.Windows.Forms.TextBox
    {
        private DataType _dataType = DataType.None;
        private ToolTip _toolTip;
        private string _toolTipText;
        private bool _autoToolTip = false;

        /// <summary>
        /// ް̎
        /// </summary>
        public enum DataType
        {
            /// <summary>̑</summary>
            None,
            /// <summary>l[_ȂA}CiX]</summary>
            Long,
            /// <summary>l[_A}CiX]</summary>
            Double,
            /// <summary>p</summary>
            SingleByte
        }

        /// <summary>
        /// ްè
        /// (ްʂɂ͐s܂B)
        /// </summary>
        public DataType exDataType
        {
            get
            {
                return _dataType;
            }
            set 
            {
                _dataType = value;

                //ްʂɂ鏉ݒ
                if ((_dataType == DataType.Long) || (_dataType == DataType.Double))
                {
                    this.TextAlign= HorizontalAlignment.Right;
                    this.MaxLength = 12;
                    if (_toolTipText == null || _toolTipText.Length == 0)
                    {
                        this.exToolTipText = Properties.CommonControlLibraryResources.HINT_INPUT_ONLY_NUMBERS;
                    }
                }
            }
        }

        /// <summary>
        /// c[qg͕Ɏݒ肷邩iTextlύX邲ƂɃc[qgς܂Bj
        /// </summary>
        public bool exAutoToolTip
        {
            get { return _autoToolTip; }
            set { _autoToolTip = value; }
        }

        /// <summary>
        /// c[qg
        /// </summary>
        public string exToolTipText
        {
            get { return _toolTipText; }
            set { _toolTipText = value; }
        }

        /// <summary>
        /// f[^^ɕϊ̒liϊłȂꍇAl0Ԃ܂Bj
        /// </summary>
        public object exValue
        {
            get
            {
                if (_dataType == DataType.Long)
                {
                    long val;
                    long.TryParse(this.Text, out val);
                    return val;
                }
                if (_dataType == DataType.Double)
                {
                    double val;
                    double.TryParse(this.Text, out val);
                    return val;
                }
                else
                {
                    return this.Text;
                }
            }
        }

        /// <summary>
        /// ͂ǂ
        /// </summary>
        public bool exIsEmpty
        {
            get
            {
                if (this.Text == null || this.Text.Length == 0)
                {
                    return true;
                }
                else
                {
                    return false;
                }
            }
        }

        /// <summary>
        /// Textɓ͂ꂽt@CpX݂邩i΃pX͐΃pXɕϊă`FbNj
        /// </summary>
        public bool exIsFileExists
        {
            get
            {
                if (this.Text == null || this.Text.Length == 0)
                {
                    return false;
                }
                else
                {
                    return CommonLib.FileExists(this.Text);
                }
            }
        }

        /// <summary>
        /// Textɓ͂ꂽt@CpXLȏꍇA΃pXԂ
        /// </summary>
        public string exValidFullPath
        {
            get
            {
                string sPath = "";
                if (this.exIsFileExists)
                {
                    return CommonLib.GetFullPath(this.Text);
                }
                return sPath;
            }
        }

        /// <summary>
        /// Textɓ͂ꂽt@CpX̃fBNgLȏꍇAfBNgԂ
        /// </summary>
        public string exValidDirectory
        {
            get
            {
                string sDir = "";
                string sPath = CommonLib.GetFullPath(this.Text);
                int iPos = sPath.LastIndexOf('\\');
                if (sPath.Length > 0 && iPos >= 0)
                {
                    sDir = sPath.Substring(0, iPos);
                    if (!System.IO.Directory.Exists(sDir))
                    {
                        sDir = "";
                    }
                }
                return sDir;
            }
        }

        /// <summary>
        /// Textɓ͂ꂽt@CpX̃t@Ĉ݂Ԃ
        /// </summary>
        public string exFileNameRemovePath
        {
            get
            {
                string sFile = "";
                string sPath = CommonLib.GetFullPath(this.Text);
                int iPos = sPath.LastIndexOf('\\');
                if (sPath.Length > (iPos + 1) && iPos >= 0)
                {
                    sFile = sPath.Substring(iPos + 1);
                }
                else
                {
                    sFile = sPath;
                }
                return sFile;
            }
        }



        /// <summary>
        /// ݽ׸
        /// </summary>
        public ExTextBox()
        {
            
        }

        /// <summary>
        /// Dispose
        /// </summary>
        /// <param name="disposing"></param>
        protected override void Dispose(bool disposing)
        {
            if (_toolTip != null)
            {
                _toolTip.Dispose();
                _toolTip = null;
            }
            base.Dispose(disposing);
        }

        /// <summary>
        /// OnCreateControl
        /// </summary>
        protected override void OnCreateControl()
        {
            base.OnCreateControl();

            //°Ăݒ肷
            if (_toolTip == null)
            {
                _toolTip = new ToolTip();
            }
        }

        /// <summary>
        /// OnTextChanged
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnTextChanged(EventArgs e)
        {
            base.OnTextChanged(e);
        }

        /// <summary>
        /// OnMouseEnter
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnMouseEnter(EventArgs e)
        {
            //°Ăݒ肷
            if (_autoToolTip)
            {
                _toolTip.Active = true;
                _toolTip.SetToolTip(this, this.Text);   //ݒ̏ꍇ͓͒l
            }
            else if (_toolTipText != null && _toolTipText.Length > 0)
            {
                _toolTip.Active = true;
                _toolTip.SetToolTip(this, _toolTipText);
            }

            base.OnMouseEnter(e);

        }

        /// <summary>
        /// OnMouseLeave
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnMouseLeave(EventArgs e)
        {
            if (_toolTip != null)
            {
                _toolTip.Active = false;
            }

            base.OnMouseLeave(e);
        }

        /// <summary>
        /// OnEnter
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnEnter(EventArgs e)
        {
            //Iς݂ɂ
            this.SelectAll();

            //ްʂɂIME
            if ((_dataType == DataType.Long) || (_dataType == DataType.Double) || (_dataType == DataType.SingleByte))
            {
                this.ImeMode = ImeMode.Disable;     //IMEgps
            }
            else 
            {
            }

            base.OnEnter(e);
        }

        /// <summary>
        /// OnKeyPress
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnKeyPress(KeyPressEventArgs e)
        {
            //----------------------------------------
            // ͕̐s
            //----------------------------------------
            //Backspace͋
            if (e.KeyChar != '\b')
            {

                //l[_Ȃ]
                if (_dataType == DataType.Long)
                {
                    //0`9ȊOͲĂ𖳌ɂ
                    if (e.KeyChar < '0' || e.KeyChar > '9')
                    {
                        if (e.KeyChar == '-')
                        {
                            if (this.SelectionStart > 0)
                            {
                                //1ڈȊO͖iAOKj
                                e.Handled = true;
                            }
                        }
                        else
                        {
                            e.Handled = true;
                        }
                    }
                }
                //l[_]
                else if (_dataType == DataType.Double)
                {
                    //0`9ȊOͲĂ𖳌ɂ
                    if (e.KeyChar < '0' || e.KeyChar > '9')
                    {
                        if (e.KeyChar == '.')
                        {
                            if (this.Text.IndexOf('.') >= 0 && this.SelectedText != this.Text)
                            {
                                //_2߂͖iAOKj
                                e.Handled = true;
                            }
                        }
                        else if (e.KeyChar == '-')
                        {
                            if (this.SelectionStart > 0)
                            {
                                //1ڈȊO͖iAOKj
                                e.Handled = true;
                            }
                        }
                        else
                        {
                            e.Handled = true;
                        }
                    }
                }

            }

            base.OnKeyPress(e);
        }

        /// <summary>
        /// OnValidating
        /// </summary>
        /// <param name="e">EventArgs</param>
        protected override void OnValidating(System.ComponentModel.CancelEventArgs e)
        {
            //----------------------------------------
            // ͕s
            //----------------------------------------
            if (this.Text != null && this.Text.Length > 0)
            {
                //l[_Ȃ]
                if (_dataType == DataType.Long)
                {
                    long lResult;
                    if (!long.TryParse(this.Text, out lResult))
                    {
                        e.Cancel = true;
                    }
                }
                //l[_]
                else if (_dataType == DataType.Double)
                {
                    double dResult;
                    if (!double.TryParse(this.Text, out dResult))
                    {
                        e.Cancel = true;
                    }
                }
            }

            base.OnValidating(e);
        }

        
    }
}
