using System;
using System.Collections.Generic;
using System.Text;

namespace CommonMP.HYMCO.OptionImpl.CommonControlLibrary
{
    /// <summary>
    /// wiseft@Cǂݍ݃NX
    /// </summary>
    public class ReadWisefFile
    {
        private static readonly string ERROR_MSG_ELSE = Properties.CommonControlLibraryResources.MSG_FAIL_TO_READ_WISEF;

        /// <summary> ΏۂƂϑ </summary>
        private string m_sStationType = "";
        /// <summary> ΏۂƂϑʖ </summary>
        private string m_sStationName = "";
        /// <summary> ΏۂƂf[^Zbg </summary>
        private string m_sDataTypesName = "";

        /// <summary> ΏۂƂf[^ZbgXg </summary>
        private Dictionary<string, string> m_sDataTypes = new Dictionary<string, string>();

        /// <summary> ǂݍWiseff[^ (Key=, value=l[ϑn_, Z]) </summary>
        private SortedList<string, double[,]> m_WisefData = null;

        /// <summary> G[bZ[W </summary>
        private string m_sErrorMsg = "";


        /// <summary>
        /// ǂݍWiseff[^ (Key=, value=l[ϑn_, Z])
        /// </summary>
        public SortedList<string, double[,]> WisefData
        {
            get
            {
                return m_WisefData;
            }
        }

        /// <summary>
        /// G[bZ[W
        /// </summary>
        public string ErrorMessage
        {
            get
            {
                return m_sErrorMsg;
            }
        }

        /// <summary>
        /// RXgN^
        /// </summary>
        /// <param name="sStationType">ΏۂƂϑ</param>
        /// <param name="sDataType">ΏۂƂf[^Zbg</param>
        public ReadWisefFile(string sStationType, params string[] sDataType)
        {
            //ǂݍފϑʂi[
            m_sStationType = sStationType.ToUpper();
            m_sStationName = GetStationName(m_sStationType);

            //ǂݍރf[^Zbgi[
            foreach (string sType in sDataType)
            {
                if (!m_sDataTypes.ContainsKey(sType.ToUpper()))
                {
                    string sName = GetDataTypeName(sType.ToUpper());
                    m_sDataTypes.Add(sType.ToUpper(), sName);
                    m_sDataTypesName += (m_sDataTypesName.Length > 0 ? "," : "") + sType.ToUpper();
                }
            }

        }

        /// <summary>
        /// ϑʖ擾
        /// </summary>
        /// <param name="sStationType">ϑ</param>
        /// <returns>ϑʖ</returns>
        private string GetStationName(string sStationType)
        {
            if (sStationType == "H") return Properties.CommonControlLibraryResources.STAGE_DISCHARGE_STATION;   //ʗʊϑ
            if (sStationType == "R") return Properties.CommonControlLibraryResources.RAINFALL_GAUGING_STATION;  //Jʊϑ
            if (sStationType == "WQ") return Properties.CommonControlLibraryResources.QUALITY_AND_SEDIMENT_STATION; //Eꎿϑ
            if (sStationType == "GH") return Properties.CommonControlLibraryResources.GROUNDWATER_LEVEL_STATION;  //nʊϑ
            if (sStationType == "GWQ") return Properties.CommonControlLibraryResources.GROUNDWATER_QUALITY_STATION;   //nϑ
            if (sStationType == "DAM") return Properties.CommonControlLibraryResources.DAM;   //_
            if (sStationType == "PUMP") return Properties.CommonControlLibraryResources.AMOUNT_OF_INTAKE_WATER;    //搅
            if (sStationType == "NET") return Properties.CommonControlLibraryResources.WEATHER_STATION; //Cۊϑ
            if (sStationType == "OCE") return Properties.CommonControlLibraryResources.OCEANOGRAPHIC_PHENOMENA;   //C

            return "";
        }

        /// <summary>
        /// f[^Zbg擾
        /// </summary>
        /// <param name="sDataType">f[^Zbg</param>
        /// <returns>f[^Zbg</returns>
        private string GetDataTypeName(string sDataType)
        {
            if (sDataType == "HU") return Properties.CommonControlLibraryResources.WATER_LEVEL;   //
            if (sDataType == "HH") return Properties.CommonControlLibraryResources.WATER_LEVEL;   //
            if (sDataType == "HHA") return Properties.CommonControlLibraryResources.WATER_LEVEL;  //
            if (sDataType == "RU") return Properties.CommonControlLibraryResources.RAINFALL;   //J
            if (sDataType == "RH") return Properties.CommonControlLibraryResources.RAINFALL;   //J
            if (sDataType == "RHA") return Properties.CommonControlLibraryResources.RAINFALL;  //J
            if (sDataType == "QU") return Properties.CommonControlLibraryResources.DISCHARGE;   //
            if (sDataType == "QH") return Properties.CommonControlLibraryResources.DISCHARGE;   //
            if (sDataType == "QHA") return Properties.CommonControlLibraryResources.DISCHARGE;  //
            if (sDataType == "O1U") return Properties.CommonControlLibraryResources.TIDE_LEVEL;  //
            if (sDataType == "DAMU") return Properties.CommonControlLibraryResources.DAM_DATA;   //_
            if (sDataType == "PUMPU") return Properties.CommonControlLibraryResources.AMOUNT_OF_INTAKE_WATER;  //搅

            return "";
        }

        /// <summary>
        /// 񐔂擾
        /// </summary>
        /// <param name="sDataType">f[^Zbg</param>
        /// <returns></returns>
        private int GetDataTypeColumnCnt(string sDataType)
        {
            if (sDataType == "HU") return 3;    //N++l
            if (sDataType == "HH") return 25;   //N+1`24
            if (sDataType == "HHA") return 49;  //N+1`24(*2)
            if (sDataType == "RU") return 4;    //N++l+݉
            if (sDataType == "RH") return 25;   //N+1`24
            if (sDataType == "RHA") return 49;  //N+1`24(*2)
            if (sDataType == "QU") return 3;    //N++l
            if (sDataType == "QH") return 25;   //N+1`24
            if (sDataType == "QHA") return 49;  //N+1`24(*2)
            if (sDataType == "O1U") return 3;   //N++l
            if (sDataType == "DAMU") return 8;  //N++l(*6)
            if (sDataType == "PUMPU") return 3; //N++l

            return 0;
        }

        /// <summary>
        /// Wiseft@Cǂݍݏ
        /// </summary>
        /// <param name="wisefFile">t@CpX</param>
        /// <param name="spotNum">ϑn_</param>
        /// <returns>true:/false:ُiG[e ErrorMessage vpeBŎ擾ł܂Bj</returns>
        public bool ReadWisefMain(string wisefFile, long spotNum)
        {
            m_sErrorMsg = "";
            m_WisefData = new SortedList<string, double[,]>();

            List<string[]> lstDatas = new List<string[]>();
            SortedList<string, int[]> lstDataType = new SortedList<string, int[]>();

            int iDataCount = 0;
            int iStationCount = 0;
            string sKey = "";
            string sType = "";
            string sStation = "";
            string sDataType = "";
            string sLine = null;
            System.IO.StreamReader reader = null;
            try
            {
                reader = new System.IO.StreamReader(wisefFile, System.Text.Encoding.Default);

                //1sځFFILE
                if (!ReadLine(reader, ref sKey, ref sType, ref sLine))
                {   //LsȂ
                    m_sErrorMsg = ERROR_MSG_ELSE;
                    return false;
                }
                if (sKey != "FILE")
                {   //擪sFILEłȂ
                    //"擪ɁuFILEv܂B"
                    m_sErrorMsg = string.Format("{0}i{1}j", ERROR_MSG_ELSE, Properties.CommonControlLibraryResources.MSG_NOT_FILE_AT_BEGINNING);
                    return false;
                }

                bool bNotEOF = true;
                while (bNotEOF)
                {
                    //1sǂݍ
                    bNotEOF = ReadLine(reader, ref sKey, ref sType, ref sLine);
                    if (!bNotEOF)
                        break;  //I

                    if (sKey == "STATION")
                    {
                        sStation = sType;
                        iStationCount++;

                        //ϑʃ`FbN
                        if (!sStation.Equals(m_sStationType))
                        {   //ϑʈvȂꍇG[
                            //"Wiseft@C̊ϑʂ́Au{0}vł͂܂B"
                            m_sErrorMsg = string.Format(Properties.CommonControlLibraryResources.MSG_DIFFERENCE_OF_OBSERVATION_STATION, m_sStationName);
                            return false;
                        }
                    }
                    else if (sKey == "DATA")
                    {
                        sDataType = sType;
                        iDataCount = 0;

                        if (iStationCount == 0)
                        {   //ϑw肳ĂȂ΃G[
                            //"uDATAv̑OɁuSTATIONv܂B"
                            m_sErrorMsg = string.Format("{0} ({1})", ERROR_MSG_ELSE, Properties.CommonControlLibraryResources.MSG_NOT_STATION_BEFORE_DATA);
                            return false;
                        }

                        //f[^Zbg`FbN
                        bool bTargetData = m_sDataTypes.ContainsKey(sDataType);
                        if (!bTargetData)
                        {   //f[^ZbgvȂꍇG[
                            //"Wiseft@C̍ڂ́Au{0}vł͂܂B"
                            m_sErrorMsg = string.Format(Properties.CommonControlLibraryResources.MSG_DIFFERENCE_OF_WISEF_ITEM, m_sDataTypesName);
                            return false;
                        }

                        while (bNotEOF)
                        {   //EOD܂œǂݍ
                            bNotEOF = ReadLine(reader, ref sKey, ref sType, ref sLine);
                            if (!bNotEOF)
                            {   //EODȂ
                                //"uDATAvƑ΂ɂȂuEODv܂B"
                                m_sErrorMsg = string.Format("{0} ({1})", ERROR_MSG_ELSE, Properties.CommonControlLibraryResources.MSG_NO_EXISTENT_PAIRED_EOD);
                                return false;
                            }
                            if (sKey == "EOD")
                                break;  //f[^I

                            iDataCount++;

                            if (bTargetData)
                            {   //ǂݍ񂾃f[^i[Ă
                                string[] sData = new string[3];
                                sData[0] = sDataType;                   //f[^Zbg
                                sData[1] = iStationCount.ToString();    //ϑNo
                                sData[2] = sLine;                       //Psf[^
                                lstDatas.Add(sData);
                            }
                        }

                        //f[^Zbgi[
                        if (!lstDataType.ContainsKey(sDataType))
                        {
                            int[] iValue = new int[2] { iStationCount, iDataCount };
                            lstDataType.Add(sDataType, iValue);
                        }
                        else
                        {   //f[^ZbgłɊi[Ă
                            int[] iValue = lstDataType[sDataType];
                            if (iValue[0] == iStationCount)
                            {   //ϑɂłɓf[^Zbg݂G[
                                //"ϑʓɓf[^Zbg݂܂B"
                                m_sErrorMsg = string.Format("{0} ({1})", ERROR_MSG_ELSE, Properties.CommonControlLibraryResources.MSG_SAME_DATA_SET_NAME);
                                return false;
                            }
                            if (iValue[1] != iDataCount)
                            {   //f[^svĂȂG[
                                //"ef[^̍svĂ܂B"
                                m_sErrorMsg = string.Format("{0} ({1})", ERROR_MSG_ELSE, Properties.CommonControlLibraryResources.MSG_DIFFERENCE_OF_LINAGE);
                                return false;
                            }
                        }

                    }

                }

                if (lstDatas.Count == 0)
                {
                    m_sErrorMsg = ERROR_MSG_ELSE;
                    return false;
                }

                //f[^̊ϑƃvpeBł̐ݒ肵ϑƈv邩̃`FbN
                if (iStationCount != spotNum)
                {
                    //"ݒ肵n_t@C̓eƈقȂ܂B"
                    m_sErrorMsg = Properties.CommonControlLibraryResources.MSG_DIFFERENCE_OF_SETTING_POINTS_NUM;
                    return false;
                }

                //f[^ZbgƂɏi݂͂PނΉȂj
                for (int i = 0; i < Math.Min(lstDataType.Count, 1); i++)
                {
                    sDataType = lstDataType.Keys[i];
                    try
                    {
                        for (int iRow = 0; iRow < lstDatas.Count; iRow++)
                        {
                            string[] sData = lstDatas[iRow];    //0:f[^Zbg, 1:ϑNo, 2:Psf[^
                            if (sDataType != sData[0])
                                continue;   //Ώۃf[^ZbgɈvȂ͓̂ǂݔ΂

                            int iStationNo = int.Parse(sData[1]);       //ϑNo
                            string[] cols = sData[2].Split(',');        //Psf[^

                            //񐔃`FbN
                            int iColCount = GetDataTypeColumnCnt(sDataType);
                            if (iColCount != 0 && cols.Length != iColCount)
                            {
                                //"{0}if[^Zbg[ {1} ]̗񐔂v܂Bj"
                                m_sErrorMsg = string.Format(Properties.CommonControlLibraryResources.MSG_DIFFERENCE_OF_DATA_SET_NAMES_COLUMN_NUM, ERROR_MSG_ELSE, sDataType);
                                return false;
                            }

                            if (sDataType == "HU" || sDataType == "RU" || sDataType == "QU" || sDataType == "O1U" || sDataType == "PUMPU")
                            {   //ϑf[^
                                if (!UDataAnalysis(sDataType, iStationNo, iStationCount, cols))
                                    return false;
                            }
                            else if (sDataType == "HH" || sDataType == "RH" || sDataType == "QH")
                            {   //f[^
                                if (!HDataAnalysis(sDataType, iStationNo, iStationCount, cols))
                                    return false;
                            }
                            else if (sDataType == "HHA" || sDataType == "RHA" || sDataType == "QHA")
                            {   //tf[^
                                if (!HADataAnalysis(sDataType, iStationNo, iStationCount, cols))
                                    return false;
                            }
                            else if (sDataType == "DAMU")
                            {   //_ʃf[^
                                if (!DAMUDataAnalysis(sDataType, iStationNo, iStationCount, cols))
                                    return false;
                            }
                            else
                            {
                                //"{0}if[^Zbg[ {1} ]͖ΉłBj"
                                m_sErrorMsg = string.Format(Properties.CommonControlLibraryResources.MSG_NOT_SUPPORTED_DATA_SET_NAME, ERROR_MSG_ELSE, sDataType);
                                return false;
                            }
                        }
                    }
                    catch
                    {
                        //"{0}if[^Zbg[{1}]̉͂ł܂łBj"
                        m_sErrorMsg = string.Format(Properties.CommonControlLibraryResources.MSG_FAIL_TO_ANALYSIS_OF_DATA_SET_NAME, ERROR_MSG_ELSE, sDataType);
                        return false;
                    }
                }

                return true;
            }
            catch
            {
                m_sErrorMsg = ERROR_MSG_ELSE;
                return false;
            }
            finally
            {
                if (reader != null)
                    reader.Close();
            }
        }

        /// <summary>
        /// LȈsf[^ǂݍ
        /// </summary>
        /// <param name="reader">StreamReader</param>
        /// <param name="sKey">ǂݍ񂾍sKEY(1)</param>
        /// <param name="sType">ǂݍ񂾍sTYPE(2)</param>
        /// <param name="sLine">ǂݍ񂾍s</param>
        /// <returns></returns>
        private bool ReadLine(System.IO.StreamReader reader, ref string sKey, ref string sType, ref string sLine)
        {
            sKey = "";
            sType = "";
            sLine = null;
            bool bTarget = false;
            while (!bTarget && (sLine = reader.ReadLine()) != null)
            {
                if (sLine.Length == 0)
                {   //s͓ǂݔ΂
                    continue;
                }
                else if (sLine.Length >= 3 && sLine.ToUpper().StartsWith("COM"))
                {   //Rgs͓ǂݔ΂
                    continue;
                }
                else if (sLine.Length >= 3 && sLine.Trim().ToUpper().Equals("EOF"))
                {   //I
                    break;
                }

                //Ls
                string[] cols = sLine.Split(',');
                if (cols.Length > 0)
                    sKey = cols[0].Trim().ToUpper();
                if (cols.Length > 1)
                    sType = cols[1].Trim().ToUpper();
                bTarget = true;
            }
            return bTarget;
        }

        /// <summary>
        /// lZbg
        /// </summary>
        /// <param name="sTime"></param>
        /// <param name="dVal">l</param>
        /// <param name="iStationNo">ϑn_</param>
        /// <param name="iStationCount">ϑn_</param>
        private bool SetValue(string sTime, double dVal, int iStationNo, int iStationCount)
        {
            //ԍs
            if (!m_WisefData.ContainsKey(sTime))
            {   //Vԍsǉ
                double[,] dData = new double[iStationCount, 1];
                dData[iStationNo - 1, 0] = dVal;
                m_WisefData.Add(sTime, dData);

                if (iStationNo > 1)
                {   //Qn_ڂȂ̂Ɏԍs݂Ȃien_œĂj
                    //"{0}if[^s̓Ă܂Bj"
                    m_sErrorMsg = string.Format("{0}if[^s̓Ă܂Bj", ERROR_MSG_ELSE);
                    return false;
                }
            }
            else
            {   //łɑ݂̂ŎoĒlZbg
                m_WisefData[sTime][iStationNo - 1, 0] = dVal;
            }
            return true;
        }
        /// <summary>
        /// lZbg
        /// </summary>
        /// <param name="sTime"></param>
        /// <param name="dVal">l</param>
        /// <param name="iStationNo">ϑn_</param>
        /// <param name="iStationCount">ϑn_</param>
        private bool SetValue(string sTime, double[] dVal, int iStationNo, int iStationCount)
        {
            //ԍs
            if (!m_WisefData.ContainsKey(sTime))
            {   //Vԍsǉ
                double[,] dData = new double[iStationCount, dVal.Length];
                for (int iCell = 0; iCell < dVal.Length; iCell++)
                {
                    dData[iStationNo - 1, iCell] = dVal[iCell];
                }
                m_WisefData.Add(sTime, dData);

                if (iStationNo > 1)
                {   //Qn_ڂȂ̂Ɏԍs݂Ȃien_œĂj
                    m_sErrorMsg = string.Format(Properties.CommonControlLibraryResources.MSG_NOT_CORRECTLY_TIME_OF_DATA_ROWS, ERROR_MSG_ELSE);
                    return false;
                }
            }
            else
            {   //łɑ݂̂ŎoĒlZbg
                for (int iCell = 0; iCell < dVal.Length; iCell++)
                {
                    m_WisefData[sTime][iStationNo - 1, iCell] = dVal[iCell];
                }
            }
            return true;
        }



        //************************************************************
        // ef[^ZbgƂ̍s̓\bh
        //************************************************************

        //add_s 20100514
        /// <summary>
        /// ԕ`FbNi24:0000:00ɕϊj
        /// </summary>
        /// <param name="sTime"></param>
        /// <returns></returns>
        private string CheckDateTime(string sTime)
        {
            string t = sTime;
            DateTime dte = new DateTime();
            if (!DateTime.TryParse(t, out dte))
            {   //ϊłȂ
                //No
                string sYmd = sTime.Substring(0, sTime.IndexOf(" "));
                string sHms = sTime.Substring(sTime.IndexOf(" ") + 1);

                if (sHms.StartsWith("24"))
                {   //24̏ꍇA00ɕϊ
                    dte = DateTime.Parse(sYmd + " 00" + sHms.Substring(2));
                    t = dte.AddDays(1).ToString("yyyy/MM/dd HH:mm:ss");
                    return t;
                }
            }

            return DateTime.Parse(t).ToString("yyyy/MM/dd HH:mm:ss");
        }
        //add_e 20100514

        /// <summary>
        /// ϑf[^s
        /// </summary>
        /// <param name="sDataType">f[^Zbg</param>
        /// <param name="iStationNo">ϑn_</param>
        /// <param name="iStationCount">ϑn_</param>
        /// <param name="cols">f[^</param>
        /// <returns>true/false</returns>
        private bool UDataAnalysis(string sDataType, int iStationNo, int iStationCount, string[] cols)
        {
            //Ԃ擾Ab̕[
            //string sTime = cols[0] + " " + cols[1] + ":00"; //mod 20100514 24:0000:00ɕϊ
            string sTime = CheckDateTime(cols[0] + " " + cols[1] + ":00");

            //l擾
            double dVal = Convert.ToDouble(cols[2]);

            //Ԃƒlݒ
            if (!SetValue(sTime, dVal, iStationNo, iStationCount))
                return false;

            return true;
        }

        /// <summary>
        /// _ʃf[^s
        /// </summary>
        /// <param name="sDataType">f[^Zbg</param>
        /// <param name="iStationNo">ϑn_</param>
        /// <param name="iStationCount">ϑn_</param>
        /// <param name="cols">f[^</param>
        /// <returns>true/false</returns>
        private bool DAMUDataAnalysis(string sDataType, int iStationNo, int iStationCount, string[] cols)
        {
            //Ԃ擾Ab̕[
            //string sTime = cols[0] + " " + cols[1] + ":00"; //mod 20100514 24:0000:00ɕϊ
            string sTime = CheckDateTime(cols[0] + " " + cols[1] + ":00");

            //l擾
            double[] dVal = new double[6];
            for (int iCell = 0; iCell < dVal.Length; iCell++)
            {
                dVal[iCell] = Convert.ToDouble(cols[2 + iCell]);
            }

            //Ԃƒlݒ
            if (!SetValue(sTime, dVal, iStationNo, iStationCount))
                return false;

            return true;
        }

        /// <summary>
        /// f[^s
        /// </summary>
        /// <param name="sDataType">f[^Zbg</param>
        /// <param name="iStationNo">ϑn_</param>
        /// <param name="iStationCount">ϑn_</param>
        /// <param name="cols">f[^</param>
        /// <returns>true/false</returns>
        private bool HDataAnalysis(string sDataType, int iStationNo, int iStationCount, string[] cols)
        {
            //Ԃ擾AԂ̕[
            string sTime = cols[0] + " 00:00:00";

            //X^[gԂݒ
            DateTime dteTime = DateTime.Parse(sTime);

            for (int iHour = 1; iHour < 25; iHour++)
            {   //1`24
                dteTime = dteTime.AddHours(1);
                sTime = dteTime.ToString("yyyy/MM/dd HH:mm:ss");

                //l擾
                double dVal = Convert.ToDouble(cols[iHour]);

                //Ԃƒlݒ
                if (!SetValue(sTime, dVal, iStationNo, iStationCount))
                    return false;
            }

            return true;
        }

        /// <summary>
        /// tf[^s
        /// </summary>
        /// <param name="sDataType">f[^Zbg</param>
        /// <param name="iStationNo">ϑn_</param>
        /// <param name="iStationCount">ϑn_</param>
        /// <param name="cols">f[^</param>
        /// <returns>true/false</returns>
        private bool HADataAnalysis(string sDataType, int iStationNo, int iStationCount, string[] cols)
        {
            //Ԃ擾AԂ̕[
            string sTime = cols[0] + " 00:00:00";

            //X^[gԂݒ
            DateTime dteTime = DateTime.Parse(sTime);

            for (int iHour = 1; iHour < 49; iHour += 2)
            {   //1`24
                dteTime = dteTime.AddHours(1);
                sTime = dteTime.ToString("yyyy/MM/dd HH:mm:ss");

                //l擾
                double dVal = Convert.ToDouble(cols[iHour]);

                //Ԃƒlݒ
                if (!SetValue(sTime, dVal, iStationNo, iStationCount))
                    return false;
            }

            return true;
        }



    }

}
