using System;
using System.Collections.Generic;
using System.Text;

//using CommonMP.HYSSOP.Interface.HSData;
//using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
//using CommonMP.HYMCO.Interface.Model;
//using CommonMP.HYMCO.Interface.Data;
//using CommonMP.HYMCO.CoreImpl.Model;
//using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.OptionImpl.CommonControlLibrary
{
    /// <summary><para>class outline:</para>
    /// <para>\`p[^pXML쐬EǍ݃NX</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/12/10][VK쐬]</para>
    /// <para>remarks</para>
    /// <para>\`t@C̕\`p[^XML쐬EǍ݂NX</para>
    /// <example>
    /// <para>gp@iXml쐬jF</para>
    /// <code>
    /// StructXmlTable csTable1 = new StructXmlTable(csXmlWriter, "m_csData", "J(mm/hr)", true, true, false);
    /// //XL[}o
    /// csTable1.AddSchema("Time", "", McDefine.ValKind.STRING, false);
    /// csTable1.AddSchema("Obs", "ϑ", McDefine.ValKind.DOUBLE, true);  //JԂ
    /// //f[^o(f[^JԂ)
    /// HySXmlNode csRowNode = csTable1.CreateRow();  //sǉ
    /// csTable1.AddCol(csRowNode, "Time", "2010/12/10 00:00");  //ǉ
    /// csTable1.AddCol(csRowNode, "Obs", "1", "10");            //ǉ
    /// //Tablem[hǉ
    /// csRtn.AppendChild(csTable1.m_csTableNode);
    /// </code>
    /// <para>gp@iXmlǍݎjF</para>
    /// <code>
    /// StructXmlTable csTable1 = new StructXmlTable(csPrptyXml, "m_csData");
    /// //f[^Ǎ(f[^JԂ)
    /// for (long lRow = 0; lRow  csTable1.m_lRowCnt; lRow++)
    /// {
    ///     Dictionarystring, string csColsList = csTable1.GetCols(lRow);
    ///     double[] dVal = new double[csColsList.Count - 1];
    ///     foreach (KeyValuePairstring, string csCol in csColsList)
    ///     {
    ///         if (csCol.Key.Equals("Time"))
    ///             sTime = Convert.ToDateTime(csCol.Value).ToString("yyyy/MM/dd HH:mm:ss");
    ///         else if (csCol.Key.StartsWith("Obs")){
    ///             long lNo = Convert.ToInt64(csCol.Key.Substring(3));
    ///             dVal[lNo - 1] = Convert.ToDouble(csCol.Value);
    ///         }
    ///     }
    ///     //ϐɒǉ
    ///     m_csData.Add(sTime, dVal);
    /// }
    /// </code>
    /// </example>
    /// </remarks>
    public class StructXmlTable
    {
        /// <summary> HySXmlWriter </summary>
        private HySXmlWriter m_csXmlWriter = null;
        /// <summary> Tablem[h </summary>
        public HySXmlNode m_csTableNode = null;
        /// <summary> Schemam[h </summary>
        public HySXmlNode m_csSchemaNode = null;

        /// <summary> Table/Rowm[hXg </summary>
        public HySXmlNodeList m_csRowNodeList = null;
        /// <summary> Table/Rowm[hXg </summary>
        public long m_lRowCnt = 0;


        /// <summary><para>method outline:</para>
        /// <para>RXgN^i쐬pj</para>
        /// </summary>
        /// <param name="csXmlWriter">HySXmlWriter</param>
        /// <param name="sKey">ϐ</param>
        /// <param name="sName">ځixj</param>
        /// <param name="bAddCols">ǉ\ [True/False]</param>
        /// <param name="bAddRows">sǉ\ [True/False]</param>
        /// <param name="bRowNumHeader">sNoo\邩 [True/False]</param>
        public StructXmlTable(HySXmlWriter csXmlWriter, string sKey, string sName, bool bAddCols, bool bAddRows, bool bRowNumHeader)
        {
            m_csXmlWriter = csXmlWriter;

            m_csTableNode = HySXmlNode.CreateElement("Table", csXmlWriter);
            m_csTableNode.SetAttribute("Key", sKey);
            m_csTableNode.SetAttribute("Name", sName);
            m_csTableNode.SetAttribute("AddCols", (bAddCols ? "True" : "False"));
            m_csTableNode.SetAttribute("AddRows", (bAddRows ? "True" : "False"));
            if (bRowNumHeader)
                m_csTableNode.SetAttribute("RowNumHeader", "True");

            m_csSchemaNode = HySXmlNode.CreateElement("Schema", csXmlWriter);
            m_csTableNode.AppendChild(m_csSchemaNode);
        }

        #region 쐬p

        /// <summary><para>method outline:</para>
        /// <para>Schemaǉ</para>
        /// </summary>
        /// <param name="sKey">ϐ</param>
        /// <param name="sName">ځixj</param>
        /// <param name="DataType">^ [LONG/DOUBLE/STRING/BOOL]</param>
        /// <param name="IsOccurs">JԂڂ [True/False]</param>
        public void AddSchema(string sKey, string sName, McDefine.ValKind DataType, bool IsOccurs)
        {
            HySXmlNode csENode1 = HySXmlNode.CreateElement("Element", m_csXmlWriter);
            csENode1.SetAttribute("Key", sKey);
            csENode1.SetAttribute("Name", sName);
            csENode1.SetAttribute("DataType", DataType.ToString());

            if (IsOccurs)
                csENode1.SetAttribute("Occurs", "True");

            m_csSchemaNode.AppendChild(csENode1);
        }
        /// <summary><para>method outline:</para>
        /// <para>Rowm[h쐬</para>
        /// </summary>
        /// <returns></returns>
        public HySXmlNode CreateRow()
        {
            HySXmlNode csRowNode = HySXmlNode.CreateElement("Row", m_csXmlWriter);
            m_csTableNode.AppendChild(csRowNode);
            return csRowNode;
        }
        /// <summary><para>method outline:</para>
        /// <para>Colm[hǉ</para>
        /// </summary>
        /// <param name="csRowNode">Rowm[h</param>
        /// <param name="sKey">ϐ</param>
        /// <param name="sNo">ϐƂ̔ԍiJԂڂ̏ꍇ̂݁j</param>
        /// <param name="sValue">l</param>
        public void AddCol(HySXmlNode csRowNode, string sKey, string sNo, string sValue)
        {
            HySXmlNode csColNode = HySXmlNode.CreateElement("Col", m_csXmlWriter);
            csColNode.SetAttribute("Key", sKey);
            if (!string.IsNullOrEmpty(sNo))
                csColNode.SetAttribute("No", sNo);
            csColNode.SetAttribute("Value", sValue);

            csRowNode.AppendChild(csColNode);
        }
        /// <summary><para>method outline:</para>
        /// <para>Colm[hǉ</para>
        /// </summary>
        /// <param name="csRowNode">>Rowm[h</param>
        /// <param name="sKey">ϐ</param>
        /// <param name="sValue">l</param>
        public void AddCol(HySXmlNode csRowNode, string sKey, string sValue)
        {
            AddCol(csRowNode, sKey, "", sValue);
        }

        #endregion


        /// <summary><para>method outline:</para>
        /// <para>RXgN^iǍݗpj</para>
        /// </summary>
        /// <param name="csPrptyXml">HySXmlNode</param>
        /// <param name="sKey">ϐ</param>
        public StructXmlTable(HySXmlNode csPrptyXml, string sKey)
        {
            HySXmlNodeList csXmlList = csPrptyXml.GetChildNodeListByTagName("Table");
            long lCnt = csXmlList.GetCount();
            for (long lLoop = 0; lLoop < lCnt; lLoop++)
            {
                HySXmlNode csXml = csXmlList.GetNode(lLoop);
                if (csXml == null)
                    continue;

                string sKeyAttr = csXml.GetAttribute("Key");
                if (sKeyAttr == sKey)
                {
                    m_csTableNode = csXml;

                    m_csRowNodeList = csXml.GetChildNodeListByTagName("Row");
                    m_lRowCnt = m_csRowNodeList.GetCount();
                    break;
                }
            }
        }

        #region Ǎݗp

        /// <summary><para>method outline:</para>
        /// <para>Rowm[hColf[^擾</para>
        /// </summary>
        /// <param name="lRow">CfbNX</param>
        /// <returns>Colf[^Xg[key=ϐ+No, value=l]</returns>
        public Dictionary<string, string> GetCols(long lRow)
        {
            Dictionary<string, string> csColsList = new Dictionary<string, string>();

            if (m_csRowNodeList != null)
            {
                HySXmlNode csRowNode = m_csRowNodeList.GetNode(lRow);
                if (csRowNode != null)
                {
                    HySXmlNodeList csXmlCols = csRowNode.GetChildNodeListByTagName("Col");
                    long lColCnt = csXmlCols.GetCount();

                    for (long lCol = 0; lCol < lColCnt; lCol++)
                    {
                        HySXmlNode csXmlC = csXmlCols.GetNode(lCol);
                        string sKey = csXmlC.GetAttribute("Key");
                        string sNo = csXmlC.GetAttribute("No");
                        string sVal = csXmlC.GetAttribute("Value");

                        csColsList.Add(sKey + sNo, sVal);
                    }
                }
            }
            return csColsList;
        }

        #endregion
    }
}
