﻿// <summary>ソースコード：倍率調整（ⅹ×α）モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McAdjustMultiForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>倍率調整（ⅹ×α）モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/03/21][新規作成]</para>
    /// </remarks>
    public class McAdjustMultiDefine
    {
        
        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID ADJUST_MULTI_LIB = new HySID("AdjustMulti_Factory");

        
        //********************************
        //===== モデル関連定義 ========
        //********************************
        /// <summary>モデル種別</summary>
        public static readonly HySObjectKind ADJUST_MULTI_KIND = new HySObjectKind("AdjustMulti_Model");
        /// <summary>モデル名称</summary>
        public static readonly HySString ADJUST_MULTI_NAME = new HySString(Properties.McAdjustMultiResources.MODEL_ADJUST_MULTI_NAME);

        //********************************
        //===== モデル個別定義 ========
        //********************************
        // ===============================
        // 受信パターン
        // ===============================
        /// <summary>受信パターン 流量（ポイント時系列）</summary>
        public static readonly HySID IN_PATTERN_FLOW_0D = new HySID("INPUT_FLOW_D0");
        /// <summary>受信パターン 水位（ポイント時系列）</summary>
        public static readonly HySID IN_PATTERN_LEVEL_0D = new HySID("INPUT_LEVEL_D0");
        /// <summary>受信パターン 流量（1次元時系列）</summary>
        public static readonly HySID IN_PATTERN_FLOW_1D = new HySID("INPUT_FLOW");
        /// <summary>受信パターン 水位（1次元時系列）</summary>
        public static readonly HySID IN_PATTERN_LEVEL_1D = new HySID("INPUT_LEVEL");
        //  2015.02.17 「任意入力」を追加
        /// <summary>受信パターン 任意（ポイント時系列）</summary>
        public static readonly HySID IN_PATTERN_ARBITRARY_0D = new HySID("ReceiveD0");
        /// <summary>受信パターン 任意（1次元時系列）</summary>
        public static readonly HySID IN_PATTERN_ARBITRARY_1D = new HySID("ReceiveD1");

        // ===============================
        // 送信パターン
        // ===============================
        /// <summary>送信パターン 流量（ポイント時系列）</summary>
        public static readonly HySID OUT_PATTERN_FLOW_0D = new HySID("OUTPUT_FLOW_D0");
        /// <summary>送信パターン 水位（ポイント時系列）</summary>
        public static readonly HySID OUT_PATTERN_LEVEL_0D = new HySID("OUTPUT_LEVEL_D0");
        /// <summary>送信パターン 流量（1次元時系列）</summary>
        public static readonly HySID OUT_PATTERN_FLOW_1D = new HySID("OUTPUT_FLOW");
        /// <summary>送信パターン 水位（1次元時系列）</summary>
        public static readonly HySID OUT_PATTERN_LEVEL_1D = new HySID("OUTPUT_LEVEL");
        //  2015.02.17 「任意出力」を追加
        /// <summary>送信パターン 任意（ポイント時系列）</summary>
        public static readonly HySID OUT_PATTERN_ARBITRARY_0D = new HySID("ReceiveD0");
        /// <summary>送信パターン 任意（1次元時系列）</summary>
        public static readonly HySID OUT_PATTERN_ARBITRARY_1D = new HySID("ReceiveD1");

    }
}
