﻿// <summary>ソースコード：スライド調整（ⅹ＋α）モデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;
namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>ＨＹＭＣＯモデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/10/01][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McAdjustSlideForDevelop.McAdjustSlideFactory();
        }
    }
}

// ToDo namespace は　モデル開発者が変更して、ユニークな名称にして下さい
namespace CommonMP.HYMCO.OptionImpl.McAdjustSlideForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>スライド調整（ⅹ＋α）モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/03/21][新規作成]</para>
    /// </remarks>
    public class McAdjustSlideFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            // ToDo 本ファクトリクラスにユニークな識別子を生成して返してください
            return McAdjustSlideDefine.ADJUST_SLIDE_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (csModelKind.Equals(McAdjustSlideDefine.ADJUST_SLIDE_KIND) == true)
            {
                csCalModel = new McAdjustSlideModel();
            } 
            else
            {
                // Do Nothing
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind.Equals(McAdjustSlideDefine.ADJUST_SLIDE_KIND) == true)
            {
                csCalInfoData = new McAdjustSlideCalInfo();
            }
            else
            {
                // Do Nothing
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(McAdjustSlideDefine.ADJUST_SLIDE_KIND) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(60); // δT設定 60秒

                csRtnCellPrptyDt.AddInfoType("m_dSlideValue", Properties.Resources.SLIDE_AMOUNT /* "スライド量" */, McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dSlideValue", 10.0);


                McTranInfoPattern csTrnPtn = null;
                // 受信可能なパターン
                {
                    // 2015.02.17 流量・水位の入力パターンを削除
                    //===================================================================================================
                    // 第１受信パターン設定 水位（ポイント時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.IN_PATTERN_LEVEL_0D, McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.Resources.WATER_LEVEL /* "水位" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.WATER_LEVEL /* "水位" */, HySDataKindDefine.WATER_LEVEL, "m");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);

                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    //===================================================================================================
                    // 第２受信パターン設定 流量（ポイント時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.IN_PATTERN_FLOW_0D, McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.Resources.DISCHARGE /* "流量" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE /* "流量" */, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);

                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                    //===================================================================================================
                    // 第３受信パターン設定 水位（1次元時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.IN_PATTERN_LEVEL_1D, McTranInfoDefine.D1_CELL_SERIAL, Properties.Resources.WATER_LEVEL /* "水位" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.WATER_LEVEL /* "水位" */, HySDataKindDefine.WATER_LEVEL, "m");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);

                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                    //===================================================================================================
                    // 第４受信パターン設定 流量（1次元時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.IN_PATTERN_FLOW_1D, McTranInfoDefine.D1_CELL_SERIAL, Properties.Resources.DISCHARGE /* "流量" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE /* "流量" */, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);

                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                    // 2015.02.17 「任意入力」追加
                    //===================================================================================================
                    // 第５パターン設定 任意（ポイント時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.IN_PATTERN_ARBITRARY_0D,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.Resources.ANY_INPUT_POINT_TIME_SERIES) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0,
                                Properties.Resources.ANY_INPUT,
                                HySDataKindDefine.ANY_VALUE,
                                Properties.Resources.ANY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                    //===================================================================================================
                    // 第６パターン設定 任意（1次元時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.IN_PATTERN_ARBITRARY_1D,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.Resources.ANY_INPUT_ONE_DIMENSIONAL_TIME_SERIES) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0,
                                Properties.Resources.ANY_INPUT,
                                HySDataKindDefine.ANY_VALUE,
                                Properties.Resources.ANY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                }
                // 送信パターンの設定
                {
                    // 2015.02.17 流量・水位の送信パターンを削除
                    //===================================================================================================
                    // 第１送信パターン設定 水位（ポイント時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.OUT_PATTERN_LEVEL_0D, McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.Resources.WATER_LEVEL /* "水位" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.WATER_LEVEL /* "水位" */, HySDataKindDefine.WATER_LEVEL, "m");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    //===================================================================================================
                    // 第２送信パターン設定 流量（ポイント時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.OUT_PATTERN_FLOW_0D, McTranInfoDefine.SINGLE_CELL_SERIAL, Properties.Resources.DISCHARGE /* "流量" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE /* "流量" */, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    //===================================================================================================
                    // 第３送信パターン設定 水位（1次元時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.OUT_PATTERN_LEVEL_1D, McTranInfoDefine.D1_CELL_SERIAL, Properties.Resources.WATER_LEVEL /* "水位" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.WATER_LEVEL /* "水位" */, HySDataKindDefine.WATER_LEVEL, "m");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    //===================================================================================================
                    // 第４送信パターン設定 流量（1次元時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.OUT_PATTERN_FLOW_1D, McTranInfoDefine.D1_CELL_SERIAL, Properties.Resources.DISCHARGE /* "流量" */) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0, Properties.Resources.DISCHARGE /* "流量" */, HySDataKindDefine.QUANTITY_OF_WATER_FLOW, "m3/s");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 2015.02.17 「任意入力」追加
                    //===================================================================================================
                    // 第５パターン設定 任意（ポイント時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.OUT_PATTERN_ARBITRARY_0D,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.Resources.ANY_OUTPUT_POINT_TIME_SERIES) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0,
                                Properties.Resources.ANY_OUTPUT,
                                HySDataKindDefine.ANY_VALUE,
                                Properties.Resources.ANY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    //===================================================================================================
                    // 第６パターン設定 任意（ポイント時系列）
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McAdjustSlideDefine.OUT_PATTERN_ARBITRARY_1D,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.Resources.ANY_OUTPUT_ONE_DIMENSIONAL_TIME_SERIES) as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1); // セル内の情報は１個のみ
                        {
                            csCellChara.SetDataKind(0,
                                Properties.Resources.ANY_OUTPUT,
                                HySDataKindDefine.ANY_VALUE,
                                Properties.Resources.ANY);
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                }
            }
            else
            {
                // Do Noghing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind.Equals(McAdjustSlideDefine.ADJUST_SLIDE_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
                
            }
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_ETC, // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    McAdjustSlideDefine.ADJUST_SLIDE_KIND, // モデルの識別子
                    McAdjustSlideDefine.ADJUST_SLIDE_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.1");
            csModelInfo.SetSummaryInf(Properties.Resources.SUMMARY /* "スライド調整（ⅹ＋α）する。" */);
            csModelInfo.SetCreatorInf(Properties.Resources.CREATOR /* "CommonMP開発者" */);
            csModelInfo.SetIconName("McAdjustSlide");
            csModelInfo.SetManualFileName("McAdjustSlide.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加


            return m_csCalModelInforList;
        }

    }
}
