﻿// <summary>ソースコード：次元変換モデル共通定義クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.OptionImpl.McDimensionConversionForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>次元変換モデル共通定義クラス</para>
    /// </summary>
    /// <remarks>
    /// <para>Remarks:</para>
    /// <para>本クラスは、必須ではないが、使用の便利さの為、常数等の定義を一つに纏めておく</para>
    /// <para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/02/07][新規作成]</para>
    /// </remarks>
    public class McDimensionConversionDefine
    {
        /// <summary>接続次元種別</summary>
        public enum DimensionType
        {   
            /// <summary></summary>
            SingleCellSerial = 0,   // ポイント時系列
            /// <summary></summary>
            D1CellSerial     = 1,   // 1次元時系列
            /// <summary></summary>
            D2CellSerial     = 2    // 2次元時系列
        }

        //********************************
        //===== ファクトリ関連定義 ========
        //********************************
        // ToDo モデルファクトリＩＤを定義してください。
        /// <summary>モデルファクトリ識別子</summary>
        public static HySID DIMENSION_CONVERSION_LIB = new HySID("DimensionConversion_Factory");

        //********************************
        //===== モデル関連定義 ========
        //********************************
        // ToDo 提供するモデルの種別と名称を定義して下さい。
        /// <summary>モデル種別</summary>
        public static readonly HySObjectKind DIMENSION_CONVERSION_KIND = new HySObjectKind("McDimensionConversion_Model");
        /// <summary>モデル名称</summary>
        public static readonly HySString DIMENSION_CONVERSION_NAME = new HySString(Properties.McDimensionConversionResources.MODEL_DIMENSION_CONVERSION_NAME);


        //********************************
        //===== モデル個別定義 ========
        //********************************
        // ===============================
        // 受信パターン
        // ===============================
        /// <summary>ポイント時系列</summary>
        public static readonly HySID IN_PATTERN_SINGLE_CELL_SERIAL = new HySID("SingleCellSerialIn");
        /// <summary>1次元時系列</summary>
        public static readonly HySID IN_PATTERN_D1_CELL_SERIAL = new HySID("D1CellSerialIn");
        /// <summary> 2次元時系列</summary>
        public static readonly HySID IN_PATTERN_D2_CELL_SERIAL = new HySID("D2CellSerialIn");

        // ===============================
        // 送信パターン
        // ===============================
        /// <summary>ポイント時系列</summary>
        public static readonly HySID OUT_PATTERN_SINGLE_CELL_SERIAL = new HySID("SingleCellSerialOut");
        /// <summary>1次元時系列</summary>
        public static readonly HySID OUT_PATTERN_D1_CELL_SERIAL = new HySID("D1CellSerialOut");
        /// <summary> 2次元時系列</summary>
        public static readonly HySID OUT_PATTERN_D2_CELL_SERIAL = new HySID("D2CellSerialOut");
    }
}
