﻿// <summary>ソースコード：次元変換モデルファクトリクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>次元変換モデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/02/07][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }
        /// <summary><para>method outline:</para>
        /// <para>次元変換モデルファクトリインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.OptionImpl.McDimensionConversionForDevelop.McDimensionConversionFactory();
        }
    }
}

namespace CommonMP.HYMCO.OptionImpl.McDimensionConversionForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>次元変換モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/02/07][新規作成]</para>
    /// </remarks>
    public class McDimensionConversionFactory : McBasicModelFactoryBase
    {
        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return McDimensionConversionDefine.DIMENSION_CONVERSION_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McBasicCalculateModelBase csCalModel = null;

            if (csModelKind.Equals(McDimensionConversionDefine.DIMENSION_CONVERSION_KIND) == true)
            {
                csCalModel = new McDimensionConversionModel();
            }
            else
            {
                // Do Nothing
            }
            
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データインスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;

            if (csModelKind.Equals(McDimensionConversionDefine.DIMENSION_CONVERSION_KIND) == true)
            {
                csCalInfoData = new McDimensionConversionCalInfo();
            }
            else
            {
                // Do Nothing
            }

            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報インスタンス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = null;

            if (csModelKind.Equals(McDimensionConversionDefine.DIMENSION_CONVERSION_KIND) == true)
            {
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);

                csRtnCellPrptyDt.SetStepTime(60); // δT設定 60秒
                // 受信側
                csRtnCellPrptyDt.AddInfoType("m_lReceiveType",  // 受信側接続種別
                    Properties.McDimensionConversionResources.CONNECTION_TYPE_RECEIVER, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lReceiveType", (long)McDimensionConversionDefine.DimensionType.SingleCellSerial);
                csRtnCellPrptyDt.AddInfoType("m_lReceiveDataPosDim1",   // 受信側1次元位置
                    Properties.McDimensionConversionResources.ONE_DIMENSIONAL_POSITION_RECEIVER, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lReceiveDataPosDim1", 0);
                csRtnCellPrptyDt.AddInfoType("m_lReceiveDataPosDim2",   // 受信側2次元位置
                    Properties.McDimensionConversionResources.TWO_DIMENSIONAL_POSITION_RECEIVER, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lReceiveDataPosDim2", 0);

                // 送信側
                csRtnCellPrptyDt.AddInfoType("m_lSendType", // 送信側接続種別
                    Properties.McDimensionConversionResources.CONNECTION_TYPE_SENDER, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lSendType", (long)McDimensionConversionDefine.DimensionType.D1CellSerial);
                csRtnCellPrptyDt.AddInfoType("m_lSendDataPosDim1",
                    Properties.McDimensionConversionResources.ONE_DIMENSIONAL_POSITION_SENDER, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lSendDataPosDim1", 0);
                csRtnCellPrptyDt.AddInfoType("m_lSendDataPosDim2",
                    Properties.McDimensionConversionResources.TWO_DIMENSIONAL_POSITION_SENDER, McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo("m_lSendDataPosDim2", 0);

                // 受信可能なパターン
                {
                    // ポイント時系列
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDimensionConversionDefine.IN_PATTERN_SINGLE_CELL_SERIAL,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McDimensionConversionResources.ANY_INPUT) as McTranInfoPattern;   // 任意入力
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McDimensionConversionResources.ANY_INPUT, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.NO_INTERPOLATE);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                    // 1次元時系列
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDimensionConversionDefine.IN_PATTERN_D1_CELL_SERIAL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.McDimensionConversionResources.ANY_INPUT) as McTranInfoPattern;   // 任意入力
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McDimensionConversionResources.ANY_INPUT, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.NO_INTERPOLATE);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);

                    // 2次元時系列
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDimensionConversionDefine.IN_PATTERN_D2_CELL_SERIAL,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        Properties.McDimensionConversionResources.ANY_INPUT) as McTranInfoPattern;  // 任意入力
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McDimensionConversionResources.ANY_INPUT, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.NO_INTERPOLATE);
                    }
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
                }

                // 送信パターンの設定
                {
                    // ポイント時系列
                    McTranInfoPattern csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDimensionConversionDefine.OUT_PATTERN_SINGLE_CELL_SERIAL,
                        McTranInfoDefine.SINGLE_CELL_SERIAL,
                        Properties.McDimensionConversionResources.ANY_OUTPUT) as McTranInfoPattern;   // 任意出力
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McDimensionConversionResources.ANY_OUTPUT, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 1次元時系列
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDimensionConversionDefine.OUT_PATTERN_D1_CELL_SERIAL,
                        McTranInfoDefine.D1_CELL_SERIAL,
                        Properties.McDimensionConversionResources.ANY_OUTPUT) as McTranInfoPattern;   // 任意出力
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McDimensionConversionResources.ANY_OUTPUT, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // 2次元時系列
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(
                        McDimensionConversionDefine.OUT_PATTERN_D2_CELL_SERIAL,
                        McTranInfoDefine.D2_CELL_SERIAL,
                        Properties.McDimensionConversionResources.ANY_OUTPUT) as McTranInfoPattern;   // 任意出力
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(1);
                        {
                            csCellChara.SetDataKind(0, Properties.McDimensionConversionResources.ANY_OUTPUT, HySDataKindDefine.ANY_VALUE, "Arbitrary Unit");
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                }
            }
            else
            {
                // Do Noghing
            }

            return csRtnCellPrptyDt;
        }
        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報情報インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = null;

            if (csModelKind.Equals(McDimensionConversionDefine.DIMENSION_CONVERSION_KIND) == true)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            {
                // Do Nothing
            }

            return csRtnDt;
        }

        /// <summary>
        /// <para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo=null;

            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL,    // <-- 演算モデルは、必ずこの値にして下さい
                    McModelLibraryDefine.MODEL_CLASSIFICATION_CAL_ETC, // <-- LibraryCategoryXML.xmlに定義されている値を使用する
                    McDimensionConversionDefine.DIMENSION_CONVERSION_KIND, // モデルの識別子
                    McDimensionConversionDefine.DIMENSION_CONVERSION_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf(Properties.McDimensionConversionResources.MODEL_DIMENSION_CONVERSION_SUMMARY);
            csModelInfo.SetCreatorInf(Properties.McDimensionConversionResources.MODEL_DEVELOPERS_NAME);
            csModelInfo.SetIconName(new HySString("DefaultModel"));

            m_csCalModelInforList.AddLast(csModelInfo); // 演算モデル情報の追加

            return m_csCalModelInforList;
        }

    }
}
