﻿// <summary>ソースコード：次元変換モデル演算データクラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

namespace CommonMP.HYMCO.OptionImpl.McDimensionConversionForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>次元変換モデル演算データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2012/02/07][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class McDimensionConversionCalInfo : McCalInfo
    {
        /// <summary>受信側接続種別</summary>
        public long m_lReceiveType;
        /// <summary>受信側1次元位置</summary>
        public long m_lReceiveDataPosDim1;
        /// <summary>受信側2次元位置</summary>
        public long m_lReceiveDataPosDim2;
        /// <summary>受信側接続種別</summary>
        public long m_lSendType;
        /// <summary>送信側1次元位置</summary>
        public long m_lSendDataPosDim1;
        /// <summary>送信側2次元位置</summary>
        public long m_lSendDataPosDim2;
        /// <summary>データ</summary>
        public double m_dData;

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            McDimensionConversionCalInfo csRtn = new McDimensionConversionCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            McDimensionConversionCalInfo csOrdDt = (McDimensionConversionCalInfo)csOrgInfo;

            this.m_lReceiveType = csOrdDt.m_lReceiveType;
            this.m_lReceiveDataPosDim1 = csOrdDt.m_lReceiveDataPosDim1;
            this.m_lReceiveDataPosDim2 = csOrdDt.m_lReceiveDataPosDim2;

            this.m_lSendType = csOrdDt.m_lSendType;
            this.m_lSendDataPosDim1 = csOrdDt.m_lSendDataPosDim1;
            this.m_lSendDataPosDim2 = csOrdDt.m_lSendDataPosDim2;

            return true;
        }

    }
}
